/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.util.LocalTimeCounter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NewVirtualFile
extends VirtualFile
implements VirtualFileWithId {
    private volatile long myModificationStamp = LocalTimeCounter.currentTime();

    @Override
    public boolean isValid() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return this.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public byte[] contentsToByteArray() throws IOException {
        byte[] bytes;
        InputStream is = this.getInputStream();
        try {
            bytes = FileUtil.adaptiveLoadBytes((InputStream)is);
        }
        finally {
            is.close();
        }
        if (bytes == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/newvfs/NewVirtualFile.contentsToByteArray must not return null");
        }
        return bytes;
    }

    @Override
    @NotNull
    public abstract NewVirtualFileSystem getFileSystem();

    @Override
    public abstract NewVirtualFile getParent();

    @Override
    @Nullable
    public abstract NewVirtualFile findChild(@NotNull @NonNls String var1);

    @Nullable
    public abstract NewVirtualFile refreshAndFindChild(String var1);

    @Nullable
    public abstract NewVirtualFile findChildIfCached(String var1);

    public abstract void setTimeStamp(long var1) throws IOException;

    @Override
    public abstract int getId();

    @Nullable
    public abstract NewVirtualFile findChildById(int var1);

    @Override
    public void refresh(boolean asynchronous, boolean recursive, Runnable postRunnable) {
        RefreshQueue.getInstance().refresh(asynchronous, recursive, postRunnable, this);
    }

    @Override
    public long getModificationStamp() {
        return this.myModificationStamp;
    }

    public void setModificationStamp(long modificationStamp) {
        this.myModificationStamp = modificationStamp;
    }

    public abstract void setWritable(boolean var1) throws IOException;

    public abstract void markDirty();

    public abstract void markDirtyRecursively();

    public abstract boolean isDirty();

    public abstract void markClean();

    @Override
    public void move(final Object requestor, final VirtualFile newParent) throws IOException {
        if (!this.exists()) {
            throw new IOException("File to move does not exist: " + this.getPath());
        }
        if (!newParent.exists()) {
            throw new IOException("Destination folder does not exist: " + newParent.getPath());
        }
        if (!newParent.isDirectory()) {
            throw new IOException("Destination is not a folder: " + newParent.getPath());
        }
        VirtualFile child = newParent.findChild(this.getName());
        if (child != null) {
            throw new IOException("Destination already exists: " + newParent.getPath() + "/" + this.getName());
        }
        VfsUtil.doActionAndRestoreEncoding(this, new ThrowableComputable<VirtualFile, IOException>(){

            public VirtualFile compute() throws IOException {
                NewVirtualFile.this.getFileSystem().moveFile(requestor, NewVirtualFile.this, newParent);
                return NewVirtualFile.this;
            }
        });
    }

    public abstract Collection<VirtualFile> getCachedChildren();

    @NotNull
    public abstract Collection<VirtualFile> getInDbChildren();

    public abstract void setFlag(int var1, boolean var2);

    public abstract boolean getFlag(int var1);
}

