/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff;

import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.LineTokenizer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BinaryContent
extends DiffContent {
    private final FileType myFileType;
    private final byte[] myBytes;
    private final Charset myCharset;
    private Document myDocument;

    public BinaryContent(byte[] bytes, Charset charset, @NotNull FileType fileType) {
        if (fileType == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/diff/BinaryContent.<init> must not be null");
        }
        this.myDocument = null;
        this.myFileType = fileType;
        this.myBytes = bytes;
        this.myCharset = fileType.isBinary() ? null : charset;
    }

    @Override
    @Nullable
    public Document getDocument() {
        if (this.myDocument == null) {
            if (this.isBinary()) {
                return null;
            }
            String text = null;
            try {
                text = this.myCharset == null ? new String(this.myBytes) : new String(this.myBytes, this.myCharset.name());
            }
            catch (IllegalCharsetNameException e) {
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            if (text == null) {
                text = new String(this.myBytes);
            }
            text = LineTokenizer.correctLineSeparators(text);
            this.myDocument = EditorFactory.getInstance().createDocument(text);
            this.myDocument.setReadOnly(true);
        }
        return this.myDocument;
    }

    @Override
    public OpenFileDescriptor getOpenFileDescriptor(int offset) {
        return null;
    }

    @Override
    public VirtualFile getFile() {
        return null;
    }

    @Override
    public FileType getContentType() {
        return this.myFileType;
    }

    @Override
    public byte[] getBytes() throws IOException {
        return this.myBytes;
    }

    @Override
    public boolean isBinary() {
        return this.myCharset == null;
    }
}

