/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.AbstractTreeUpdater;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.SelectionRequest;
import com.intellij.ide.util.treeView.TreeBuilderUtil;
import com.intellij.ide.util.treeView.TreeUpdatePass;
import com.intellij.ide.util.treeView.UpdaterTreeState;
import com.intellij.ide.util.treeView.ValidateableNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Progressive;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.ActiveRunnable;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.BusyObject;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.MutualMap;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SimpleTimer;
import com.intellij.openapi.util.SimpleTimerTask;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.ui.LoadingNode;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.concurrency.WorkerThread;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.enumeration.EnumerationCopy;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractTreeUi {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.util.treeView.AbstractTreeBuilder");
    protected JTree myTree;
    protected DefaultTreeModel myTreeModel;
    private AbstractTreeStructure myTreeStructure;
    private AbstractTreeUpdater myUpdater;
    private Comparator<NodeDescriptor> myNodeDescriptorComparator;
    private final Comparator<TreeNode> myNodeComparator = new Comparator<TreeNode>(){

        @Override
        public int compare(TreeNode n1, TreeNode n2) {
            if (AbstractTreeUi.isLoadingNode(n1) || AbstractTreeUi.isLoadingNode(n2)) {
                return 0;
            }
            NodeDescriptor nodeDescriptor1 = AbstractTreeUi.this.getDescriptorFrom((DefaultMutableTreeNode)n1);
            NodeDescriptor nodeDescriptor2 = AbstractTreeUi.this.getDescriptorFrom((DefaultMutableTreeNode)n2);
            return AbstractTreeUi.this.myNodeDescriptorComparator != null ? AbstractTreeUi.this.myNodeDescriptorComparator.compare(nodeDescriptor1, nodeDescriptor2) : nodeDescriptor1.getIndex() - nodeDescriptor2.getIndex();
        }
    };
    long myOwnComparatorStamp;
    long myLastComparatorStamp;
    private DefaultMutableTreeNode myRootNode;
    private final HashMap<Object, Object> myElementToNodeMap = new HashMap();
    private final HashSet<DefaultMutableTreeNode> myUnbuiltNodes = new HashSet();
    private TreeExpansionListener myExpansionListener;
    private MySelectionListener mySelectionListener;
    private WorkerThread myWorker = null;
    private final Set<Runnable> myActiveWorkerTasks = new HashSet();
    private ProgressIndicator myProgress;
    private static final int WAIT_CURSOR_DELAY = 100;
    private AbstractTreeNode<Object> TREE_NODE_WRAPPER;
    private boolean myRootNodeWasQueuedToInitialize = false;
    private boolean myRootNodeInitialized = false;
    private final Map<Object, List<NodeAction>> myNodeActions = new HashMap<Object, List<NodeAction>>();
    private boolean myUpdateFromRootRequested;
    private boolean myWasEverShown;
    private boolean myUpdateIfInactive;
    private final Map<Object, UpdateInfo> myLoadedInBackground = new HashMap<Object, UpdateInfo>();
    private final Map<Object, List<NodeAction>> myNodeChildrenActions = new HashMap<Object, List<NodeAction>>();
    private long myClearOnHideDelay = -1L;
    private final Map<AbstractTreeUi, Long> ourUi2Countdown = Collections.synchronizedMap(new WeakHashMap());
    private final Set<Runnable> myDeferredSelections = new HashSet();
    private final Set<Runnable> myDeferredExpansions = new HashSet();
    private boolean myCanProcessDeferredSelections;
    private UpdaterTreeState myUpdaterState;
    private AbstractTreeBuilder myBuilder;
    private final Set<DefaultMutableTreeNode> myUpdatingChildren = new HashSet();
    private long myJanitorPollPeriod = 10000L;
    private boolean myCanYield = false;
    private final List<TreeUpdatePass> myYeildingPasses = new ArrayList<TreeUpdatePass>();
    private boolean myYeildingNow;
    private final Set<DefaultMutableTreeNode> myPendingNodeActions = new HashSet();
    private final Set<Runnable> myYeildingDoneRunnables = new HashSet();
    private final Alarm myBusyAlarm = new Alarm();
    private final Runnable myWaiterForReady = new Runnable(){

        @Override
        public void run() {
            AbstractTreeUi.this.maybeSetBusyAndScheduleWaiterForReady(false);
        }
    };
    private final RegistryValue myYeildingUpdate = Registry.get("ide.tree.yeildingUiUpdate");
    private final RegistryValue myShowBusyIndicator = Registry.get("ide.tree.showBusyIndicator");
    private final RegistryValue myWaitForReadyTime = Registry.get("ide.tree.waitForReadyTimeout");
    private boolean myWasEverIndexNotReady;
    private boolean myShowing;
    private final FocusAdapter myFocusListener = new FocusAdapter(){

        @Override
        public void focusGained(FocusEvent e) {
            AbstractTreeUi.this.maybeReady();
        }
    };
    private final Set<DefaultMutableTreeNode> myNotForSmartExpand = new HashSet();
    private TreePath myRequestedExpand;
    private TreePath mySilentExpand;
    private TreePath mySilentSelect;
    private final ActionCallback myInitialized = new ActionCallback();
    private BusyObject.Impl myBusyObject = new BusyObject.Impl(){

        @Override
        protected boolean isReady() {
            return AbstractTreeUi.this.isReady(true);
        }
    };
    private boolean myPassthroughMode = false;
    private final Set<Object> myAutoExpandRoots = new HashSet();
    private final RegistryValue myAutoExpandDepth = Registry.get("ide.tree.autoExpandMaxDepth");
    private final Set<DefaultMutableTreeNode> myWillBeExpaned = new HashSet();
    private SimpleTimerTask myCleanupTask;
    private AtomicBoolean myCancelRequest = new AtomicBoolean();
    private Lock myStateLock = new ReentrantLock();
    private AtomicBoolean myResettingToReadyNow = new AtomicBoolean();
    private Map<Progressive, ProgressIndicator> myBatchIndicators = new HashMap<Progressive, ProgressIndicator>();
    private Map<Progressive, ActionCallback> myBatchCallbacks = new HashMap<Progressive, ActionCallback>();
    private Map<DefaultMutableTreeNode, DefaultMutableTreeNode> myCancelledBuild = new WeakHashMap<DefaultMutableTreeNode, DefaultMutableTreeNode>();
    private boolean mySelectionIsAdjusted;
    private boolean myReleaseRequested;
    private Set<Object> myRevalidatedObjects = new HashSet();
    private Set<Runnable> myUserRunnables = new HashSet();
    private Alarm myMaybeReady = new Alarm();
    private Runnable myMaybeReadyRunnable = new Runnable(){

        @Override
        public void run() {
            AbstractTreeUi.this.maybeReady();
        }
    };

    protected void init(AbstractTreeBuilder builder, JTree tree, DefaultTreeModel treeModel, AbstractTreeStructure treeStructure, @Nullable Comparator<NodeDescriptor> comparator, boolean updateIfInactive) {
        this.myBuilder = builder;
        this.myTree = tree;
        this.myTreeModel = treeModel;
        this.addModelListenerToDianoseAccessOutsideEdt();
        this.TREE_NODE_WRAPPER = this.getBuilder().createSearchingTreeNodeWrapper();
        this.myTree.setModel(this.myTreeModel);
        this.setRootNode((DefaultMutableTreeNode)treeModel.getRoot());
        this.setTreeStructure(treeStructure);
        this.myNodeDescriptorComparator = comparator;
        this.myUpdateIfInactive = updateIfInactive;
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!AbstractTreeUi.this.wasRootNodeInitialized() && AbstractTreeUi.this.myRootNode.getChildCount() == 0) {
                    AbstractTreeUi.this.insertLoadingNode(AbstractTreeUi.this.myRootNode, true);
                }
            }
        });
        this.myExpansionListener = new MyExpansionListener();
        this.myTree.addTreeExpansionListener(this.myExpansionListener);
        this.mySelectionListener = new MySelectionListener();
        this.myTree.addTreeSelectionListener(this.mySelectionListener);
        this.setUpdater(this.getBuilder().createUpdater());
        this.myProgress = this.getBuilder().createProgressIndicator();
        Disposer.register((Disposable)this.getBuilder(), (Disposable)this.getUpdater());
        UiNotifyConnector uiNotify = new UiNotifyConnector(tree, new Activatable(){

            @Override
            public void showNotify() {
                AbstractTreeUi.this.myShowing = true;
                AbstractTreeUi.this.myWasEverShown = true;
                if (AbstractTreeUi.this.canInitiateNewActivity()) {
                    AbstractTreeUi.this.activate(true);
                }
            }

            @Override
            public void hideNotify() {
                AbstractTreeUi.this.myShowing = false;
                if (AbstractTreeUi.this.canInitiateNewActivity()) {
                    AbstractTreeUi.this.deactivate();
                }
            }
        });
        Disposer.register((Disposable)this.getBuilder(), (Disposable)uiNotify);
        this.myTree.addFocusListener(this.myFocusListener);
    }

    boolean isNodeActionsPending() {
        return !this.myNodeActions.isEmpty() || !this.myNodeChildrenActions.isEmpty();
    }

    private void clearNodeActions() {
        this.myNodeActions.clear();
        this.myNodeChildrenActions.clear();
    }

    private void maybeSetBusyAndScheduleWaiterForReady(boolean forcedBusy) {
        if (!this.myShowBusyIndicator.asBoolean() || !this.canYield()) {
            return;
        }
        if (this.myTree instanceof Tree) {
            boolean isBusy;
            Tree tree = (Tree)this.myTree;
            boolean bl = isBusy = !this.isReady(true) || forcedBusy;
            if (isBusy && tree.isShowing()) {
                tree.setPaintBusy(true);
                this.myBusyAlarm.cancelAllRequests();
                this.myBusyAlarm.addRequest(this.myWaiterForReady, this.myWaitForReadyTime.asInteger());
            } else {
                tree.setPaintBusy(false);
            }
        }
    }

    private void setHoldSize(boolean holdSize) {
        if (this.myTree instanceof Tree) {
            Tree tree = (Tree)this.myTree;
            tree.setHoldSize(holdSize);
        }
    }

    private void cleanUpAll() {
        AbstractTreeUi[] uis;
        long now = System.currentTimeMillis();
        for (AbstractTreeUi eachUi : uis = this.ourUi2Countdown.keySet().toArray(new AbstractTreeUi[this.ourUi2Countdown.size()])) {
            Long timeToCleanup;
            if (eachUi == null || (timeToCleanup = this.ourUi2Countdown.get(eachUi)) == null || now < timeToCleanup) continue;
            this.ourUi2Countdown.remove(eachUi);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (!AbstractTreeUi.this.canInitiateNewActivity()) {
                        return;
                    }
                    AbstractTreeUi.this.myCleanupTask = null;
                    AbstractTreeUi.this.getBuilder().cleanUp();
                }
            };
            if (this.isPassthroughMode()) {
                runnable.run();
                continue;
            }
            UIUtil.invokeLaterIfNeeded((Runnable)runnable);
        }
    }

    protected void doCleanUp() {
        Runnable cleanup = new Runnable(){

            @Override
            public void run() {
                if (AbstractTreeUi.this.canInitiateNewActivity()) {
                    AbstractTreeUi.this.cleanUpNow();
                }
            }
        };
        if (this.isPassthroughMode()) {
            cleanup.run();
        } else {
            UIUtil.invokeLaterIfNeeded((Runnable)cleanup);
        }
    }

    private ActionCallback invokeLaterIfNeeded(final @NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/util/treeView/AbstractTreeUi.invokeLaterIfNeeded must not be null");
        }
        final ActionCallback result = new ActionCallback();
        Runnable actual = new Runnable(){

            @Override
            public void run() {
                runnable.run();
                result.setDone();
            }
        };
        if (this.isPassthroughMode() || !this.isEdt() && !this.isTreeShowing() && !this.myWasEverShown) {
            actual.run();
        } else {
            UIUtil.invokeLaterIfNeeded((Runnable)actual);
        }
        return result;
    }

    public void activate(boolean byShowing) {
        this.cancelCurrentCleanupTask();
        this.myCanProcessDeferredSelections = true;
        this.ourUi2Countdown.remove(this);
        if (!this.myWasEverShown || this.myUpdateFromRootRequested || this.myUpdateIfInactive) {
            this.getBuilder().updateFromRoot();
        }
        this.getUpdater().showNotify();
        this.myWasEverShown |= byShowing;
    }

    private void cancelCurrentCleanupTask() {
        if (this.myCleanupTask != null) {
            this.myCleanupTask.cancel();
            this.myCleanupTask = null;
        }
    }

    public void deactivate() {
        this.getUpdater().hideNotify();
        this.myBusyAlarm.cancelAllRequests();
        if (!this.myWasEverShown) {
            return;
        }
        if (!this.isReady()) {
            this.cancelUpdate();
            this.myUpdateFromRootRequested = true;
        }
        if (this.getClearOnHideDelay() >= 0L) {
            this.ourUi2Countdown.put(this, System.currentTimeMillis() + this.getClearOnHideDelay());
            this.sheduleCleanUpAll();
        }
    }

    private void sheduleCleanUpAll() {
        this.cancelCurrentCleanupTask();
        this.myCleanupTask = SimpleTimer.getInstance().setUp(new Runnable(){

            @Override
            public void run() {
                AbstractTreeUi.this.cleanUpAll();
            }
        }, this.getClearOnHideDelay());
    }

    public void requestRelease() {
        this.myReleaseRequested = true;
        this.cancelUpdate().doWhenDone(new Runnable(){

            @Override
            public void run() {
                AbstractTreeUi.this.releaseNow();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseNow() {
        try {
            this.acquireLock();
            this.myTree.removeTreeExpansionListener(this.myExpansionListener);
            this.myTree.removeTreeSelectionListener(this.mySelectionListener);
            this.myTree.removeFocusListener(this.myFocusListener);
            this.disposeNode(this.getRootNode());
            this.myElementToNodeMap.clear();
            this.getUpdater().cancelAllRequests();
            if (this.myWorker != null) {
                this.myWorker.dispose(true);
                this.clearWorkerTasks();
            }
            this.TREE_NODE_WRAPPER.setValue(null);
            if (this.myProgress != null) {
                this.myProgress.cancel();
            }
            this.cancelCurrentCleanupTask();
            this.myTree = null;
            this.setUpdater(null);
            this.myWorker = null;
            this.myTreeStructure = null;
            this.myBuilder.releaseUi();
            this.myBuilder = null;
            this.clearNodeActions();
            this.myDeferredSelections.clear();
            this.myDeferredExpansions.clear();
            this.myYeildingDoneRunnables.clear();
        }
        catch (InterruptedException e) {
            LOG.info((Throwable)e);
        }
        finally {
            this.releaseLock();
        }
    }

    public boolean isReleased() {
        return this.myBuilder == null;
    }

    protected void doExpandNodeChildren(DefaultMutableTreeNode node) {
        if (!this.myUnbuiltNodes.contains((Object)node)) {
            return;
        }
        if (this.isLoadedInBackground(this.getElementFor(node))) {
            return;
        }
        this.getTreeStructure().commit();
        this.addSubtreeToUpdate(node);
        this.getUpdater().performUpdate();
    }

    public final AbstractTreeStructure getTreeStructure() {
        return this.myTreeStructure;
    }

    public final JTree getTree() {
        return this.myTree;
    }

    @Nullable
    private NodeDescriptor getDescriptorFrom(DefaultMutableTreeNode node) {
        return (NodeDescriptor)node.getUserObject();
    }

    @Nullable
    public final DefaultMutableTreeNode getNodeForElement(Object element, boolean validateAgainstStructure) {
        DefaultMutableTreeNode result = null;
        if (validateAgainstStructure) {
            DefaultMutableTreeNode node;
            int index = 0;
            while ((node = this.findNode(element, index)) != null) {
                if (this.isNodeValidForElement(element, node)) {
                    result = node;
                    break;
                }
                ++index;
            }
        } else {
            result = this.getFirstNode(element);
        }
        if (result != null && !this.isNodeInStructure(result)) {
            this.disposeNode(result);
            result = null;
        }
        return result;
    }

    private boolean isNodeInStructure(DefaultMutableTreeNode node) {
        return TreeUtil.isAncestor(this.getRootNode(), node) && this.getRootNode() == this.myTreeModel.getRoot();
    }

    private boolean isNodeValidForElement(Object element, DefaultMutableTreeNode node) {
        return this.isSameHierarchy(element, node) || this.isValidChildOfParent(element, node);
    }

    private boolean isValidChildOfParent(Object element, DefaultMutableTreeNode node) {
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
        Object parentElement = this.getElementFor(parent);
        if (!this.isInStructure(parentElement)) {
            return false;
        }
        if (parent instanceof ElementNode) {
            return ((ElementNode)parent).isValidChild(element);
        }
        for (int i = 0; i < parent.getChildCount(); ++i) {
            TreeNode child = parent.getChildAt(i);
            Object eachElement = this.getElementFor(child);
            if (!element.equals(eachElement)) continue;
            return true;
        }
        return false;
    }

    private boolean isSameHierarchy(Object eachParent, DefaultMutableTreeNode eachParentNode) {
        boolean valid = true;
        while (true) {
            if (eachParent == null) {
                valid = eachParentNode == null;
                break;
            }
            if (!eachParent.equals(this.getElementFor(eachParentNode))) {
                valid = false;
                break;
            }
            eachParent = this.getTreeStructure().getParentElement(eachParent);
            eachParentNode = (DefaultMutableTreeNode)eachParentNode.getParent();
        }
        return valid;
    }

    public final DefaultMutableTreeNode getNodeForPath(Object[] path) {
        DefaultMutableTreeNode node = null;
        for (Object pathElement : path) {
            DefaultMutableTreeNode defaultMutableTreeNode = node = node == null ? this.getFirstNode(pathElement) : this.findNodeForChildElement(node, pathElement);
            if (node == null) break;
        }
        return node;
    }

    public final void buildNodeForElement(Object element) {
        this.getUpdater().performUpdate();
        DefaultMutableTreeNode node = this.getNodeForElement(element, false);
        if (node == null) {
            ArrayList<Object> elements = new ArrayList<Object>();
            while ((element = this.getTreeStructure().getParentElement(element)) != null) {
                elements.add(0, element);
            }
            for (Object e : elements) {
                node = this.getNodeForElement(e, false);
                if (node == null) continue;
                this.expand(node, true);
            }
        }
    }

    public final void buildNodeForPath(Object[] path) {
        this.getUpdater().performUpdate();
        DefaultMutableTreeNode node = null;
        for (Object pathElement : path) {
            DefaultMutableTreeNode defaultMutableTreeNode = node = node == null ? this.getFirstNode(pathElement) : this.findNodeForChildElement(node, pathElement);
            if (node == null || node == path[path.length - 1]) continue;
            this.expand(node, true);
        }
    }

    public final void setNodeDescriptorComparator(Comparator<NodeDescriptor> nodeDescriptorComparator) {
        this.myNodeDescriptorComparator = nodeDescriptorComparator;
        this.myLastComparatorStamp = -1L;
        this.getBuilder().queueUpdateFrom(this.getTreeStructure().getRootElement(), true);
    }

    protected AbstractTreeBuilder getBuilder() {
        return this.myBuilder;
    }

    protected final void initRootNode() {
        if (this.myUpdateIfInactive) {
            this.activate(false);
        } else {
            this.myUpdateFromRootRequested = true;
        }
    }

    private boolean initRootNodeNowIfNeeded(final TreeUpdatePass pass) {
        boolean wasCleanedUp = false;
        if (this.myRootNodeWasQueuedToInitialize) {
            Object root = this.getTreeStructure().getRootElement();
            assert (root != null) : "Root element cannot be null";
            Object currentRoot = this.getElementFor(this.myRootNode);
            if (Comparing.equal((Object)root, (Object)currentRoot)) {
                return false;
            }
            Object rootAgain = this.getTreeStructure().getRootElement();
            if (root != rootAgain && !root.equals(rootAgain)) assert (false) : "getRootElement() if called twice must return either root1 == root2 or root1.equals(root2)";
            this.cleanUpNow();
            wasCleanedUp = true;
        }
        if (this.myRootNodeWasQueuedToInitialize) {
            return wasCleanedUp;
        }
        this.myRootNodeWasQueuedToInitialize = true;
        final Object rootElement = this.getTreeStructure().getRootElement();
        this.addNodeAction(rootElement, new NodeAction(){

            @Override
            public void onReady(DefaultMutableTreeNode node) {
                AbstractTreeUi.this.processDeferredActions();
            }
        }, false);
        final Ref rootDescriptor = new Ref(null);
        boolean bgLoading = this.getTreeStructure().isToBuildChildrenInBackground(rootElement);
        Runnable build = new Runnable(){

            @Override
            public void run() {
                rootDescriptor.set((Object)AbstractTreeUi.this.getTreeStructure().createDescriptor(rootElement, null));
                AbstractTreeUi.this.getRootNode().setUserObject(rootDescriptor.get());
                AbstractTreeUi.this.update((NodeDescriptor)rootDescriptor.get(), true);
            }
        };
        Runnable update = new Runnable(){

            @Override
            public void run() {
                if (AbstractTreeUi.this.getElementFromDescriptor((NodeDescriptor)rootDescriptor.get()) != null) {
                    AbstractTreeUi.this.createMapping(AbstractTreeUi.this.getElementFromDescriptor((NodeDescriptor)rootDescriptor.get()), AbstractTreeUi.this.getRootNode());
                }
                AbstractTreeUi.this.insertLoadingNode(AbstractTreeUi.this.getRootNode(), true);
                boolean willUpdate = false;
                if (AbstractTreeUi.this.isAutoExpand((NodeDescriptor)rootDescriptor.get())) {
                    willUpdate = AbstractTreeUi.this.myUnbuiltNodes.contains((Object)AbstractTreeUi.this.getRootNode());
                    AbstractTreeUi.this.expand(AbstractTreeUi.this.getRootNode(), true);
                }
                if (!willUpdate) {
                    AbstractTreeUi.this.updateNodeChildren(AbstractTreeUi.this.getRootNode(), pass, null, false, false, false, true);
                }
                if (AbstractTreeUi.this.getRootNode().getChildCount() == 0) {
                    AbstractTreeUi.this.myTreeModel.nodeChanged(AbstractTreeUi.this.getRootNode());
                }
            }
        };
        if (bgLoading) {
            this.queueToBackground(build, update, rootDescriptor).doWhenProcessed(new Runnable(){

                @Override
                public void run() {
                    AbstractTreeUi.this.myRootNodeInitialized = true;
                    AbstractTreeUi.this.processNodeActionsIfReady(AbstractTreeUi.this.myRootNode);
                }
            });
        } else {
            build.run();
            update.run();
            this.myRootNodeInitialized = true;
            this.processNodeActionsIfReady(this.myRootNode);
        }
        return wasCleanedUp;
    }

    private boolean isAutoExpand(NodeDescriptor descriptor) {
        return this.isAutoExpand(descriptor, true);
    }

    private boolean isAutoExpand(NodeDescriptor descriptor, boolean validate) {
        if (descriptor == null) {
            return false;
        }
        boolean autoExpand = this.getBuilder().isAutoExpandNode(descriptor);
        Object element = this.getElementFromDescriptor(descriptor);
        if (validate) {
            autoExpand = this.validateAutoExpand(autoExpand, element);
        }
        if (!autoExpand && !this.myTree.isRootVisible() && element != null && element.equals(this.getTreeStructure().getRootElement())) {
            return true;
        }
        return autoExpand;
    }

    private boolean validateAutoExpand(boolean autoExpand, Object element) {
        if (autoExpand) {
            int distance = this.getDistanceToAutoExpandRoot(element);
            if (distance < 0) {
                this.myAutoExpandRoots.add(element);
            } else if (distance >= this.myAutoExpandDepth.asInteger() - 1) {
                autoExpand = false;
            }
            if (autoExpand) {
                DefaultMutableTreeNode node = this.getNodeForElement(element, false);
                autoExpand = this.isInVisibleAutoExpandChain(node);
            }
        }
        return autoExpand;
    }

    private boolean isInVisibleAutoExpandChain(DefaultMutableTreeNode child) {
        for (TreeNode eachParent = child; eachParent != null; eachParent = eachParent.getParent()) {
            if (this.myRootNode == eachParent) {
                return true;
            }
            NodeDescriptor eachDescriptor = this.getDescriptorFrom((DefaultMutableTreeNode)eachParent);
            if (this.isAutoExpand(eachDescriptor, false)) continue;
            TreePath path = AbstractTreeUi.getPathFor(eachParent);
            return this.myWillBeExpaned.contains(path.getLastPathComponent()) || this.myTree.isExpanded(path) && this.myTree.isVisible(path);
        }
        return false;
    }

    private int getDistanceToAutoExpandRoot(Object element) {
        int distance = 0;
        Object eachParent = element;
        while (eachParent != null && !this.myAutoExpandRoots.contains(eachParent)) {
            eachParent = this.getTreeStructure().getParentElement(eachParent);
            ++distance;
        }
        return eachParent != null ? distance : -1;
    }

    private boolean isAutoExpand(DefaultMutableTreeNode node) {
        return this.isAutoExpand(this.getDescriptorFrom(node));
    }

    private AsyncResult<Boolean> update(final NodeDescriptor nodeDescriptor, boolean now) {
        final AsyncResult<Boolean> result = new AsyncResult<Boolean>();
        if (now || this.isPassthroughMode()) {
            return new AsyncResult<Boolean>().setDone(this._update(nodeDescriptor));
        }
        Object element = this.getElementFromDescriptor(nodeDescriptor);
        boolean bgLoading = this.getTreeStructure().isToBuildChildrenInBackground(element);
        boolean edt = this.isEdt();
        if (bgLoading) {
            if (edt) {
                final Ref changes = new Ref((Object)false);
                this.queueToBackground(new Runnable(){

                    @Override
                    public void run() {
                        changes.set((Object)AbstractTreeUi.this._update(nodeDescriptor));
                    }
                }, new Runnable(){

                    @Override
                    public void run() {
                        result.setDone(changes.get());
                    }
                }, nodeDescriptor);
            } else {
                result.setDone(this._update(nodeDescriptor));
            }
        } else if (edt || !this.myWasEverShown) {
            result.setDone(this._update(nodeDescriptor));
        } else {
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    AbstractTreeUi.this.execute(new Runnable(){

                        @Override
                        public void run() {
                            result.setDone(AbstractTreeUi.this._update(nodeDescriptor));
                        }
                    });
                }
            });
        }
        result.doWhenDone(new AsyncResult.Handler<Boolean>(){

            @Override
            public void run(Boolean changes) {
                if (changes.booleanValue()) {
                    long updateStamp = nodeDescriptor.getUpdateCount();
                    UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            TreePath path;
                            Object element = nodeDescriptor.getElement();
                            DefaultMutableTreeNode node = AbstractTreeUi.this.getNodeForElement(element, false);
                            if (node != null && (path = AbstractTreeUi.getPathFor(node)) != null && AbstractTreeUi.this.myTree.isVisible(path)) {
                                AbstractTreeUi.this.updateNodeImageAndPosition(node, false);
                            }
                        }
                    });
                }
            }
        });
        return result;
    }

    private boolean _update(final NodeDescriptor nodeDescriptor) {
        try {
            final Ref update = new Ref();
            try {
                this.acquireLock();
                this.execute(new Runnable(){

                    @Override
                    public void run() {
                        nodeDescriptor.setUpdateCount(nodeDescriptor.getUpdateCount() + 1L);
                        update.set((Object)AbstractTreeUi.this.getBuilder().updateNodeDescriptor(nodeDescriptor));
                    }
                });
            }
            catch (InterruptedException e) {
                throw new ProcessCanceledException();
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            finally {
                this.releaseLock();
            }
            return (Boolean)update.get();
        }
        catch (IndexNotReadyException e) {
            this.warnOnIndexNotReady();
            return false;
        }
    }

    private void assertIsDispatchThread() {
        if (this.isPassthroughMode()) {
            return;
        }
        if ((this.isTreeShowing() || this.myWasEverShown) && !this.isEdt()) {
            LOG.error("Must be in event-dispatch thread");
        }
    }

    private boolean isEdt() {
        return SwingUtilities.isEventDispatchThread();
    }

    private boolean isTreeShowing() {
        return this.myShowing;
    }

    private void assertNotDispatchThread() {
        if (this.isPassthroughMode()) {
            return;
        }
        if (this.isEdt()) {
            LOG.error("Must not be in event-dispatch thread");
        }
    }

    private void processDeferredActions() {
        this.processDeferredActions(this.myDeferredSelections);
        this.processDeferredActions(this.myDeferredExpansions);
    }

    private void processDeferredActions(Set<Runnable> actions) {
        Runnable[] runnables = actions.toArray(new Runnable[actions.size()]);
        actions.clear();
        for (Runnable runnable : runnables) {
            runnable.run();
        }
    }

    public ActionCallback queueUpdate(Object element) {
        try {
            AbstractTreeUpdater updater = this.getUpdater();
            if (updater == null) {
                return new ActionCallback.Rejected();
            }
            final ActionCallback result = new ActionCallback();
            DefaultMutableTreeNode node = this.getNodeForElement(element, false);
            if (node != null) {
                this.addSubtreeToUpdate(node);
            } else {
                this.addSubtreeToUpdate(this.getRootNode());
            }
            updater.runAfterUpdate(new Runnable(){

                @Override
                public void run() {
                    result.setDone();
                }
            });
            return result;
        }
        catch (ProcessCanceledException e) {
            return new ActionCallback.Rejected();
        }
    }

    public void doUpdateFromRoot() {
        this.updateSubtree(this.getRootNode(), false);
    }

    public ActionCallback doUpdateFromRootCB() {
        final ActionCallback cb = new ActionCallback();
        this.getUpdater().runAfterUpdate(new Runnable(){

            @Override
            public void run() {
                cb.setDone();
            }
        });
        this.updateSubtree(this.getRootNode(), false);
        return cb;
    }

    public final void updateSubtree(DefaultMutableTreeNode node, boolean canSmartExpand) {
        this.updateSubtree(new TreeUpdatePass(node), canSmartExpand);
    }

    public final void updateSubtree(TreeUpdatePass pass, boolean canSmartExpand) {
        if (this.getUpdater() != null) {
            this.getUpdater().addSubtreeToUpdate(pass);
        } else {
            this.updateSubtreeNow(pass, canSmartExpand);
        }
    }

    final void updateSubtreeNow(TreeUpdatePass pass, boolean canSmartExpand) {
        boolean invisible;
        this.maybeSetBusyAndScheduleWaiterForReady(true);
        this.setHoldSize(true);
        boolean consumed = this.initRootNodeNowIfNeeded(pass);
        if (consumed) {
            return;
        }
        DefaultMutableTreeNode node = pass.getNode();
        if (!(node.getUserObject() instanceof NodeDescriptor)) {
            return;
        }
        this.setUpdaterState(new UpdaterTreeState(this)).beforeSubtreeUpdate();
        boolean forceUpdate = true;
        TreePath path = AbstractTreeUi.getPathFor(node);
        boolean bl = invisible = !this.myTree.isExpanded(path) && (path.getParentPath() == null || !this.myTree.isExpanded(path.getParentPath()));
        if (invisible && this.myUnbuiltNodes.contains((Object)node)) {
            forceUpdate = false;
        }
        this.updateNodeChildren(node, pass, null, false, canSmartExpand, forceUpdate, false);
    }

    private boolean isToBuildInBackground(NodeDescriptor descriptor) {
        return this.getTreeStructure().isToBuildChildrenInBackground(this.getBuilder().getTreeStructureElement(descriptor));
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    UpdaterTreeState setUpdaterState(UpdaterTreeState state) {
        UpdaterTreeState updaterTreeState;
        if (this.myUpdaterState != null && this.myUpdaterState.equals(state)) {
            updaterTreeState = state;
            if (updaterTreeState == null) throw new IllegalStateException("@NotNull method com/intellij/ide/util/treeView/AbstractTreeUi.setUpdaterState must not return null");
            return updaterTreeState;
        }
        UpdaterTreeState oldState = this.myUpdaterState;
        if (oldState == null) {
            this.myUpdaterState = state;
            updaterTreeState = state;
            if (updaterTreeState == null) throw new IllegalStateException("@NotNull method com/intellij/ide/util/treeView/AbstractTreeUi.setUpdaterState must not return null");
            return updaterTreeState;
        }
        oldState.addAll(state);
        updaterTreeState = oldState;
        if (updaterTreeState != null) return updaterTreeState;
        throw new IllegalStateException("@NotNull method com/intellij/ide/util/treeView/AbstractTreeUi.setUpdaterState must not return null");
    }

    protected void doUpdateNode(final DefaultMutableTreeNode node) {
        if (!(node.getUserObject() instanceof NodeDescriptor)) {
            return;
        }
        final NodeDescriptor descriptor = this.getDescriptorFrom(node);
        final Object prevElement = this.getElementFromDescriptor(descriptor);
        if (prevElement == null) {
            return;
        }
        this.update(descriptor, false).doWhenDone(new AsyncResult.Handler<Boolean>(){

            @Override
            public void run(Boolean changes) {
                if (!AbstractTreeUi.this.isValid(descriptor) && AbstractTreeUi.this.isInStructure(prevElement)) {
                    AbstractTreeUi.this.getUpdater().addSubtreeToUpdateByElement(AbstractTreeUi.this.getTreeStructure().getParentElement(prevElement));
                    return;
                }
                if (changes.booleanValue()) {
                    AbstractTreeUi.this.updateNodeImageAndPosition(node, true);
                }
            }
        });
    }

    public Object getElementFromDescriptor(NodeDescriptor descriptor) {
        return this.getBuilder().getTreeStructureElement(descriptor);
    }

    private void updateNodeChildren(final DefaultMutableTreeNode node, final TreeUpdatePass pass, final @Nullable LoadedChildren loadedChildren, final boolean forcedNow, final boolean toSmartExpand, final boolean forceUpdate, final boolean descriptorIsUpToDate) {
        this.removeFromCancelled(node);
        this.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    boolean notRequiredToUpdateChildren;
                    AbstractTreeUi.this.getTreeStructure().commit();
                    NodeDescriptor descriptor = AbstractTreeUi.this.getDescriptorFrom(node);
                    if (descriptor == null) {
                        AbstractTreeUi.this.removeFromUnbuilt(node);
                        AbstractTreeUi.this.removeLoading(node, true);
                        return;
                    }
                    final boolean wasExpanded = AbstractTreeUi.this.myTree.isExpanded(new TreePath(node.getPath())) || AbstractTreeUi.this.isAutoExpand(node);
                    final boolean wasLeaf = node.getChildCount() == 0;
                    boolean bgBuild = AbstractTreeUi.this.isToBuildInBackground(descriptor);
                    boolean bl = notRequiredToUpdateChildren = !forcedNow && !wasExpanded;
                    if (notRequiredToUpdateChildren && forceUpdate && !wasExpanded) {
                        boolean alwaysPlus = AbstractTreeUi.this.getBuilder().isAlwaysShowPlus(descriptor);
                        notRequiredToUpdateChildren = alwaysPlus && wasLeaf ? false : alwaysPlus;
                    }
                    final Ref preloaded = new Ref((Object)loadedChildren);
                    boolean descriptorWasUpdated = descriptorIsUpToDate;
                    if (notRequiredToUpdateChildren) {
                        if (AbstractTreeUi.this.myUnbuiltNodes.contains((Object)node) && node.getChildCount() == 0) {
                            AbstractTreeUi.this.insertLoadingNode(node, true);
                        }
                        return;
                    }
                    if (!forcedNow && !bgBuild && AbstractTreeUi.this.myUnbuiltNodes.contains((Object)node)) {
                        if (!descriptorWasUpdated) {
                            AbstractTreeUi.this.update(descriptor, true);
                            descriptorWasUpdated = true;
                        }
                        if (AbstractTreeUi.this.processAlwaysLeaf(node)) {
                            return;
                        }
                        Pair unbuilt = AbstractTreeUi.this.processUnbuilt(node, descriptor, pass, wasExpanded, null);
                        if (((Boolean)unbuilt.getFirst()).booleanValue()) {
                            return;
                        }
                        preloaded.set(unbuilt.getSecond());
                    }
                    final boolean childForceUpdate = AbstractTreeUi.this.isChildNodeForceUpdate(node, forceUpdate, wasExpanded);
                    if (!forcedNow && AbstractTreeUi.this.isToBuildInBackground(descriptor)) {
                        if (AbstractTreeUi.this.processAlwaysLeaf(node)) {
                            return;
                        }
                        AbstractTreeUi.this.queueBackgroundUpdate(new UpdateInfo(descriptor, pass, AbstractTreeUi.this.canSmartExpand(node, toSmartExpand), wasExpanded, childForceUpdate, descriptorWasUpdated), node);
                        return;
                    }
                    if (!descriptorWasUpdated) {
                        AbstractTreeUi.this.update(descriptor, false).doWhenDone(new Runnable(){

                            @Override
                            public void run() {
                                if (AbstractTreeUi.this.processAlwaysLeaf(node)) {
                                    return;
                                }
                                AbstractTreeUi.this.updateNodeChildrenNow(node, pass, (LoadedChildren)preloaded.get(), toSmartExpand, wasExpanded, wasLeaf, childForceUpdate);
                            }
                        });
                    } else {
                        if (AbstractTreeUi.this.processAlwaysLeaf(node)) {
                            return;
                        }
                        AbstractTreeUi.this.updateNodeChildrenNow(node, pass, (LoadedChildren)preloaded.get(), toSmartExpand, wasExpanded, wasLeaf, childForceUpdate);
                    }
                }
                finally {
                    if (AbstractTreeUi.this.isReleased()) {
                        return;
                    }
                    AbstractTreeUi.this.processNodeActionsIfReady(node);
                }
            }
        }, node);
    }

    private boolean processAlwaysLeaf(DefaultMutableTreeNode node) {
        Object element = this.getElementFor(node);
        NodeDescriptor desc = this.getDescriptorFrom(node);
        if (desc == null) {
            return false;
        }
        if (this.getTreeStructure().isAlwaysLeaf(element)) {
            this.removeFromUnbuilt(node);
            this.removeLoading(node, true);
            if (node.getChildCount() > 0) {
                final TreeNode[] children = new TreeNode[node.getChildCount()];
                for (int i = 0; i < node.getChildCount(); ++i) {
                    children[i] = node.getChildAt(i);
                }
                if (this.isSelectionInside(node)) {
                    this.addSelectionPath(AbstractTreeUi.getPathFor(node), true, Condition.TRUE, null);
                }
                this.processInnerChange(new Runnable(){

                    @Override
                    public void run() {
                        for (TreeNode each : children) {
                            AbstractTreeUi.this.removeNodeFromParent((MutableTreeNode)each, true);
                            AbstractTreeUi.this.disposeNode((DefaultMutableTreeNode)each);
                        }
                    }
                });
            }
            this.removeFromUnbuilt(node);
            desc.setWasDeclaredAlwaysLeaf(true);
            this.processNodeActionsIfReady(node);
            return true;
        }
        boolean wasLeaf = desc.isWasDeclaredAlwaysLeaf();
        desc.setWasDeclaredAlwaysLeaf(false);
        if (wasLeaf) {
            this.insertLoadingNode(node, true);
        }
        return false;
    }

    private boolean isChildNodeForceUpdate(DefaultMutableTreeNode node, boolean parentForceUpdate, boolean parentExpanded) {
        TreePath path = AbstractTreeUi.getPathFor(node);
        return parentForceUpdate && (parentExpanded || this.myTree.isExpanded(path));
    }

    private void updateNodeChildrenNow(final DefaultMutableTreeNode node, final TreeUpdatePass pass, LoadedChildren preloadedChildren, boolean toSmartExpand, final boolean wasExpanded, boolean wasLeaf, final boolean forceUpdate) {
        if (!this.canInitiateNewActivity()) {
            throw new ProcessCanceledException();
        }
        final NodeDescriptor descriptor = this.getDescriptorFrom(node);
        final MutualMap<Object, Integer> elementToIndexMap = this.loadElementsFromStructure(descriptor, preloadedChildren);
        final LoadedChildren loadedChildren = preloadedChildren != null ? preloadedChildren : new LoadedChildren(elementToIndexMap.getKeys().toArray());
        this.addToUpdating(node);
        pass.setCurrentNode(node);
        final boolean canSmartExpand = this.canSmartExpand(node, toSmartExpand);
        this.removeFromUnbuilt(node);
        this.processExistingNodes(node, elementToIndexMap, pass, this.canSmartExpand(node, toSmartExpand), forceUpdate, wasExpanded, preloadedChildren).doWhenDone(new Runnable(){

            @Override
            public void run() {
                if (AbstractTreeUi.this.isDisposed(node)) {
                    AbstractTreeUi.this.removeFromUpdating(node);
                    return;
                }
                AbstractTreeUi.this.removeLoading(node, false);
                final boolean expanded = AbstractTreeUi.this.isExpanded(node, wasExpanded);
                if (expanded) {
                    AbstractTreeUi.this.myWillBeExpaned.add(node);
                } else {
                    AbstractTreeUi.this.myWillBeExpaned.remove(node);
                }
                AbstractTreeUi.this.collectNodesToInsert(descriptor, (MutualMap<Object, Integer>)elementToIndexMap, node, expanded, loadedChildren).doWhenDone(new AsyncResult.Handler<ArrayList<TreeNode>>(){

                    @Override
                    public void run(ArrayList<TreeNode> nodesToInsert) {
                        AbstractTreeUi.this.insertNodesInto(nodesToInsert, node);
                        AbstractTreeUi.this.updateNodesToInsert(nodesToInsert, pass, canSmartExpand, AbstractTreeUi.this.isChildNodeForceUpdate(node, forceUpdate, expanded));
                        AbstractTreeUi.this.removeLoading(node, false);
                        AbstractTreeUi.this.removeFromUpdating(node);
                        if (node.getChildCount() > 0 && expanded) {
                            AbstractTreeUi.this.expand(node, canSmartExpand);
                        }
                        Object element = AbstractTreeUi.this.getElementFor(node);
                        AbstractTreeUi.this.addNodeAction(element, new NodeAction(){

                            @Override
                            public void onReady(DefaultMutableTreeNode node) {
                                AbstractTreeUi.this.removeLoading(node, false);
                            }
                        }, false);
                        AbstractTreeUi.this.processNodeActionsIfReady(node);
                    }
                }).doWhenProcessed(new Runnable(){

                    @Override
                    public void run() {
                        AbstractTreeUi.this.myWillBeExpaned.remove(node);
                        AbstractTreeUi.this.removeFromUpdating(node);
                        AbstractTreeUi.this.processNodeActionsIfReady(node);
                    }
                });
            }
        }).doWhenRejected(new Runnable(){

            @Override
            public void run() {
                AbstractTreeUi.this.removeFromUpdating(node);
                AbstractTreeUi.this.processNodeActionsIfReady(node);
            }
        });
    }

    private boolean isDisposed(DefaultMutableTreeNode node) {
        return !node.isNodeAncestor((DefaultMutableTreeNode)this.myTree.getModel().getRoot());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expandSilently(TreePath path) {
        this.assertIsDispatchThread();
        try {
            this.mySilentExpand = path;
            this.getTree().expandPath(path);
        }
        finally {
            this.mySilentExpand = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSelectionSilently(TreePath path) {
        this.assertIsDispatchThread();
        try {
            this.mySilentSelect = path;
            this.getTree().getSelectionModel().addSelectionPath(path);
        }
        finally {
            this.mySilentSelect = null;
        }
    }

    private void expand(DefaultMutableTreeNode node, boolean canSmartExpand) {
        this.expand(new TreePath(node.getPath()), canSmartExpand);
    }

    private void expand(TreePath path, boolean canSmartExpand) {
        if (path == null) {
            return;
        }
        Object last = path.getLastPathComponent();
        boolean isLeaf = this.myTree.getModel().isLeaf(path.getLastPathComponent());
        boolean isRoot = last == this.myTree.getModel().getRoot();
        TreePath parent = path.getParentPath();
        if (isRoot && !this.myTree.isExpanded(path)) {
            if (this.myTree.isRootVisible() || this.myUnbuiltNodes.contains(last)) {
                this.insertLoadingNode((DefaultMutableTreeNode)last, false);
            }
            this.expandPath(path, canSmartExpand);
        } else if (this.myTree.isExpanded(path) || isLeaf && parent != null && this.myTree.isExpanded(parent) && !this.myUnbuiltNodes.contains(last) && !this.isCancelled(last)) {
            if (last instanceof DefaultMutableTreeNode) {
                this.processNodeActionsIfReady((DefaultMutableTreeNode)last);
            }
        } else if (isLeaf && (this.myUnbuiltNodes.contains(last) || this.isCancelled(last))) {
            this.insertLoadingNode((DefaultMutableTreeNode)last, true);
            this.expandPath(path, canSmartExpand);
        } else if (isLeaf && parent != null) {
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)parent.getLastPathComponent();
            if (parentNode != null) {
                this.addToUnbuilt(parentNode);
            }
            this.expandPath(parent, canSmartExpand);
        } else {
            this.expandPath(path, canSmartExpand);
        }
    }

    private void addToUnbuilt(DefaultMutableTreeNode node) {
        this.myUnbuiltNodes.add((Object)node);
    }

    private void removeFromUnbuilt(DefaultMutableTreeNode node) {
        this.myUnbuiltNodes.remove((Object)node);
    }

    private Pair<Boolean, LoadedChildren> processUnbuilt(final DefaultMutableTreeNode node, final NodeDescriptor descriptor, final TreeUpdatePass pass, final boolean isExpanded, final LoadedChildren loadedChildren) {
        final Ref result = new Ref();
        this.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (!isExpanded && AbstractTreeUi.this.getBuilder().isAlwaysShowPlus(descriptor)) {
                    result.set((Object)new Pair((Object)true, null));
                    return;
                }
                final Object element = AbstractTreeUi.this.getElementFor(node);
                AbstractTreeUi.this.addToUpdating(node);
                try {
                    boolean processed;
                    LoadedChildren children;
                    LoadedChildren loadedChildren2 = children = loadedChildren != null ? loadedChildren : new LoadedChildren(AbstractTreeUi.this.getChildrenFor(element));
                    if (children.getElements().size() == 0) {
                        AbstractTreeUi.this.removeFromUnbuilt(node);
                        AbstractTreeUi.this.removeLoading(node, true);
                        processed = true;
                    } else {
                        if (AbstractTreeUi.this.isAutoExpand(node)) {
                            AbstractTreeUi.this.addNodeAction(AbstractTreeUi.this.getElementFor(node), new NodeAction(){

                                @Override
                                public void onReady(DefaultMutableTreeNode node) {
                                    TreePath path = new TreePath(node.getPath());
                                    if (AbstractTreeUi.this.getTree().isExpanded(path) || children.getElements().size() == 0) {
                                        AbstractTreeUi.this.removeLoading(node, false);
                                    } else {
                                        AbstractTreeUi.this.maybeYeild(new ActiveRunnable(){

                                            @Override
                                            public ActionCallback run() {
                                                AbstractTreeUi.this.expand(element, null);
                                                return new ActionCallback.Done();
                                            }
                                        }, pass, node);
                                    }
                                }
                            }, false);
                        }
                        processed = false;
                    }
                    AbstractTreeUi.this.removeFromUpdating(node);
                    AbstractTreeUi.this.processNodeActionsIfReady(node);
                    result.set((Object)new Pair((Object)processed, (Object)children));
                }
                finally {
                    AbstractTreeUi.this.removeFromUpdating(node);
                }
            }
        });
        return (Pair)result.get();
    }

    private boolean removeIfLoading(TreeNode node) {
        if (AbstractTreeUi.isLoadingNode(node)) {
            this.moveSelectionToParentIfNeeded(node);
            this.removeNodeFromParent((MutableTreeNode)node, false);
            return true;
        }
        return false;
    }

    private void moveSelectionToParentIfNeeded(TreeNode node) {
        TreePath path = AbstractTreeUi.getPathFor(node);
        if (this.myTree.getSelectionModel().isPathSelected(path)) {
            TreePath parentPath = path.getParentPath();
            this.myTree.getSelectionModel().removeSelectionPath(path);
            if (parentPath != null) {
                this.myTree.getSelectionModel().addSelectionPath(parentPath);
            }
        }
    }

    private Object[] getChildrenFor(final Object element) {
        final Ref passOne = new Ref();
        try {
            this.acquireLock();
            this.execute(new Runnable(){

                @Override
                public void run() {
                    passOne.set((Object)AbstractTreeUi.this.getTreeStructure().getChildElements(element));
                }
            });
        }
        catch (IndexNotReadyException e) {
            this.warnOnIndexNotReady();
            Object[] objectArray = ArrayUtil.EMPTY_OBJECT_ARRAY;
            return objectArray;
        }
        catch (InterruptedException e) {
            throw new ProcessCanceledException();
        }
        finally {
            this.releaseLock();
        }
        if (!Registry.is("ide.tree.checkStructure")) {
            return (Object[])passOne.get();
        }
        Object[] passTwo = this.getTreeStructure().getChildElements(element);
        HashSet two = new HashSet(Arrays.asList(passTwo));
        if (((Object[])passOne.get()).length != passTwo.length) {
            LOG.error("AbstractTreeStructure.getChildren() must either provide same objects or new objects but with correct hashCode() and equals() methods. Wrong parent element=" + element);
        } else {
            for (Object eachInOne : (Object[])passOne.get()) {
                if (two.contains(eachInOne)) continue;
                LOG.error("AbstractTreeStructure.getChildren() must either provide same objects or new objects but with correct hashCode() and equals() methods. Wrong parent element=" + element);
                break;
            }
        }
        return (Object[])passOne.get();
    }

    private void warnOnIndexNotReady() {
        if (!this.myWasEverIndexNotReady) {
            this.myWasEverIndexNotReady = true;
            LOG.warn("Tree is not dumb-mode-aware; treeBuilder=" + this.getBuilder() + " treeStructure=" + this.getTreeStructure());
        }
    }

    private void updateNodesToInsert(ArrayList<TreeNode> nodesToInsert, TreeUpdatePass pass, boolean canSmartExpand, boolean forceUpdate) {
        for (TreeNode aNodesToInsert : nodesToInsert) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)aNodesToInsert;
            this.updateNodeChildren(childNode, pass, null, false, canSmartExpand, forceUpdate, true);
        }
    }

    private ActionCallback processExistingNodes(final DefaultMutableTreeNode node, final MutualMap<Object, Integer> elementToIndexMap, final TreeUpdatePass pass, final boolean canSmartExpand, final boolean forceUpdate, final boolean wasExpaned, final LoadedChildren preloaded) {
        final ArrayList<TreeNode> childNodes = TreeUtil.childrenToArray(node);
        return this.maybeYeild(new ActiveRunnable(){

            @Override
            public ActionCallback run() {
                if (pass.isExpired()) {
                    return new ActionCallback.Rejected();
                }
                if (childNodes.size() == 0) {
                    return new ActionCallback.Done();
                }
                ActionCallback result = new ActionCallback(childNodes.size());
                for (TreeNode each : childNodes) {
                    final DefaultMutableTreeNode eachChild = (DefaultMutableTreeNode)each;
                    if (AbstractTreeUi.isLoadingNode(eachChild)) {
                        result.setDone();
                        continue;
                    }
                    final boolean childForceUpdate = AbstractTreeUi.this.isChildNodeForceUpdate(eachChild, forceUpdate, wasExpaned);
                    AbstractTreeUi.this.maybeYeild(new ActiveRunnable(){

                        @Override
                        public ActionCallback run() {
                            return AbstractTreeUi.this.processExistingNode(eachChild, AbstractTreeUi.this.getDescriptorFrom(eachChild), node, (MutualMap<Object, Integer>)elementToIndexMap, pass, canSmartExpand, childForceUpdate, preloaded);
                        }
                    }, pass, node).notify(result);
                    if (!result.isRejected()) continue;
                    break;
                }
                return result;
            }
        }, pass, node);
    }

    private boolean isRerunNeeded(TreeUpdatePass pass) {
        if (pass.isExpired() || !this.canInitiateNewActivity()) {
            return false;
        }
        boolean rerunBecauseTreeIsHidden = !pass.isExpired() && !this.isTreeShowing() && this.getUpdater().isInPostponeMode();
        return rerunBecauseTreeIsHidden || this.getUpdater().isRerunNeededFor(pass);
    }

    private ActionCallback maybeYeild(final ActiveRunnable processRunnable, final TreeUpdatePass pass, DefaultMutableTreeNode node) {
        final ActionCallback result = new ActionCallback();
        if (this.isRerunNeeded(pass)) {
            this.getUpdater().addSubtreeToUpdate(pass);
            result.setRejected();
        } else if (this.isToYieldUpdateFor(node)) {
            pass.setCurrentNode(node);
            boolean wasRun = this.yieldAndRun(new Runnable(){

                @Override
                public void run() {
                    if (pass.isExpired()) {
                        result.setRejected();
                        return;
                    }
                    if (AbstractTreeUi.this.isRerunNeeded(pass)) {
                        AbstractTreeUi.this.runDone(new Runnable(){

                            @Override
                            public void run() {
                                if (!pass.isExpired()) {
                                    AbstractTreeUi.this.getUpdater().addSubtreeToUpdate(pass);
                                }
                            }
                        });
                        result.setRejected();
                    } else {
                        try {
                            AbstractTreeUi.this.execute(processRunnable).notify(result);
                        }
                        catch (ProcessCanceledException e) {
                            pass.expire();
                            result.setRejected();
                            AbstractTreeUi.this.cancelUpdate();
                        }
                    }
                }
            }, pass);
            if (!wasRun) {
                result.setRejected();
            }
        } else {
            try {
                this.execute(processRunnable).notify(result);
            }
            catch (ProcessCanceledException e) {
                pass.expire();
                result.setRejected();
                this.cancelUpdate();
            }
        }
        return result;
    }

    private ActionCallback execute(final ActiveRunnable runnable) throws ProcessCanceledException {
        final ActionCallback result = new ActionCallback();
        this.execute(new Runnable(){

            @Override
            public void run() {
                runnable.run().notify(result);
            }
        });
        return result;
    }

    private void execute(Runnable runnable) {
        this.execute(runnable, null);
    }

    private void execute(Runnable runnable, @Nullable DefaultMutableTreeNode node) throws ProcessCanceledException {
        try {
            if (!this.canInitiateNewActivity()) {
                throw new ProcessCanceledException();
            }
            runnable.run();
            if (!this.canInitiateNewActivity()) {
                throw new ProcessCanceledException();
            }
        }
        catch (ProcessCanceledException e) {
            if (node != null) {
                this.addToCancelled(node);
            }
            if (!this.isReleased()) {
                this.setCancelRequested(true);
                this.resetToReady();
            }
            throw e;
        }
    }

    private boolean canInitiateNewActivity() {
        return !this.isCancelProcessed() && !this.myReleaseRequested && !this.isReleased();
    }

    private ActionCallback resetToReady() {
        final ActionCallback result = new ActionCallback();
        if (this.isReady()) {
            result.setDone();
            return result;
        }
        if (this.myResettingToReadyNow.get()) {
            this.getReady(this).notify(result);
            return result;
        }
        this.myResettingToReadyNow.set(true);
        this.invokeLaterIfNeeded(new Runnable(){

            @Override
            public void run() {
                Progressive[] progressives;
                if (!AbstractTreeUi.this.myResettingToReadyNow.get()) {
                    result.setDone();
                    return;
                }
                for (Progressive each : progressives = AbstractTreeUi.this.myBatchIndicators.keySet().toArray(new Progressive[AbstractTreeUi.this.myBatchIndicators.size()])) {
                    ((ProgressIndicator)AbstractTreeUi.this.myBatchIndicators.remove(each)).cancel();
                    ((ActionCallback)AbstractTreeUi.this.myBatchCallbacks.remove(each)).setRejected();
                }
                AbstractTreeUi.this.resetToReadyNow().notify(result);
            }
        });
        return result;
    }

    private ActionCallback resetToReadyNow() {
        Object[] bg;
        DefaultMutableTreeNode[] uc;
        if (this.isReleased()) {
            return new ActionCallback.Rejected();
        }
        this.assertIsDispatchThread();
        for (DefaultMutableTreeNode each : uc = this.myUpdatingChildren.toArray(new DefaultMutableTreeNode[this.myUpdatingChildren.size()])) {
            this.resetIncompleteNode(each);
        }
        for (Object each : bg = this.myLoadedInBackground.keySet().toArray(new Object[this.myLoadedInBackground.size()])) {
            this.resetIncompleteNode(this.getNodeForElement(each, false));
        }
        this.myUpdaterState = null;
        this.getUpdater().reset();
        this.myYeildingNow = false;
        this.myYeildingPasses.clear();
        this.myYeildingDoneRunnables.clear();
        this.myNodeActions.clear();
        this.myNodeChildrenActions.clear();
        this.myUpdatingChildren.clear();
        this.myLoadedInBackground.clear();
        this.myDeferredExpansions.clear();
        this.myDeferredSelections.clear();
        ActionCallback result = this.getReady(this);
        result.doWhenDone(new Runnable(){

            @Override
            public void run() {
                AbstractTreeUi.this.myResettingToReadyNow.set(false);
                AbstractTreeUi.this.setCancelRequested(false);
            }
        });
        this.maybeReady();
        return result;
    }

    public void addToCancelled(DefaultMutableTreeNode node) {
        this.myCancelledBuild.put(node, node);
    }

    public void removeFromCancelled(DefaultMutableTreeNode node) {
        this.myCancelledBuild.remove(node);
    }

    public boolean isCancelled(Object node) {
        if (node instanceof DefaultMutableTreeNode) {
            return this.myCancelledBuild.containsKey((DefaultMutableTreeNode)node);
        }
        return false;
    }

    private void resetIncompleteNode(DefaultMutableTreeNode node) {
        if (this.myReleaseRequested) {
            return;
        }
        this.addToCancelled(node);
        if (!this.isExpanded(node, false)) {
            node.removeAllChildren();
            if (!this.getTreeStructure().isAlwaysLeaf(this.getElementFor(node))) {
                this.insertLoadingNode(node, true);
            }
        } else {
            this.removeFromUnbuilt(node);
            this.removeLoading(node, true);
        }
    }

    private boolean yieldAndRun(final Runnable runnable, final TreeUpdatePass pass) {
        this.myYeildingPasses.add(pass);
        this.myYeildingNow = true;
        this.yield(new Runnable(){

            @Override
            public void run() {
                if (AbstractTreeUi.this.isReleased()) {
                    return;
                }
                AbstractTreeUi.this.runOnYieldingDone(new Runnable(){

                    @Override
                    public void run() {
                        if (AbstractTreeUi.this.isReleased()) {
                            return;
                        }
                        AbstractTreeUi.this.executeYieldingRequest(runnable, pass);
                    }
                });
            }
        });
        return true;
    }

    public boolean isYeildingNow() {
        return this.myYeildingNow;
    }

    private boolean hasSheduledUpdates() {
        return this.getUpdater().hasNodesToUpdate();
    }

    public boolean isReady() {
        return this.isReady(false);
    }

    public boolean isCancelledReady() {
        return this.isReady(false) && this.myCancelledBuild.size() > 0;
    }

    public boolean isReady(boolean attempt) {
        Boolean ready = this._isReady(attempt);
        return ready != null && ready != false;
    }

    @Nullable
    public Boolean _isReady(boolean attempt) {
        Boolean ready = this.checkValue(new Computable<Boolean>(){

            public Boolean compute() {
                return AbstractTreeUi.this.isIdle() && !AbstractTreeUi.this.hasPendingWork() && !AbstractTreeUi.this.isNodeActionsPending();
            }
        }, attempt, null);
        return ready != null && ready != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean checkValue(Computable<Boolean> computable, boolean attempt, Boolean defaultValue) {
        boolean toRelease = true;
        try {
            if (attempt) {
                if (!this.attemptLock()) {
                    toRelease = false;
                    Boolean bl = defaultValue != null ? defaultValue : (Boolean)computable.compute();
                    return bl;
                }
            } else {
                this.acquireLock();
            }
            Boolean bl = (Boolean)computable.compute();
            return bl;
        }
        catch (InterruptedException e) {
            LOG.info((Throwable)e);
            Boolean bl = defaultValue;
            return bl;
        }
        finally {
            if (toRelease) {
                this.releaseLock();
            }
        }
    }

    public String getStatus() {
        return "isReady=" + this.isReady() + "\n" + " isIdle=" + this.isIdle() + "\n" + "  isYeildingNow=" + this.isYeildingNow() + "\n" + "  isWorkerBusy=" + this.isWorkerBusy() + "\n" + "  hasUpdatingNow=" + this.hasUpdatingNow() + "\n" + "  isLoadingInBackgroundNow=" + this.isLoadingInBackgroundNow() + "\n" + " hasPendingWork=" + this.hasPendingWork() + "\n" + "  hasNodesToUpdate=" + this.hasNodesToUpdate() + "\n" + "  updaterState=" + this.myUpdaterState + "\n" + "  hasScheduledUpdates=" + this.hasSheduledUpdates() + "\n" + "  isPostponedMode=" + this.getUpdater().isInPostponeMode() + "\n" + " nodeActions=" + this.myNodeActions.keySet() + "\n" + " nodeChildrenActions=" + this.myNodeChildrenActions.keySet() + "\n" + "isReleased=" + this.isReleased() + "\n" + " isReleaseRequested=" + this.isReleaseRequested() + "\n" + "isCancelProcessed=" + this.isCancelProcessed() + "\n" + " isCancelRequested=" + this.myCancelRequest + "\n" + " isResettingToReadyNow=" + this.myResettingToReadyNow + "\n" + "canInitiateNewActivity=" + this.canInitiateNewActivity();
    }

    public boolean hasPendingWork() {
        return this.hasNodesToUpdate() || this.myUpdaterState != null && this.myUpdaterState.isProcessingNow() || this.hasSheduledUpdates() && !this.getUpdater().isInPostponeMode();
    }

    public boolean isIdle() {
        return !this.isYeildingNow() && !this.isWorkerBusy() && !this.hasUpdatingNow() && !this.isLoadingInBackgroundNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeYieldingRequest(Runnable runnable, TreeUpdatePass pass) {
        try {
            try {
                this.myYeildingPasses.remove(pass);
                if (!this.canInitiateNewActivity()) {
                    throw new ProcessCanceledException();
                }
                runnable.run();
            }
            finally {
                if (!this.isReleased()) {
                    this.maybeYeildingFinished();
                }
            }
        }
        catch (ProcessCanceledException e) {
            this.resetToReady();
        }
    }

    private void maybeYeildingFinished() {
        if (this.myYeildingPasses.size() == 0) {
            this.myYeildingNow = false;
            this.flushPendingNodeActions();
        }
    }

    void maybeReady() {
        this.assertIsDispatchThread();
        if (this.isReleased()) {
            return;
        }
        Boolean ready = this._isReady(true);
        if (ready != null && ready.booleanValue()) {
            this.myRevalidatedObjects.clear();
            this.setCancelRequested(false);
            this.myResettingToReadyNow.set(false);
            this.myInitialized.setDone();
            if (this.canInitiateNewActivity() && this.myUpdaterState != null && !this.myUpdaterState.isProcessingNow()) {
                UpdaterTreeState oldState = this.myUpdaterState;
                if (!this.myUpdaterState.restore(null)) {
                    this.setUpdaterState(oldState);
                }
                if (!this.isReady()) {
                    return;
                }
            }
            this.setHoldSize(false);
            if (this.myTree.isShowing() && this.getBuilder().isToEnsureSelectionOnFocusGained() && Registry.is("ide.tree.ensureSelectionOnFocusGained")) {
                TreeUtil.ensureSelection(this.myTree);
            }
            if (this.myInitialized.isDone()) {
                this.myBusyObject.onReady();
            }
            if (this.canInitiateNewActivity()) {
                TreePath[] selection = this.getTree().getSelectionPaths();
                Rectangle visible = this.getTree().getVisibleRect();
                if (selection != null) {
                    for (TreePath each : selection) {
                        Rectangle bounds = this.getTree().getPathBounds(each);
                        if (bounds == null || !visible.contains(bounds) && !visible.intersects(bounds)) continue;
                        this.getTree().repaint(bounds);
                    }
                }
            }
        } else if (ready == null) {
            this.scheduleMaybeReady();
        }
    }

    private void scheduleMaybeReady() {
        this.myMaybeReady.cancelAllRequests();
        this.myMaybeReady.addRequest(this.myMaybeReadyRunnable, Registry.intValue("ide.tree.waitForReadySchedule"));
    }

    private void flushPendingNodeActions() {
        Runnable[] actions;
        DefaultMutableTreeNode[] nodes = this.myPendingNodeActions.toArray(new DefaultMutableTreeNode[this.myPendingNodeActions.size()]);
        this.myPendingNodeActions.clear();
        for (DefaultMutableTreeNode each : nodes) {
            this.processNodeActionsIfReady(each);
        }
        for (Runnable each : actions = this.myYeildingDoneRunnables.toArray(new Runnable[this.myYeildingDoneRunnables.size()])) {
            if (this.isYeildingNow()) continue;
            this.myYeildingDoneRunnables.remove(each);
            each.run();
        }
        this.maybeReady();
    }

    protected void runOnYieldingDone(Runnable onDone) {
        this.getBuilder().runOnYeildingDone(onDone);
    }

    protected void yield(Runnable runnable) {
        this.getBuilder().yield(runnable);
    }

    private boolean isToYieldUpdateFor(DefaultMutableTreeNode node) {
        if (!this.canYield()) {
            return false;
        }
        return this.getBuilder().isToYieldUpdateFor(node);
    }

    private MutualMap<Object, Integer> loadElementsFromStructure(NodeDescriptor descriptor, @Nullable LoadedChildren preloadedChildren) {
        MutualMap elementToIndexMap = new MutualMap(true);
        List<Object> children = preloadedChildren != null ? preloadedChildren.getElements() : Arrays.asList(this.getChildrenFor(this.getBuilder().getTreeStructureElement(descriptor)));
        int index = 0;
        for (Object child : children) {
            if (!this.isValid(child)) continue;
            elementToIndexMap.put(child, (Object)index);
            ++index;
        }
        return elementToIndexMap;
    }

    private void expand(DefaultMutableTreeNode node, NodeDescriptor descriptor, boolean wasLeaf, final boolean canSmartExpand) {
        Alarm alarm = new Alarm(Alarm.ThreadToUse.SHARED_THREAD);
        alarm.addRequest(new Runnable(){

            @Override
            public void run() {
                AbstractTreeUi.this.myTree.setCursor(Cursor.getPredefinedCursor(3));
            }
        }, 100);
        if (wasLeaf && this.isAutoExpand(descriptor)) {
            this.expand(node, canSmartExpand);
        }
        ArrayList<TreeNode> nodes = TreeUtil.childrenToArray(node);
        for (TreeNode node1 : nodes) {
            NodeDescriptor childDescr;
            final DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)node1;
            if (AbstractTreeUi.isLoadingNode(childNode) || !this.isAutoExpand(childDescr = this.getDescriptorFrom(childNode))) continue;
            this.addNodeAction(this.getElementFor(childNode), new NodeAction(){

                @Override
                public void onReady(DefaultMutableTreeNode node) {
                    AbstractTreeUi.this.expand(childNode, canSmartExpand);
                }
            }, false);
            this.addSubtreeToUpdate(childNode);
        }
        int n = alarm.cancelAllRequests();
        if (n == 0) {
            this.myTree.setCursor(Cursor.getDefaultCursor());
        }
    }

    public static boolean isLoadingNode(Object node) {
        return node instanceof LoadingNode;
    }

    private AsyncResult<ArrayList<TreeNode>> collectNodesToInsert(NodeDescriptor descriptor, MutualMap<Object, Integer> elementToIndexMap, final DefaultMutableTreeNode parent, final boolean addLoadingNode, final @NotNull LoadedChildren loadedChildren) {
        if (loadedChildren == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/ide/util/treeView/AbstractTreeUi.collectNodesToInsert must not be null");
        }
        final AsyncResult<ArrayList<TreeNode>> result = new AsyncResult<ArrayList<TreeNode>>();
        final ArrayList nodesToInsert = new ArrayList();
        Collection allElements = elementToIndexMap.getKeys();
        final ActionCallback processingDone = new ActionCallback(allElements.size());
        for (final Object child : allElements) {
            Integer index = (Integer)elementToIndexMap.getValue(child);
            final Ref childDescr = new Ref((Object)loadedChildren.getDescriptor(child));
            boolean needToUpdate = false;
            if (childDescr.get() == null) {
                childDescr.set((Object)this.getTreeStructure().createDescriptor(child, descriptor));
                needToUpdate = true;
            }
            if (childDescr.get() == null) {
                processingDone.setDone();
                continue;
            }
            ((NodeDescriptor)childDescr.get()).setIndex(index);
            final ActionCallback update = new ActionCallback();
            if (needToUpdate) {
                this.update((NodeDescriptor)childDescr.get(), false).doWhenDone(new AsyncResult.Handler<Boolean>(){

                    @Override
                    public void run(Boolean changes) {
                        loadedChildren.putDescriptor(child, (NodeDescriptor)childDescr.get(), changes);
                        update.setDone();
                    }
                });
            } else {
                update.setDone();
            }
            update.doWhenDone(new Runnable(){

                @Override
                public void run() {
                    Object element = AbstractTreeUi.this.getElementFromDescriptor((NodeDescriptor)childDescr.get());
                    if (element == null) {
                        processingDone.setDone();
                    } else {
                        DefaultMutableTreeNode node = AbstractTreeUi.this.getNodeForElement(element, false);
                        if (node == null || node.getParent() != parent) {
                            DefaultMutableTreeNode childNode = AbstractTreeUi.this.createChildNode((NodeDescriptor)childDescr.get());
                            if (addLoadingNode || AbstractTreeUi.this.getBuilder().isAlwaysShowPlus((NodeDescriptor)childDescr.get())) {
                                AbstractTreeUi.this.insertLoadingNode(childNode, true);
                            } else {
                                AbstractTreeUi.this.addToUnbuilt(childNode);
                            }
                            nodesToInsert.add(childNode);
                            AbstractTreeUi.this.createMapping(element, childNode);
                        }
                        processingDone.setDone();
                    }
                }
            });
        }
        processingDone.doWhenDone(new Runnable(){

            @Override
            public void run() {
                result.setDone(nodesToInsert);
            }
        });
        return result;
    }

    protected DefaultMutableTreeNode createChildNode(NodeDescriptor descriptor) {
        return new ElementNode(this, descriptor);
    }

    protected boolean canYield() {
        return this.myCanYield && this.myYeildingUpdate.asBoolean();
    }

    public long getClearOnHideDelay() {
        return this.myClearOnHideDelay > 0L ? this.myClearOnHideDelay : (long)Registry.intValue("ide.tree.clearOnHideTime");
    }

    public ActionCallback getInitialized() {
        return this.myInitialized;
    }

    public ActionCallback getReady(Object requestor) {
        return this.myBusyObject.getReady(requestor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToUpdating(DefaultMutableTreeNode node) {
        Set<DefaultMutableTreeNode> set = this.myUpdatingChildren;
        synchronized (set) {
            this.myUpdatingChildren.add(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromUpdating(DefaultMutableTreeNode node) {
        Set<DefaultMutableTreeNode> set = this.myUpdatingChildren;
        synchronized (set) {
            this.myUpdatingChildren.remove(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUpdatingNow(DefaultMutableTreeNode node) {
        Set<DefaultMutableTreeNode> set = this.myUpdatingChildren;
        synchronized (set) {
            return this.myUpdatingChildren.contains(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasUpdatingNow() {
        Set<DefaultMutableTreeNode> set = this.myUpdatingChildren;
        synchronized (set) {
            return this.myUpdatingChildren.size() > 0;
        }
    }

    public Map getNodeActions() {
        return this.myNodeActions;
    }

    public List<Object> getLoadedChildrenFor(Object element) {
        ArrayList<Object> result = new ArrayList<Object>();
        DefaultMutableTreeNode node = this.getNodeForElement(element, false);
        if (node != null) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                TreeNode each = node.getChildAt(i);
                if (AbstractTreeUi.isLoadingNode(each)) continue;
                result.add(this.getElementFor(each));
            }
        }
        return result;
    }

    public boolean hasNodesToUpdate() {
        return this.getUpdater().hasNodesToUpdate();
    }

    public List<Object> getExpandedElements() {
        ArrayList<Object> result = new ArrayList<Object>();
        Enumeration<TreePath> enumeration = this.myTree.getExpandedDescendants(AbstractTreeUi.getPathFor(this.getRootNode()));
        while (enumeration.hasMoreElements()) {
            TreePath each = enumeration.nextElement();
            Object eachElement = this.getElementFor(each.getLastPathComponent());
            if (eachElement == null) continue;
            result.add(eachElement);
        }
        return result;
    }

    public ActionCallback cancelUpdate() {
        if (this.isReleased()) {
            return new ActionCallback.Rejected();
        }
        this.setCancelRequested(true);
        final ActionCallback done = new ActionCallback();
        this.invokeLaterIfNeeded(new Runnable(){

            @Override
            public void run() {
                if (AbstractTreeUi.this.isReleased()) {
                    done.setRejected();
                    return;
                }
                if (AbstractTreeUi.this.myResettingToReadyNow.get()) {
                    AbstractTreeUi.this.getReady(this).notify(done);
                } else if (AbstractTreeUi.this.isReady()) {
                    AbstractTreeUi.this.resetToReadyNow();
                    done.setDone();
                } else if (AbstractTreeUi.this.isIdle() && AbstractTreeUi.this.hasPendingWork()) {
                    AbstractTreeUi.this.resetToReadyNow();
                    done.setDone();
                } else {
                    AbstractTreeUi.this.getReady(this).notify(done);
                }
                AbstractTreeUi.this.maybeReady();
            }
        });
        if (this.isEdt() || this.isPassthroughMode()) {
            this.maybeReady();
        }
        return done;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCancelRequested(boolean requested) {
        try {
            if (this.isUnitTestingMode()) {
                this.acquireLock();
            } else {
                this.attemptLock();
            }
            this.myCancelRequest.set(requested);
        }
        catch (InterruptedException e) {
            return;
        }
        finally {
            this.releaseLock();
        }
    }

    private boolean attemptLock() throws InterruptedException {
        return this.myStateLock.tryLock(Registry.intValue("ide.tree.uiLockAttempt"), TimeUnit.MILLISECONDS);
    }

    private void acquireLock() throws InterruptedException {
        this.myStateLock.lock();
    }

    private void releaseLock() {
        this.myStateLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionCallback batch(Progressive progressive) {
        this.assertIsDispatchThread();
        EmptyProgressIndicator indicator = new EmptyProgressIndicator();
        final ActionCallback callback = new ActionCallback();
        this.myBatchIndicators.put(progressive, indicator);
        this.myBatchCallbacks.put(progressive, callback);
        try {
            progressive.run(indicator);
            if (this.isReleased()) {
                return new ActionCallback.Rejected();
            }
            this.getReady(this).doWhenDone(new Runnable(progressive, callback){
                final /* synthetic */ Progressive val$progressive;
                final /* synthetic */ ActionCallback val$callback;
                {
                    this.val$progressive = progressive;
                    this.val$callback = actionCallback;
                }

                @Override
                public void run() {
                    if (AbstractTreeUi.this.myBatchIndicators.containsKey(this.val$progressive)) {
                        ProgressIndicator indicator = (ProgressIndicator)AbstractTreeUi.this.myBatchIndicators.remove(this.val$progressive);
                        AbstractTreeUi.this.myBatchCallbacks.remove(this.val$progressive);
                        if (indicator.isCanceled()) {
                            this.val$callback.setRejected();
                        } else {
                            this.val$callback.setDone();
                        }
                    } else {
                        this.val$callback.setRejected();
                    }
                }
            });
        }
        catch (ProcessCanceledException e) {
            ActionCallback actionCallback;
            try {
                this.resetToReadyNow().doWhenProcessed(new Runnable(){

                    @Override
                    public void run() {
                        callback.setRejected();
                    }
                });
                actionCallback = callback;
                if (this.isReleased()) {
                    return new ActionCallback.Rejected();
                }
                this.getReady(this).doWhenDone(new /* invalid duplicate definition of identical inner class */);
            }
            catch (Throwable throwable) {
                if (this.isReleased()) {
                    return new ActionCallback.Rejected();
                }
                this.getReady(this).doWhenDone(new /* invalid duplicate definition of identical inner class */);
                this.maybeReady();
                throw throwable;
            }
            this.maybeReady();
            return actionCallback;
        }
        this.maybeReady();
        return callback;
    }

    public boolean isCancelProcessed() {
        Boolean processed = this.checkValue(new Computable<Boolean>(){

            public Boolean compute() {
                return AbstractTreeUi.this.myCancelRequest.get() || AbstractTreeUi.this.myResettingToReadyNow.get();
            }
        }, true, null);
        return processed != null && processed != false;
    }

    public boolean isToPaintSelection() {
        return this.isReady(true) || !this.mySelectionIsAdjusted;
    }

    public boolean isReleaseRequested() {
        return this.myReleaseRequested;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeUserRunnable(Runnable runnable) {
        try {
            this.myUserRunnables.add(runnable);
            runnable.run();
        }
        finally {
            this.myUserRunnables.remove(runnable);
        }
    }

    private boolean isUpdatingParent(DefaultMutableTreeNode kid) {
        return this.getUpdatingParent(kid) != null;
    }

    private DefaultMutableTreeNode getUpdatingParent(DefaultMutableTreeNode kid) {
        for (DefaultMutableTreeNode eachParent = kid; eachParent != null; eachParent = (DefaultMutableTreeNode)eachParent.getParent()) {
            if (!this.isUpdatingNow(eachParent)) continue;
            return eachParent;
        }
        return null;
    }

    private boolean isLoadedInBackground(Object element) {
        return this.getLoadedInBackground(element) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpdateInfo getLoadedInBackground(Object element) {
        Map<Object, UpdateInfo> map = this.myLoadedInBackground;
        synchronized (map) {
            return this.myLoadedInBackground.get(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToLoadedInBackground(Object element, UpdateInfo info) {
        Map<Object, UpdateInfo> map = this.myLoadedInBackground;
        synchronized (map) {
            this.myLoadedInBackground.put(element, info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromLoadedInBackground(Object element) {
        Map<Object, UpdateInfo> map = this.myLoadedInBackground;
        synchronized (map) {
            this.myLoadedInBackground.remove(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isLoadingInBackgroundNow() {
        Map<Object, UpdateInfo> map = this.myLoadedInBackground;
        synchronized (map) {
            return this.myLoadedInBackground.size() > 0;
        }
    }

    private boolean queueBackgroundUpdate(final UpdateInfo updateInfo, final DefaultMutableTreeNode node) {
        this.assertIsDispatchThread();
        final Object oldElementFromDescriptor = this.getElementFromDescriptor(updateInfo.getDescriptor());
        UpdateInfo loaded = this.getLoadedInBackground(oldElementFromDescriptor);
        if (loaded != null) {
            loaded.apply(updateInfo);
            return false;
        }
        this.addToLoadedInBackground(oldElementFromDescriptor, updateInfo);
        if (!this.isNodeBeingBuilt(node)) {
            LoadingNode loadingNode = new LoadingNode(this.getLoadingNodeText());
            this.myTreeModel.insertNodeInto(loadingNode, node, node.getChildCount());
        }
        this.removeFromUnbuilt(node);
        final Ref children = new Ref();
        final Ref elementFromDescriptor = new Ref();
        final DefaultMutableTreeNode[] nodeToProcessActions = new DefaultMutableTreeNode[1];
        final Runnable finalizeRunnable = new Runnable(){

            @Override
            public void run() {
                AbstractTreeUi.this.invokeLaterIfNeeded(new Runnable(){

                    @Override
                    public void run() {
                        if (AbstractTreeUi.this.isReleased()) {
                            return;
                        }
                        AbstractTreeUi.this.removeLoading(node, false);
                        AbstractTreeUi.this.removeFromLoadedInBackground(elementFromDescriptor.get());
                        AbstractTreeUi.this.removeFromLoadedInBackground(oldElementFromDescriptor);
                        if (nodeToProcessActions[0] != null) {
                            AbstractTreeUi.this.processNodeActionsIfReady(nodeToProcessActions[0]);
                        }
                    }
                });
            }
        };
        Runnable buildRunnable = new Runnable(){

            @Override
            public void run() {
                Object element;
                if (updateInfo.getPass().isExpired()) {
                    finalizeRunnable.run();
                    return;
                }
                if (!updateInfo.isDescriptorIsUpToDate()) {
                    AbstractTreeUi.this.update(updateInfo.getDescriptor(), true);
                }
                if ((element = AbstractTreeUi.this.getElementFromDescriptor(updateInfo.getDescriptor())) == null) {
                    AbstractTreeUi.this.removeFromLoadedInBackground(oldElementFromDescriptor);
                    finalizeRunnable.run();
                    return;
                }
                elementFromDescriptor.set(element);
                Object[] loadedElements = AbstractTreeUi.this.getChildrenFor(AbstractTreeUi.this.getBuilder().getTreeStructureElement(updateInfo.getDescriptor()));
                final LoadedChildren loaded = new LoadedChildren(loadedElements);
                for (final Object each : loadedElements) {
                    final NodeDescriptor eachChildDescriptor = AbstractTreeUi.this.getTreeStructure().createDescriptor(each, updateInfo.getDescriptor());
                    AbstractTreeUi.this.execute(new Runnable(){

                        @Override
                        public void run() {
                            loaded.putDescriptor(each, eachChildDescriptor, (Boolean)AbstractTreeUi.this.update(eachChildDescriptor, true).getResult());
                        }
                    });
                }
                children.set((Object)loaded);
            }

            public String toString() {
                return "runnable=" + oldElementFromDescriptor;
            }
        };
        Runnable updateRunnable = new Runnable(){

            @Override
            public void run() {
                Pair unbuilt;
                if (updateInfo.getPass().isExpired()) {
                    finalizeRunnable.run();
                    return;
                }
                if (children.get() == null) {
                    finalizeRunnable.run();
                    return;
                }
                if (AbstractTreeUi.this.isRerunNeeded(updateInfo.getPass())) {
                    AbstractTreeUi.this.removeFromLoadedInBackground(elementFromDescriptor.get());
                    AbstractTreeUi.this.getUpdater().addSubtreeToUpdate(updateInfo.getPass());
                    return;
                }
                AbstractTreeUi.this.removeFromLoadedInBackground(elementFromDescriptor.get());
                if (AbstractTreeUi.this.myUnbuiltNodes.contains((Object)node) && ((Boolean)(unbuilt = AbstractTreeUi.this.processUnbuilt(node, updateInfo.getDescriptor(), updateInfo.getPass(), AbstractTreeUi.this.isExpanded(node, updateInfo.isWasExpanded()), (LoadedChildren)children.get())).getFirst()).booleanValue()) {
                    nodeToProcessActions[0] = node;
                    return;
                }
                AbstractTreeUi.this.updateNodeChildren(node, updateInfo.getPass(), (LoadedChildren)children.get(), true, updateInfo.isCanSmartExpand(), updateInfo.isForceUpdate(), true);
                if (AbstractTreeUi.this.isRerunNeeded(updateInfo.getPass())) {
                    AbstractTreeUi.this.getUpdater().addSubtreeToUpdate(updateInfo.getPass());
                    return;
                }
                Object element = elementFromDescriptor.get();
                if (element != null) {
                    AbstractTreeUi.this.removeLoading(node, false);
                    nodeToProcessActions[0] = node;
                }
            }
        };
        this.queueToBackground(buildRunnable, updateRunnable, node).doWhenProcessed(finalizeRunnable).doWhenRejected(new Runnable(){

            @Override
            public void run() {
                updateInfo.getPass().expire();
            }
        });
        return true;
    }

    private boolean isExpanded(DefaultMutableTreeNode node, boolean isExpanded) {
        return isExpanded || this.myTree.isExpanded(AbstractTreeUi.getPathFor(node));
    }

    private void removeLoading(DefaultMutableTreeNode parent, boolean forced) {
        if (!forced && this.myUnbuiltNodes.contains((Object)parent) && !this.myCancelledBuild.containsKey(parent)) {
            return;
        }
        for (int i = 0; i < parent.getChildCount(); ++i) {
            TreeNode child = parent.getChildAt(i);
            if (!this.removeIfLoading(child)) continue;
            --i;
        }
        if (parent == this.getRootNode() && !this.myTree.isRootVisible() && parent.getChildCount() == 0) {
            this.insertLoadingNode(parent, false);
        }
        this.maybeReady();
    }

    private void processNodeActionsIfReady(DefaultMutableTreeNode node) {
        this.assertIsDispatchThread();
        if (this.isNodeBeingBuilt(node)) {
            return;
        }
        Object o = node.getUserObject();
        if (!(o instanceof NodeDescriptor)) {
            return;
        }
        if (this.isYeildingNow()) {
            this.myPendingNodeActions.add(node);
            return;
        }
        Object element = this.getBuilder().getTreeStructureElement((NodeDescriptor)o);
        boolean childrenReady = !this.isLoadedInBackground(element);
        this.processActions(node, element, this.myNodeActions, childrenReady ? this.myNodeChildrenActions : null);
        if (childrenReady) {
            this.processActions(node, element, this.myNodeChildrenActions, null);
        }
        if (!this.isUpdatingParent(node) && !this.isWorkerBusy()) {
            UpdaterTreeState state = this.myUpdaterState;
            if (this.myNodeActions.size() == 0 && state != null && !state.isProcessingNow() && this.canInitiateNewActivity() && !state.restore(childrenReady ? node : null)) {
                this.setUpdaterState(state);
            }
        }
        this.maybeReady();
    }

    private void processActions(DefaultMutableTreeNode node, Object element, Map<Object, List<NodeAction>> nodeActions, @Nullable Map<Object, List<NodeAction>> secondaryNodeAction) {
        List<NodeAction> actions = nodeActions.get(element);
        if (actions != null) {
            nodeActions.remove(element);
            List<NodeAction> secondary = secondaryNodeAction != null ? secondaryNodeAction.get(element) : null;
            for (NodeAction each : actions) {
                if (secondary != null && secondary.contains(each)) {
                    secondary.remove(each);
                }
                each.onReady(node);
            }
        }
    }

    private boolean canSmartExpand(DefaultMutableTreeNode node, boolean canSmartExpand) {
        if (!this.getBuilder().isSmartExpand()) {
            return false;
        }
        boolean smartExpand = !this.myNotForSmartExpand.contains(node) && canSmartExpand;
        return smartExpand ? this.validateAutoExpand(smartExpand, this.getElementFor(node)) : false;
    }

    private void processSmartExpand(DefaultMutableTreeNode node, final boolean canSmartExpand, boolean forced) {
        if (!this.getBuilder().isSmartExpand()) {
            return;
        }
        boolean can = this.canSmartExpand(node, canSmartExpand);
        if (!can && !forced) {
            return;
        }
        if (this.isNodeBeingBuilt(node) && !forced) {
            this.addNodeAction(this.getElementFor(node), new NodeAction(){

                @Override
                public void onReady(DefaultMutableTreeNode node) {
                    AbstractTreeUi.this.processSmartExpand(node, canSmartExpand, true);
                }
            }, true);
        } else {
            TreeNode child = this.getChildForSmartExpand(node);
            if (child != null) {
                final TreePath childPath = new TreePath(node.getPath()).pathByAddingChild(child);
                this.processInnerChange(new Runnable(){

                    @Override
                    public void run() {
                        AbstractTreeUi.this.myTree.expandPath(childPath);
                    }
                });
            }
        }
    }

    @Nullable
    private TreeNode getChildForSmartExpand(DefaultMutableTreeNode node) {
        int realChildCount = 0;
        TreeNode nodeToExpand = null;
        for (int i = 0; i < node.getChildCount(); ++i) {
            TreeNode eachChild = node.getChildAt(i);
            if (!AbstractTreeUi.isLoadingNode(eachChild)) {
                ++realChildCount;
                if (nodeToExpand == null) {
                    nodeToExpand = eachChild;
                }
            }
            if (realChildCount <= 1) continue;
            nodeToExpand = null;
            break;
        }
        return nodeToExpand;
    }

    public boolean isLoadingChildrenFor(Object nodeObject) {
        if (!(nodeObject instanceof DefaultMutableTreeNode)) {
            return false;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)nodeObject;
        int loadingNodes = 0;
        for (int i = 0; i < Math.min(node.getChildCount(), 2); ++i) {
            TreeNode child = node.getChildAt(i);
            if (!AbstractTreeUi.isLoadingNode(child)) continue;
            ++loadingNodes;
        }
        return loadingNodes > 0 && loadingNodes == node.getChildCount();
    }

    private boolean isParentLoading(Object nodeObject) {
        return this.getParentLoading(nodeObject) != null;
    }

    private DefaultMutableTreeNode getParentLoading(Object nodeObject) {
        if (!(nodeObject instanceof DefaultMutableTreeNode)) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)nodeObject;
        TreeNode eachParent = node.getParent();
        while (eachParent != null) {
            Object eachElement;
            if (!((eachParent = eachParent.getParent()) instanceof DefaultMutableTreeNode) || !this.isLoadedInBackground(eachElement = this.getElementFor((DefaultMutableTreeNode)eachParent))) continue;
            return (DefaultMutableTreeNode)eachParent;
        }
        return null;
    }

    protected String getLoadingNodeText() {
        return IdeBundle.message("progress.searching", new Object[0]);
    }

    private ActionCallback processExistingNode(final DefaultMutableTreeNode childNode, NodeDescriptor childDescriptor, final DefaultMutableTreeNode parentNode, final MutualMap<Object, Integer> elementToIndexMap, final TreeUpdatePass pass, final boolean canSmartExpand, final boolean forceUpdate, LoadedChildren parentPreloadedChildren) {
        final ActionCallback result = new ActionCallback();
        if (pass.isExpired()) {
            return new ActionCallback.Rejected();
        }
        final Ref childDesc = new Ref((Object)childDescriptor);
        if (childDesc.get() == null) {
            pass.expire();
            return new ActionCallback.Rejected();
        }
        final Object oldElement = this.getElementFromDescriptor((NodeDescriptor)childDesc.get());
        if (oldElement == null) {
            pass.expire();
            return new ActionCallback.Rejected();
        }
        AsyncResult<Object> update = new AsyncResult<Boolean>();
        if (parentPreloadedChildren != null && parentPreloadedChildren.getDescriptor(oldElement) != null) {
            update.setDone(parentPreloadedChildren.isUpdated(oldElement));
        } else {
            update = this.update((NodeDescriptor)childDesc.get(), false);
        }
        update.doWhenDone(new AsyncResult.Handler<Boolean>(){

            @Override
            public void run(Boolean isChanged) {
                final Ref changes = new Ref((Object)isChanged);
                final Ref forceRemapping = new Ref((Object)false);
                final Ref newElement = new Ref(AbstractTreeUi.this.getElementFromDescriptor((NodeDescriptor)childDesc.get()));
                final Integer index = newElement.get() != null ? (Integer)elementToIndexMap.getValue(AbstractTreeUi.this.getBuilder().getTreeStructureElement((NodeDescriptor)childDesc.get())) : null;
                final AsyncResult<Object> updateIndexDone = new AsyncResult<Object>();
                final ActionCallback indexReady = new ActionCallback();
                if (index != null) {
                    Object elementFromMap = elementToIndexMap.getKey((Object)index);
                    if (elementFromMap != newElement.get() && elementFromMap.equals(newElement.get())) {
                        if (AbstractTreeUi.this.isInStructure(elementFromMap) && AbstractTreeUi.this.isInStructure(newElement.get())) {
                            if (parentNode.getUserObject() instanceof NodeDescriptor) {
                                NodeDescriptor parentDescriptor = AbstractTreeUi.this.getDescriptorFrom(parentNode);
                                childDesc.set((Object)AbstractTreeUi.this.getTreeStructure().createDescriptor(elementFromMap, parentDescriptor));
                                childNode.setUserObject(childDesc.get());
                                newElement.set(elementFromMap);
                                forceRemapping.set((Object)true);
                                AbstractTreeUi.this.update((NodeDescriptor)childDesc.get(), false).doWhenDone(new AsyncResult.Handler<Boolean>(){

                                    @Override
                                    public void run(Boolean isChanged) {
                                        changes.set((Object)isChanged);
                                        updateIndexDone.setDone(isChanged);
                                    }
                                });
                            }
                        } else {
                            updateIndexDone.setDone(changes.get());
                        }
                    } else {
                        updateIndexDone.setDone(changes.get());
                    }
                    updateIndexDone.doWhenDone(new Runnable(){

                        @Override
                        public void run() {
                            if (((NodeDescriptor)childDesc.get()).getIndex() != index.intValue()) {
                                changes.set((Object)true);
                            }
                            ((NodeDescriptor)childDesc.get()).setIndex(index);
                            indexReady.setDone();
                        }
                    });
                } else {
                    updateIndexDone.setDone();
                }
                updateIndexDone.doWhenDone(new Runnable(){

                    @Override
                    public void run() {
                        if (index != null && ((Boolean)changes.get()).booleanValue()) {
                            AbstractTreeUi.this.updateNodeImageAndPosition(childNode, false);
                        }
                        if (!oldElement.equals(newElement.get()) | (Boolean)forceRemapping.get()) {
                            NodeDescriptor parentDescriptor;
                            AbstractTreeUi.this.removeMapping(oldElement, childNode, newElement.get());
                            if (newElement.get() != null) {
                                AbstractTreeUi.this.createMapping(newElement.get(), childNode);
                            }
                            if ((parentDescriptor = AbstractTreeUi.this.getDescriptorFrom(parentNode)) != null) {
                                parentDescriptor.setChildrenSortingStamp(-1L);
                            }
                        }
                        if (index == null) {
                            DefaultMutableTreeNode parent;
                            int selectedIndex = -1;
                            if (TreeBuilderUtil.isNodeOrChildSelected(AbstractTreeUi.this.myTree, childNode)) {
                                selectedIndex = parentNode.getIndex(childNode);
                            }
                            if (childNode.getParent() instanceof DefaultMutableTreeNode && AbstractTreeUi.this.myTree.isExpanded(new TreePath((parent = (DefaultMutableTreeNode)childNode.getParent()).getPath())) && parent.getChildCount() == 1 && parent.getChildAt(0) == childNode) {
                                AbstractTreeUi.this.insertLoadingNode(parent, false);
                            }
                            Object disposedElement = AbstractTreeUi.this.getElementFor(childNode);
                            AbstractTreeUi.this.removeNodeFromParent(childNode, selectedIndex >= 0);
                            AbstractTreeUi.this.disposeNode(childNode);
                            AbstractTreeUi.this.adjustSelectionOnChildRemove(parentNode, selectedIndex, disposedElement);
                        } else {
                            elementToIndexMap.remove(AbstractTreeUi.this.getBuilder().getTreeStructureElement((NodeDescriptor)childDesc.get()));
                            AbstractTreeUi.this.updateNodeChildren(childNode, pass, null, false, canSmartExpand, forceUpdate, true);
                        }
                        if (parentNode.equals(AbstractTreeUi.this.getRootNode())) {
                            AbstractTreeUi.this.myTreeModel.nodeChanged(AbstractTreeUi.this.getRootNode());
                        }
                        result.setDone();
                    }
                });
            }
        });
        return result;
    }

    private void adjustSelectionOnChildRemove(DefaultMutableTreeNode parentNode, int selectedIndex, Object disposedElement) {
        DefaultMutableTreeNode node = this.getNodeForElement(disposedElement, false);
        if (node != null && this.isValidForSelectionAdjusting(node)) {
            Object newElement = this.getElementFor(node);
            this.addSelectionPath(AbstractTreeUi.getPathFor(node), true, this.getExpiredElementCondition(newElement), disposedElement);
            return;
        }
        if (selectedIndex >= 0) {
            if (parentNode.getChildCount() > 0) {
                if (parentNode.getChildCount() > selectedIndex) {
                    TreeNode newChildNode = parentNode.getChildAt(selectedIndex);
                    if (this.isValidForSelectionAdjusting(newChildNode)) {
                        this.addSelectionPath(new TreePath(this.myTreeModel.getPathToRoot(newChildNode)), true, this.getExpiredElementCondition(disposedElement), disposedElement);
                    }
                } else {
                    TreeNode newChild = parentNode.getChildAt(parentNode.getChildCount() - 1);
                    if (this.isValidForSelectionAdjusting(newChild)) {
                        this.addSelectionPath(new TreePath(this.myTreeModel.getPathToRoot(newChild)), true, this.getExpiredElementCondition(disposedElement), disposedElement);
                    }
                }
            } else {
                this.addSelectionPath(new TreePath(this.myTreeModel.getPathToRoot(parentNode)), true, this.getExpiredElementCondition(disposedElement), disposedElement);
            }
        }
    }

    private boolean isValidForSelectionAdjusting(TreeNode node) {
        if (!this.myTree.isRootVisible() && this.getRootNode() == node) {
            return false;
        }
        if (AbstractTreeUi.isLoadingNode(node)) {
            return true;
        }
        Object elementInTree = this.getElementFor(node);
        if (elementInTree == null) {
            return false;
        }
        TreeNode parentNode = node.getParent();
        Object parentElementInTree = this.getElementFor(parentNode);
        if (parentElementInTree == null) {
            return false;
        }
        Object parentElement = this.getTreeStructure().getParentElement(elementInTree);
        return parentElementInTree.equals(parentElement);
    }

    public Condition getExpiredElementCondition(final Object element) {
        return new Condition(){

            public boolean value(Object o) {
                return AbstractTreeUi.this.isInStructure(element);
            }
        };
    }

    private void addSelectionPath(final TreePath path, final boolean isAdjustedSelection, final Condition isExpiredAdjustement, final @Nullable Object adjustmentCause) {
        this.processInnerChange(new Runnable(){

            @Override
            public void run() {
                TreePath toSelect = null;
                if (AbstractTreeUi.isLoadingNode(path.getLastPathComponent())) {
                    TreePath parentPath = path.getParentPath();
                    if (parentPath != null) {
                        toSelect = AbstractTreeUi.this.isValidForSelectionAdjusting((TreeNode)parentPath.getLastPathComponent()) ? parentPath : null;
                    }
                } else {
                    toSelect = path;
                }
                if (toSelect != null) {
                    AbstractTreeUi.this.mySelectionIsAdjusted = isAdjustedSelection;
                    AbstractTreeUi.this.myTree.addSelectionPath(toSelect);
                    if (isAdjustedSelection && AbstractTreeUi.this.myUpdaterState != null) {
                        Object toSelectElement = AbstractTreeUi.this.getElementFor(toSelect.getLastPathComponent());
                        AbstractTreeUi.this.myUpdaterState.addAdjustedSelection(toSelectElement, isExpiredAdjustement, adjustmentCause);
                    }
                }
            }
        });
    }

    private static TreePath getPathFor(TreeNode node) {
        if (node instanceof DefaultMutableTreeNode) {
            return new TreePath(((DefaultMutableTreeNode)node).getPath());
        }
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        for (TreeNode eachParent = node; eachParent != null; eachParent = eachParent.getParent()) {
            nodes.add(eachParent);
        }
        return new TreePath(ArrayUtil.toObjectArray(nodes));
    }

    private void removeNodeFromParent(final MutableTreeNode node, final boolean willAdjustSelection) {
        this.processInnerChange(new Runnable(){

            @Override
            public void run() {
                TreePath path;
                if (willAdjustSelection && AbstractTreeUi.this.myTree.isPathSelected(path = AbstractTreeUi.getPathFor(node))) {
                    AbstractTreeUi.this.myTree.removeSelectionPath(path);
                }
                if (node.getParent() != null) {
                    AbstractTreeUi.this.myTreeModel.removeNodeFromParent(node);
                }
            }
        });
    }

    private void expandPath(final TreePath path, final boolean canSmartExpand) {
        this.processInnerChange(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (path.getLastPathComponent() instanceof DefaultMutableTreeNode) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                    if (node.getChildCount() > 0 && !AbstractTreeUi.this.myTree.isExpanded(path)) {
                        if (!canSmartExpand) {
                            AbstractTreeUi.this.myNotForSmartExpand.add(node);
                        }
                        try {
                            AbstractTreeUi.this.myRequestedExpand = path;
                            AbstractTreeUi.this.myTree.expandPath(path);
                            AbstractTreeUi.this.processSmartExpand(node, canSmartExpand, false);
                        }
                        finally {
                            AbstractTreeUi.this.myNotForSmartExpand.remove(node);
                            AbstractTreeUi.this.myRequestedExpand = null;
                        }
                    } else {
                        AbstractTreeUi.this.processNodeActionsIfReady(node);
                    }
                }
            }
        });
    }

    private void processInnerChange(Runnable runnable) {
        if (this.myUpdaterState == null) {
            this.setUpdaterState(new UpdaterTreeState(this));
        }
        this.myUpdaterState.process(runnable);
    }

    private boolean isInnerChange() {
        return this.myUpdaterState != null && this.myUpdaterState.isProcessingNow() && this.myUserRunnables.size() == 0;
    }

    protected boolean doUpdateNodeDescriptor(NodeDescriptor descriptor) {
        return descriptor.update();
    }

    private void makeLoadingOrLeafIfNoChildren(DefaultMutableTreeNode node) {
        TreePath path = AbstractTreeUi.getPathFor(node);
        if (path == null) {
            return;
        }
        this.insertLoadingNode(node, true);
        NodeDescriptor descriptor = this.getDescriptorFrom(node);
        if (descriptor == null) {
            return;
        }
        descriptor.setChildrenSortingStamp(-1L);
        if (this.getBuilder().isAlwaysShowPlus(descriptor)) {
            return;
        }
        TreePath parentPath = path.getParentPath();
        if (this.myTree.isVisible(path) || parentPath != null && this.myTree.isExpanded(parentPath)) {
            if (this.myTree.isExpanded(path)) {
                this.addSubtreeToUpdate(node);
            } else {
                this.insertLoadingNode(node, false);
            }
        }
    }

    private boolean isValid(DefaultMutableTreeNode node) {
        if (node == null) {
            return false;
        }
        Object object = node.getUserObject();
        if (object instanceof NodeDescriptor) {
            return this.isValid((NodeDescriptor)object);
        }
        return false;
    }

    private boolean isValid(NodeDescriptor descriptor) {
        if (descriptor == null) {
            return false;
        }
        return this.isValid(this.getElementFromDescriptor(descriptor));
    }

    private boolean isValid(Object element) {
        if (element instanceof ValidateableNode && !((ValidateableNode)element).isValid()) {
            return false;
        }
        return this.getBuilder().validateNode(element);
    }

    private void insertLoadingNode(DefaultMutableTreeNode node, boolean addToUnbuilt) {
        if (!this.isLoadingChildrenFor(node)) {
            this.myTreeModel.insertNodeInto(new LoadingNode(), node, 0);
        }
        if (addToUnbuilt) {
            this.addToUnbuilt(node);
        }
    }

    protected ActionCallback queueToBackground(final @NotNull Runnable bgBuildAction, final @Nullable Runnable edtPostRunnable, final Object id) {
        if (bgBuildAction == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/util/treeView/AbstractTreeUi.queueToBackground must not be null");
        }
        if (!this.canInitiateNewActivity()) {
            return new ActionCallback.Rejected();
        }
        final ActionCallback result = new ActionCallback();
        final Ref fail = new Ref((Object)false);
        final Runnable finalizer = new Runnable(){

            @Override
            public void run() {
                if (((Boolean)fail.get()).booleanValue()) {
                    result.setRejected();
                } else {
                    result.setDone();
                }
            }
        };
        this.registerWorkerTask(bgBuildAction, id);
        final Runnable pooledThreadWithProgressRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    final AbstractTreeBuilder builder = AbstractTreeUi.this.getBuilder();
                    if (!AbstractTreeUi.this.canInitiateNewActivity()) {
                        throw new ProcessCanceledException();
                    }
                    builder.runBackgroundLoading(new Runnable(){

                        @Override
                        public void run() {
                            AbstractTreeUi.this.assertNotDispatchThread();
                            try {
                                if (!AbstractTreeUi.this.canInitiateNewActivity()) {
                                    throw new ProcessCanceledException();
                                }
                                AbstractTreeUi.this.execute(bgBuildAction);
                                if (edtPostRunnable != null) {
                                    builder.updateAfterLoadedInBackground(new Runnable(){

                                        /*
                                         * WARNING - Removed try catching itself - possible behaviour change.
                                         */
                                        @Override
                                        public void run() {
                                            try {
                                                AbstractTreeUi.this.assertIsDispatchThread();
                                                if (!AbstractTreeUi.this.canInitiateNewActivity()) {
                                                    throw new ProcessCanceledException();
                                                }
                                                AbstractTreeUi.this.execute(edtPostRunnable);
                                            }
                                            catch (ProcessCanceledException e) {
                                                fail.set((Object)true);
                                                AbstractTreeUi.this.cancelUpdate();
                                            }
                                            finally {
                                                AbstractTreeUi.this.unregisterWorkerTask(bgBuildAction, finalizer, id);
                                            }
                                        }
                                    });
                                } else {
                                    AbstractTreeUi.this.unregisterWorkerTask(bgBuildAction, finalizer, id);
                                }
                            }
                            catch (ProcessCanceledException e) {
                                fail.set((Object)true);
                                AbstractTreeUi.this.unregisterWorkerTask(bgBuildAction, finalizer, id);
                                AbstractTreeUi.this.cancelUpdate();
                            }
                            catch (Throwable t) {
                                AbstractTreeUi.this.unregisterWorkerTask(bgBuildAction, finalizer, id);
                                throw new RuntimeException(t);
                            }
                        }
                    });
                }
                catch (ProcessCanceledException e) {
                    AbstractTreeUi.this.unregisterWorkerTask(bgBuildAction, finalizer, id);
                    AbstractTreeUi.this.cancelUpdate();
                }
            }
        };
        Runnable pooledThreadRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    if (AbstractTreeUi.this.myProgress != null) {
                        ProgressManager.getInstance().runProcess(pooledThreadWithProgressRunnable, AbstractTreeUi.this.myProgress);
                    } else {
                        AbstractTreeUi.this.execute(pooledThreadWithProgressRunnable);
                    }
                }
                catch (ProcessCanceledException e) {
                    fail.set((Object)true);
                    AbstractTreeUi.this.unregisterWorkerTask(bgBuildAction, finalizer, id);
                    AbstractTreeUi.this.cancelUpdate();
                }
            }
        };
        if (this.isPassthroughMode()) {
            this.execute(pooledThreadRunnable);
        } else if (this.myWorker == null || this.myWorker.isDisposed()) {
            this.myWorker = new WorkerThread("AbstractTreeBuilder.Worker", 1);
            this.myWorker.start();
            this.myWorker.addTaskFirst(pooledThreadRunnable);
            this.myWorker.dispose(false);
        } else {
            this.myWorker.addTaskFirst(pooledThreadRunnable);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerWorkerTask(Runnable runnable, Object id) {
        Set<Runnable> set = this.myActiveWorkerTasks;
        synchronized (set) {
            this.myActiveWorkerTasks.add(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterWorkerTask(Runnable runnable, @Nullable Runnable finalizeRunnable, Object id) {
        boolean wasRemoved;
        Set<Runnable> set = this.myActiveWorkerTasks;
        synchronized (set) {
            wasRemoved = this.myActiveWorkerTasks.remove(runnable);
        }
        if (wasRemoved && finalizeRunnable != null) {
            finalizeRunnable.run();
        }
        this.invokeLaterIfNeeded(new Runnable(){

            @Override
            public void run() {
                AbstractTreeUi.this.maybeReady();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWorkerBusy() {
        Set<Runnable> set = this.myActiveWorkerTasks;
        synchronized (set) {
            return this.myActiveWorkerTasks.size() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearWorkerTasks() {
        Set<Runnable> set = this.myActiveWorkerTasks;
        synchronized (set) {
            this.myActiveWorkerTasks.clear();
        }
    }

    private void updateNodeImageAndPosition(DefaultMutableTreeNode node, boolean updatePosition) {
        if (!(node.getUserObject() instanceof NodeDescriptor)) {
            return;
        }
        NodeDescriptor descriptor = this.getDescriptorFrom(node);
        if (this.getElementFromDescriptor(descriptor) == null) {
            return;
        }
        boolean notified = false;
        if (updatePosition) {
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)node.getParent();
            if (parentNode != null) {
                int oldIndex;
                int newIndex = oldIndex = parentNode.getIndex(node);
                if (this.isLoadingChildrenFor(node.getParent()) || this.getBuilder().isChildrenResortingNeeded(descriptor)) {
                    ArrayList<TreeNode> children = new ArrayList<TreeNode>(parentNode.getChildCount());
                    for (int i = 0; i < parentNode.getChildCount(); ++i) {
                        children.add(parentNode.getChildAt(i));
                    }
                    this.sortChildren(node, children, true, false);
                    newIndex = children.indexOf(node);
                }
                if (oldIndex != newIndex) {
                    ArrayList<Object> pathsToExpand = new ArrayList<Object>();
                    ArrayList<Object> selectionPaths = new ArrayList<Object>();
                    TreeBuilderUtil.storePaths(this.getBuilder(), node, pathsToExpand, selectionPaths, false);
                    this.removeNodeFromParent(node, false);
                    this.myTreeModel.insertNodeInto(node, parentNode, newIndex);
                    TreeBuilderUtil.restorePaths(this.getBuilder(), pathsToExpand, selectionPaths, false);
                    notified = true;
                } else {
                    this.myTreeModel.nodeChanged(node);
                    notified = true;
                }
            } else {
                this.myTreeModel.nodeChanged(node);
                notified = true;
            }
        }
        if (!notified) {
            this.myTreeModel.nodeChanged(node);
        }
    }

    public DefaultTreeModel getTreeModel() {
        return this.myTreeModel;
    }

    private void insertNodesInto(ArrayList<TreeNode> toInsert, final DefaultMutableTreeNode parentNode) {
        this.sortChildren(parentNode, toInsert, false, true);
        final ArrayList<TreeNode> all = new ArrayList<TreeNode>(toInsert.size() + parentNode.getChildCount());
        all.addAll(toInsert);
        all.addAll(TreeUtil.childrenToArray(parentNode));
        if (toInsert.size() > 0) {
            this.sortChildren(parentNode, all, true, true);
            int[] newNodeIndices = new int[toInsert.size()];
            int eachNewNodeIndex = 0;
            TreeMap<Integer, TreeNode> insertSet = new TreeMap<Integer, TreeNode>();
            for (int i = 0; i < toInsert.size(); ++i) {
                TreeNode eachNewNode = toInsert.get(i);
                while (all.get(eachNewNodeIndex) != eachNewNode) {
                    ++eachNewNodeIndex;
                }
                newNodeIndices[i] = eachNewNodeIndex;
                insertSet.put(eachNewNodeIndex, eachNewNode);
            }
            for (Integer eachIndex : insertSet.keySet()) {
                TreeNode eachNode = (TreeNode)insertSet.get(eachIndex);
                parentNode.insert((MutableTreeNode)eachNode, eachIndex);
            }
            this.myTreeModel.nodesWereInserted(parentNode, newNodeIndices);
        } else {
            ArrayList<TreeNode> before = new ArrayList<TreeNode>();
            before.addAll(all);
            this.sortChildren(parentNode, all, true, false);
            if (!before.equals(all)) {
                this.processInnerChange(new Runnable(){

                    @Override
                    public void run() {
                        Enumeration<TreePath> expanded = AbstractTreeUi.this.getTree().getExpandedDescendants(AbstractTreeUi.getPathFor(parentNode));
                        TreePath[] selected = AbstractTreeUi.this.getTree().getSelectionModel().getSelectionPaths();
                        parentNode.removeAllChildren();
                        for (TreeNode each : all) {
                            parentNode.add((MutableTreeNode)each);
                        }
                        AbstractTreeUi.this.myTreeModel.nodeStructureChanged(parentNode);
                        if (expanded != null) {
                            while (expanded.hasMoreElements()) {
                                AbstractTreeUi.this.expandSilently(expanded.nextElement());
                            }
                        }
                        if (selected != null) {
                            for (TreePath each : selected) {
                                if (AbstractTreeUi.this.getTree().getSelectionModel().isPathSelected(each)) continue;
                                AbstractTreeUi.this.addSelectionSilently(each);
                            }
                        }
                    }
                });
            }
        }
    }

    private void sortChildren(DefaultMutableTreeNode node, ArrayList<TreeNode> children, boolean updateStamp, boolean forceSort) {
        NodeDescriptor descriptor = this.getDescriptorFrom(node);
        assert (descriptor != null);
        if (descriptor.getChildrenSortingStamp() >= this.getComparatorStamp() && !forceSort) {
            return;
        }
        if (children.size() > 0) {
            this.getBuilder().sortChildren(this.myNodeComparator, node, children);
        }
        if (updateStamp) {
            descriptor.setChildrenSortingStamp(this.getComparatorStamp());
        }
    }

    private void disposeNode(DefaultMutableTreeNode node) {
        TreeNode parent = node.getParent();
        if (parent instanceof DefaultMutableTreeNode) {
            this.addToUnbuilt((DefaultMutableTreeNode)parent);
        }
        if (node.getChildCount() > 0) {
            for (DefaultMutableTreeNode _node = (DefaultMutableTreeNode)node.getFirstChild(); _node != null; _node = _node.getNextSibling()) {
                this.disposeNode(_node);
            }
        }
        this.removeFromUpdating(node);
        this.removeFromUnbuilt(node);
        this.removeFromCancelled(node);
        if (AbstractTreeUi.isLoadingNode(node)) {
            return;
        }
        NodeDescriptor descriptor = this.getDescriptorFrom(node);
        if (descriptor == null) {
            return;
        }
        Object element = this.getElementFromDescriptor(descriptor);
        this.removeMapping(element, node, null);
        this.myAutoExpandRoots.remove(element);
        node.setUserObject(null);
        node.removeAllChildren();
    }

    public boolean addSubtreeToUpdate(DefaultMutableTreeNode root) {
        return this.addSubtreeToUpdate(root, null);
    }

    public boolean addSubtreeToUpdate(final DefaultMutableTreeNode root, final Runnable runAfterUpdate) {
        Object element = this.getElementFor(root);
        if (this.getTreeStructure().isAlwaysLeaf(element)) {
            this.removeFromUnbuilt(root);
            this.removeLoading(root, true);
            if (runAfterUpdate != null) {
                this.getReady(this).doWhenDone(runAfterUpdate);
            }
            return false;
        }
        this.execute(new Runnable(){

            @Override
            public void run() {
                AbstractTreeUi.this.getUpdater().runAfterUpdate(runAfterUpdate);
                AbstractTreeUi.this.getUpdater().addSubtreeToUpdate(root);
            }
        });
        return true;
    }

    public boolean wasRootNodeInitialized() {
        return this.myRootNodeWasQueuedToInitialize && this.myRootNodeInitialized;
    }

    public void select(Object[] elements, @Nullable Runnable onDone) {
        this.select(elements, onDone, false);
    }

    public void select(Object[] elements, @Nullable Runnable onDone, boolean addToSelection) {
        this.select(elements, onDone, addToSelection, false);
    }

    public void select(Object[] elements, @Nullable Runnable onDone, boolean addToSelection, boolean deferred) {
        this._select(elements, onDone, addToSelection, true, false, true, deferred, false, false);
    }

    void _select(Object[] elements, Runnable onDone, boolean addToSelection, boolean checkCurrentSelection, boolean checkIfInStructure) {
        this._select(elements, onDone, addToSelection, checkCurrentSelection, checkIfInStructure, true, false, false, false);
    }

    void _select(Object[] elements, Runnable onDone, boolean addToSelection, boolean checkCurrentSelection, boolean checkIfInStructure, boolean scrollToVisible) {
        this._select(elements, onDone, addToSelection, checkCurrentSelection, checkIfInStructure, scrollToVisible, false, false, false);
    }

    public void userSelect(Object[] elements, Runnable onDone, boolean addToSelection, boolean scroll) {
        this._select(elements, onDone, addToSelection, true, false, scroll, false, true, true);
    }

    void _select(final Object[] elements, final Runnable onDone, final boolean addToSelection, final boolean checkCurrentSelection, final boolean checkIfInStructure, final boolean scrollToVisible, final boolean deferred, final boolean canSmartExpand, boolean mayQueue) {
        boolean willAffectSelection;
        AbstractTreeUpdater updater = this.getUpdater();
        if (mayQueue && updater != null) {
            updater.queueSelection(new SelectionRequest(elements, onDone, addToSelection, checkCurrentSelection, checkIfInStructure, scrollToVisible, deferred, canSmartExpand));
            return;
        }
        boolean bl = willAffectSelection = elements.length > 0 || elements.length == 0 && addToSelection;
        if (!willAffectSelection) {
            this.runDone(onDone);
            return;
        }
        boolean oldCanProcessDeferredSelection = this.myCanProcessDeferredSelections;
        if (!deferred && this.wasRootNodeInitialized() && willAffectSelection) {
            this.getReady(this).doWhenDone(new Runnable(){

                @Override
                public void run() {
                    AbstractTreeUi.this.myCanProcessDeferredSelections = false;
                }
            });
        }
        if (!this.checkDeferred(deferred, onDone)) {
            return;
        }
        if (!deferred && oldCanProcessDeferredSelection && !this.myCanProcessDeferredSelections && !addToSelection) {
            this.getTree().clearSelection();
        }
        this.runDone(new Runnable(){

            @Override
            public void run() {
                if (!AbstractTreeUi.this.checkDeferred(deferred, onDone)) {
                    return;
                }
                final Set<Object> currentElements = AbstractTreeUi.this.getSelectedElements();
                if (checkCurrentSelection && currentElements.size() > 0 && elements.length == currentElements.size()) {
                    boolean runSelection = false;
                    for (Object eachToSelect : elements) {
                        if (currentElements.contains(eachToSelect)) continue;
                        runSelection = true;
                        break;
                    }
                    if (!runSelection) {
                        if (elements.length > 0) {
                            AbstractTreeUi.this.selectVisible(elements[0], onDone, true, true, scrollToVisible);
                        }
                        return;
                    }
                }
                HashSet toSelect = new HashSet();
                AbstractTreeUi.this.myTree.clearSelection();
                ContainerUtil.addAll((Collection)toSelect, (Object[])elements);
                if (addToSelection) {
                    toSelect.addAll(currentElements);
                }
                if (checkIfInStructure) {
                    Iterator allToSelect = toSelect.iterator();
                    while (allToSelect.hasNext()) {
                        Object each = allToSelect.next();
                        if (AbstractTreeUi.this.isInStructure(each)) continue;
                        allToSelect.remove();
                    }
                }
                Object[] elementsToSelect = ArrayUtil.toObjectArray((Collection)toSelect);
                if (AbstractTreeUi.this.wasRootNodeInitialized()) {
                    int[] originalRows = AbstractTreeUi.this.myTree.getSelectionRows();
                    if (!addToSelection) {
                        AbstractTreeUi.this.myTree.clearSelection();
                    }
                    AbstractTreeUi.this.addNext(elementsToSelect, 0, new Runnable(){

                        @Override
                        public void run() {
                            if (AbstractTreeUi.this.getTree().isSelectionEmpty()) {
                                AbstractTreeUi.this.processInnerChange(new Runnable(){

                                    @Override
                                    public void run() {
                                        AbstractTreeUi.this.restoreSelection(currentElements);
                                    }
                                });
                            }
                            AbstractTreeUi.this.runDone(onDone);
                        }
                    }, originalRows, deferred, scrollToVisible, canSmartExpand);
                } else {
                    AbstractTreeUi.this.addToDeferred(elementsToSelect, onDone, addToSelection);
                }
            }
        });
    }

    private void restoreSelection(Set<Object> selection) {
        for (Object each : selection) {
            DefaultMutableTreeNode node = this.getNodeForElement(each, false);
            if (node == null || !this.isValidForSelectionAdjusting(node)) continue;
            this.addSelectionPath(AbstractTreeUi.getPathFor(node), false, null, null);
        }
    }

    private void addToDeferred(final Object[] elementsToSelect, final Runnable onDone, final boolean addToSelection) {
        if (!addToSelection) {
            this.myDeferredSelections.clear();
        }
        this.myDeferredSelections.add(new Runnable(){

            @Override
            public void run() {
                AbstractTreeUi.this.select(elementsToSelect, onDone, addToSelection, true);
            }
        });
    }

    private boolean checkDeferred(boolean isDeferred, @Nullable Runnable onDone) {
        if (!isDeferred || this.myCanProcessDeferredSelections || !this.wasRootNodeInitialized()) {
            return true;
        }
        this.runDone(onDone);
        return false;
    }

    @NotNull
    final Set<Object> getSelectedElements() {
        TreePath[] paths = this.myTree.getSelectionPaths();
        HashSet result = new HashSet();
        if (paths != null) {
            for (TreePath eachPath : paths) {
                DefaultMutableTreeNode eachNode;
                Object eachElement;
                if (!(eachPath.getLastPathComponent() instanceof DefaultMutableTreeNode) || (eachElement = this.getElementFor(eachNode = (DefaultMutableTreeNode)eachPath.getLastPathComponent())) == null) continue;
                result.add(eachElement);
            }
        }
        HashSet hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/util/treeView/AbstractTreeUi.getSelectedElements must not return null");
        }
        return hashSet;
    }

    private void addNext(final Object[] elements, final int i, final @Nullable Runnable onDone, final int[] originalRows, final boolean deferred, final boolean scrollToVisible, final boolean canSmartExpand) {
        if (i >= elements.length) {
            if (this.myTree.isSelectionEmpty()) {
                this.myTree.setSelectionRows(originalRows);
            }
            this.runDone(onDone);
        } else {
            if (!this.checkDeferred(deferred, onDone)) {
                return;
            }
            this.doSelect(elements[i], new Runnable(){

                @Override
                public void run() {
                    if (!AbstractTreeUi.this.checkDeferred(deferred, onDone)) {
                        return;
                    }
                    AbstractTreeUi.this.addNext(elements, i + 1, onDone, originalRows, deferred, scrollToVisible, canSmartExpand);
                }
            }, true, deferred, i == 0, scrollToVisible, canSmartExpand);
        }
    }

    public void select(Object element, @Nullable Runnable onDone) {
        this.select(element, onDone, false);
    }

    public void select(Object element, @Nullable Runnable onDone, boolean addToSelection) {
        this._select(new Object[]{element}, onDone, addToSelection, true, false);
    }

    private void doSelect(final Object element, final Runnable onDone, final boolean addToSelection, final boolean deferred, final boolean canBeCentered, final boolean scrollToVisible, final boolean canSmartExpand) {
        Runnable _onDone = new Runnable(){

            @Override
            public void run() {
                if (!AbstractTreeUi.this.checkDeferred(deferred, onDone)) {
                    return;
                }
                AbstractTreeUi.this.checkPathAndMaybeRevalidate(element, new Runnable(){

                    @Override
                    public void run() {
                        AbstractTreeUi.this.selectVisible(element, onDone, addToSelection, canBeCentered, scrollToVisible);
                    }
                }, true, false, canSmartExpand);
            }
        };
        this._expand(element, _onDone, true, false, canSmartExpand);
    }

    private void checkPathAndMaybeRevalidate(Object element, final Runnable onDone, final boolean parentsOnly, final boolean checkIfInStructure, final boolean canSmartExpand) {
        boolean toRevalidate;
        boolean bl = toRevalidate = this.isValid(element) && !this.myRevalidatedObjects.contains(element) && this.getNodeForElement(element, false) == null && this.isInStructure(element);
        if (!toRevalidate) {
            this.runDone(onDone);
            return;
        }
        this.myRevalidatedObjects.add(element);
        AsyncResult<Object> revalidated = this.getBuilder().revalidateElement(element);
        if (revalidated == null) {
            this.runDone(onDone);
            return;
        }
        revalidated.doWhenDone(new AsyncResult.Handler<Object>(){

            @Override
            public void run(final Object o) {
                AbstractTreeUi.this.invokeLaterIfNeeded(new Runnable(){

                    @Override
                    public void run() {
                        AbstractTreeUi.this._expand(o, onDone, parentsOnly, checkIfInStructure, canSmartExpand);
                    }
                });
            }
        }).doWhenRejected(new Runnable(){

            @Override
            public void run() {
                AbstractTreeUi.this.runDone(onDone);
            }
        });
    }

    public void scrollSelectionToVisible(@Nullable Runnable onDone, boolean shouldBeCentered) {
        int eachRow;
        TreePath path;
        int[] rows = this.myTree.getSelectionRows();
        if (rows == null || rows.length == 0) {
            this.runDone(onDone);
            return;
        }
        Object toSelect = null;
        int[] arr$ = rows;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (toSelect = this.getElementFor((path = this.myTree.getPathForRow(eachRow = arr$[i$])).getLastPathComponent())) == null; ++i$) {
        }
        if (toSelect != null) {
            this.selectVisible(toSelect, onDone, true, shouldBeCentered, true);
        }
    }

    private void selectVisible(Object element, final Runnable onDone, boolean addToSelection, boolean canBeCentered, final boolean scroll) {
        DefaultMutableTreeNode toSelect = this.getNodeForElement(element, false);
        if (toSelect == null) {
            this.runDone(onDone);
            return;
        }
        if (this.getRootNode() == toSelect && !this.myTree.isRootVisible()) {
            this.runDone(onDone);
            return;
        }
        final int row = this.myTree.getRowForPath(new TreePath(toSelect.getPath()));
        if (this.myUpdaterState != null) {
            this.myUpdaterState.addSelection(element);
        }
        if (Registry.is("ide.tree.autoscrollToVCenter") && canBeCentered) {
            this.setHoldSize(false);
            this.runDone(new Runnable(){

                @Override
                public void run() {
                    TreeUtil.showRowCentered(AbstractTreeUi.this.myTree, row, false, scroll).doWhenDone(new Runnable(){

                        @Override
                        public void run() {
                            AbstractTreeUi.this.runDone(onDone);
                        }
                    });
                }
            });
        } else {
            this.setHoldSize(false);
            TreeUtil.showAndSelect(this.myTree, row - 2, row + 2, row, -1, addToSelection, scroll).doWhenDone(new Runnable(){

                @Override
                public void run() {
                    AbstractTreeUi.this.runDone(onDone);
                }
            });
        }
    }

    public void expandAll(final @Nullable Runnable onDone) {
        final JTree tree = this.getTree();
        if (tree.getRowCount() > 0) {
            final int expandRecursionDepth = Math.max(2, Registry.intValue("ide.tree.expandRecursionDepth"));
            new Runnable(){
                private int myCurrentRow = 0;
                private int myInvocationCount = 0;

                @Override
                public void run() {
                    int row;
                    if (++this.myInvocationCount > expandRecursionDepth) {
                        this.myInvocationCount = 0;
                        if (AbstractTreeUi.this.isPassthroughMode()) {
                            this.run();
                        } else {
                            SwingUtilities.invokeLater(this);
                        }
                    } else if ((row = this.myCurrentRow++) < tree.getRowCount()) {
                        TreePath path = tree.getPathForRow(row);
                        Object last = path.getLastPathComponent();
                        Object elem = AbstractTreeUi.this.getElementFor(last);
                        AbstractTreeUi.this.expand(elem, (Runnable)this);
                    } else {
                        AbstractTreeUi.this.runDone(onDone);
                    }
                }
            }.run();
        } else {
            this.runDone(onDone);
        }
    }

    public void expand(Object element, @Nullable Runnable onDone) {
        this.expand(new Object[]{element}, onDone);
    }

    public void expand(Object[] element, @Nullable Runnable onDone) {
        this.expand(element, onDone, false);
    }

    void expand(Object element, @Nullable Runnable onDone, boolean checkIfInStructure) {
        this._expand(new Object[]{element}, (Runnable)(onDone == null ? new EmptyRunnable() : onDone), false, checkIfInStructure, false);
    }

    void expand(Object[] element, @Nullable Runnable onDone, boolean checkIfInStructure) {
        this._expand(element, (Runnable)(onDone == null ? new EmptyRunnable() : onDone), false, checkIfInStructure, false);
    }

    void _expand(final Object[] element, final @NotNull Runnable onDone, final boolean parentsOnly, final boolean checkIfInStructure, final boolean canSmartExpand) {
        if (onDone == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ide/util/treeView/AbstractTreeUi._expand must not be null");
        }
        try {
            this.runDone(new Runnable(){

                @Override
                public void run() {
                    if (element.length == 0) {
                        AbstractTreeUi.this.runDone(onDone);
                        return;
                    }
                    if (AbstractTreeUi.this.myUpdaterState != null) {
                        AbstractTreeUi.this.myUpdaterState.clearExpansion();
                    }
                    ActionCallback done = new ActionCallback(element.length);
                    done.doWhenDone(new Runnable(){

                        @Override
                        public void run() {
                            AbstractTreeUi.this.runDone(onDone);
                        }
                    }).doWhenRejected(new Runnable(){

                        @Override
                        public void run() {
                            AbstractTreeUi.this.runDone(onDone);
                        }
                    });
                    AbstractTreeUi.this.expandNext(element, 0, parentsOnly, checkIfInStructure, canSmartExpand, done, 0);
                }
            });
        }
        catch (ProcessCanceledException e) {
            this.runDone(onDone);
        }
    }

    private void expandNext(final Object[] elements, final int index, final boolean parentsOnly, final boolean checkIfInStricture, final boolean canSmartExpand, final ActionCallback done, int currentDepth) {
        if (elements.length <= 0) {
            done.setDone();
            return;
        }
        if (index >= elements.length) {
            return;
        }
        final int[] actualDepth = new int[]{currentDepth};
        boolean breakCallChain = false;
        if (actualDepth[0] > Registry.intValue("ide.tree.expandRecursionDepth")) {
            actualDepth[0] = 0;
            breakCallChain = true;
        }
        Runnable expandRunnable = new Runnable(){

            @Override
            public void run() {
                AbstractTreeUi.this._expand(elements[index], new Runnable(){

                    @Override
                    public void run() {
                        done.setDone();
                        AbstractTreeUi.this.expandNext(elements, index + 1, parentsOnly, checkIfInStricture, canSmartExpand, done, actualDepth[0] + 1);
                    }
                }, parentsOnly, checkIfInStricture, canSmartExpand);
            }
        };
        if (breakCallChain && !this.isPassthroughMode()) {
            SwingUtilities.invokeLater(expandRunnable);
        } else {
            expandRunnable.run();
        }
    }

    public void collapseChildren(final Object element, final @Nullable Runnable onDone) {
        this.runDone(new Runnable(){

            @Override
            public void run() {
                DefaultMutableTreeNode node = AbstractTreeUi.this.getNodeForElement(element, false);
                if (node != null) {
                    AbstractTreeUi.this.getTree().collapsePath(new TreePath(node.getPath()));
                    AbstractTreeUi.this.runDone(onDone);
                }
            }
        });
    }

    private void runDone(@Nullable Runnable done) {
        if (done == null) {
            return;
        }
        if (this.isYeildingNow()) {
            if (!this.myYeildingDoneRunnables.contains(done)) {
                this.myYeildingDoneRunnables.add(done);
            }
        } else {
            this.execute(done);
        }
    }

    private void _expand(Object element, @NotNull Runnable onDone, boolean parentsOnly, boolean checkIfInStructure, boolean canSmartExpand) {
        if (onDone == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ide/util/treeView/AbstractTreeUi._expand must not be null");
        }
        if (checkIfInStructure && !this.isInStructure(element)) {
            this.runDone(onDone);
            return;
        }
        if (this.wasRootNodeInitialized()) {
            ArrayList<Object> kidsToExpand = new ArrayList<Object>();
            Object eachElement = element;
            DefaultMutableTreeNode firstVisible = null;
            while (this.isValid(eachElement)) {
                firstVisible = this.getNodeForElement(eachElement, true);
                if (eachElement != element || !parentsOnly) {
                    assert (!kidsToExpand.contains(eachElement)) : "Not a valid tree structure, walking up the structure gives many entries for element=" + eachElement + ", root=" + this.getTreeStructure().getRootElement();
                    kidsToExpand.add(eachElement);
                }
                if (firstVisible != null) break;
                if ((eachElement = eachElement != null ? this.getTreeStructure().getParentElement(eachElement) : null) != null) continue;
                firstVisible = null;
                break;
            }
            if (firstVisible == null) {
                this.runDone(onDone);
            } else if (kidsToExpand.size() == 0) {
                TreePath parentPath;
                DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)firstVisible.getParent();
                if (parentNode != null && !this.myTree.isExpanded(parentPath = new TreePath(parentNode.getPath()))) {
                    this.expand(parentPath, canSmartExpand);
                }
                this.runDone(onDone);
            } else {
                this.processExpand(firstVisible, kidsToExpand, kidsToExpand.size() - 1, onDone, canSmartExpand);
            }
        } else {
            this.deferExpansion(element, onDone, parentsOnly, canSmartExpand);
        }
    }

    private void deferExpansion(final Object element, final Runnable onDone, final boolean parentsOnly, final boolean canSmartExpand) {
        this.myDeferredExpansions.add(new Runnable(){

            @Override
            public void run() {
                AbstractTreeUi.this._expand(element, onDone, parentsOnly, false, canSmartExpand);
            }
        });
    }

    private void processExpand(DefaultMutableTreeNode toExpand, final List kidsToExpand, final int expandIndex, final @NotNull Runnable onDone, final boolean canSmartExpand) {
        if (onDone == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/ide/util/treeView/AbstractTreeUi.processExpand must not be null");
        }
        Object element = this.getElementFor(toExpand);
        if (element == null) {
            this.runDone(onDone);
            return;
        }
        this.addNodeAction(element, new NodeAction(){

            @Override
            public void onReady(DefaultMutableTreeNode node) {
                if (node.getChildCount() > 0 && !AbstractTreeUi.this.myTree.isExpanded(new TreePath(node.getPath())) && !AbstractTreeUi.this.isAutoExpand(node)) {
                    AbstractTreeUi.this.expand(node, canSmartExpand);
                }
                if (expandIndex <= 0) {
                    AbstractTreeUi.this.runDone(onDone);
                    return;
                }
                AbstractTreeUi.this.checkPathAndMaybeRevalidate(kidsToExpand.get(expandIndex - 1), new Runnable(){

                    @Override
                    public void run() {
                        DefaultMutableTreeNode nextNode = AbstractTreeUi.this.getNodeForElement(kidsToExpand.get(expandIndex - 1), false);
                        AbstractTreeUi.this.processExpand(nextNode, kidsToExpand, expandIndex - 1, onDone, canSmartExpand);
                    }
                }, false, false, canSmartExpand);
            }
        }, true);
        boolean childrenToUpdate = this.areChildrenToBeUpdated(toExpand);
        boolean expanded = this.myTree.isExpanded(AbstractTreeUi.getPathFor(toExpand));
        boolean unbuilt = this.myUnbuiltNodes.contains((Object)toExpand);
        if (expanded) {
            if (unbuilt && !childrenToUpdate) {
                this.addSubtreeToUpdate(toExpand);
            } else if (childrenToUpdate) {
                this.addSubtreeToUpdate(toExpand);
            }
        } else {
            this.expand(toExpand, canSmartExpand);
        }
        if (!unbuilt && !childrenToUpdate) {
            this.processNodeActionsIfReady(toExpand);
        }
    }

    private boolean areChildrenToBeUpdated(DefaultMutableTreeNode node) {
        return this.getUpdater().isEnqueuedToUpdate(node) || this.isUpdatingParent(node) || this.myCancelledBuild.containsKey(node);
    }

    private String asString(DefaultMutableTreeNode node) {
        if (node == null) {
            return null;
        }
        StringBuffer children = new StringBuffer(node.toString());
        children.append(" [");
        for (int i = 0; i < node.getChildCount(); ++i) {
            children.append(node.getChildAt(i));
            if (i >= node.getChildCount() - 1) continue;
            children.append(",");
        }
        children.append("]");
        return children.toString();
    }

    @Nullable
    public Object getElementFor(Object node) {
        if (!(node instanceof DefaultMutableTreeNode)) {
            return null;
        }
        return this.getElementFor((DefaultMutableTreeNode)node);
    }

    @Nullable
    Object getElementFor(DefaultMutableTreeNode node) {
        Object o;
        if (node != null && (o = node.getUserObject()) instanceof NodeDescriptor) {
            return this.getElementFromDescriptor((NodeDescriptor)o);
        }
        return null;
    }

    public final boolean isNodeBeingBuilt(TreePath path) {
        return this.isNodeBeingBuilt(path.getLastPathComponent());
    }

    public final boolean isNodeBeingBuilt(Object node) {
        return this.getParentBuiltNode(node) != null || this.myRootNode == node && !this.wasRootNodeInitialized();
    }

    public final DefaultMutableTreeNode getParentBuiltNode(Object node) {
        boolean childrenAreNoLoadedYet;
        DefaultMutableTreeNode parent = this.getParentLoading(node);
        if (parent != null) {
            return parent;
        }
        if (this.isLoadingParent(node)) {
            return (DefaultMutableTreeNode)node;
        }
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)node;
        boolean bl = childrenAreNoLoadedYet = this.myUnbuiltNodes.contains((Object)treeNode) || this.isUpdatingNow(treeNode);
        if (childrenAreNoLoadedYet) {
            TreePath nodePath;
            if (node instanceof DefaultMutableTreeNode && !this.myTree.isExpanded(nodePath = new TreePath(((DefaultMutableTreeNode)node).getPath()))) {
                return null;
            }
            return (DefaultMutableTreeNode)node;
        }
        return null;
    }

    private boolean isLoadingParent(Object node) {
        if (!(node instanceof DefaultMutableTreeNode)) {
            return false;
        }
        return this.isLoadedInBackground(this.getElementFor((DefaultMutableTreeNode)node));
    }

    public void setTreeStructure(AbstractTreeStructure treeStructure) {
        this.myTreeStructure = treeStructure;
        this.clearUpdaterState();
    }

    public AbstractTreeUpdater getUpdater() {
        return this.myUpdater;
    }

    public void setUpdater(AbstractTreeUpdater updater) {
        this.myUpdater = updater;
        if (updater != null && this.myUpdateIfInactive) {
            updater.showNotify();
        }
        if (this.myUpdater != null) {
            this.myUpdater.setPassThroughMode(this.myPassthroughMode);
        }
    }

    public DefaultMutableTreeNode getRootNode() {
        return this.myRootNode;
    }

    public void setRootNode(@NotNull DefaultMutableTreeNode rootNode) {
        if (rootNode == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/util/treeView/AbstractTreeUi.setRootNode must not be null");
        }
        this.myRootNode = rootNode;
    }

    private void dropUpdaterStateIfExternalChange() {
        if (!this.isInnerChange()) {
            this.clearUpdaterState();
            this.myAutoExpandRoots.clear();
            this.mySelectionIsAdjusted = false;
        }
    }

    void clearUpdaterState() {
        this.myUpdaterState = null;
    }

    private void createMapping(Object element, DefaultMutableTreeNode node) {
        if (!this.myElementToNodeMap.containsKey(element)) {
            this.myElementToNodeMap.put(element, node);
        } else {
            ArrayList<DefaultMutableTreeNode> nodes;
            Object value = this.myElementToNodeMap.get(element);
            if (value instanceof DefaultMutableTreeNode) {
                nodes = new ArrayList<DefaultMutableTreeNode>();
                nodes.add((DefaultMutableTreeNode)value);
                this.myElementToNodeMap.put(element, nodes);
            } else {
                nodes = (ArrayList<DefaultMutableTreeNode>)value;
            }
            nodes.add(node);
        }
    }

    private void removeMapping(Object element, DefaultMutableTreeNode node, @Nullable Object elementToPutNodeActionsFor) {
        Object value = this.myElementToNodeMap.get(element);
        if (value != null) {
            if (value instanceof DefaultMutableTreeNode) {
                if (value.equals(node)) {
                    this.myElementToNodeMap.remove(element);
                }
            } else {
                List nodes = (List)value;
                boolean reallyRemoved = nodes.remove(node);
                if (reallyRemoved && nodes.isEmpty()) {
                    this.myElementToNodeMap.remove(element);
                }
            }
        }
        this.remapNodeActions(element, elementToPutNodeActionsFor);
    }

    private void remapNodeActions(Object element, Object elementToPutNodeActionsFor) {
        this._remapNodeActions(element, elementToPutNodeActionsFor, this.myNodeActions);
        this._remapNodeActions(element, elementToPutNodeActionsFor, this.myNodeChildrenActions);
    }

    private void _remapNodeActions(Object element, Object elementToPutNodeActionsFor, Map<Object, List<NodeAction>> nodeActions) {
        List<NodeAction> actions = nodeActions.get(element);
        nodeActions.remove(element);
        if (elementToPutNodeActionsFor != null && actions != null) {
            nodeActions.put(elementToPutNodeActionsFor, actions);
        }
    }

    private DefaultMutableTreeNode getFirstNode(Object element) {
        return this.findNode(element, 0);
    }

    private DefaultMutableTreeNode findNode(Object element, int startIndex) {
        Object value = this.getBuilder().findNodeByElement(element);
        if (value == null) {
            return null;
        }
        if (value instanceof DefaultMutableTreeNode) {
            return startIndex == 0 ? (DefaultMutableTreeNode)value : null;
        }
        List nodes = (List)value;
        return startIndex < nodes.size() ? (DefaultMutableTreeNode)nodes.get(startIndex) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object findNodeByElement(Object element) {
        if (this.myElementToNodeMap.containsKey(element)) {
            return this.myElementToNodeMap.get(element);
        }
        try {
            this.TREE_NODE_WRAPPER.setValue(element);
            Object object = this.myElementToNodeMap.get(this.TREE_NODE_WRAPPER);
            return object;
        }
        finally {
            this.TREE_NODE_WRAPPER.setValue(null);
        }
    }

    private DefaultMutableTreeNode findNodeForChildElement(DefaultMutableTreeNode parentNode, Object element) {
        Object value = this.myElementToNodeMap.get(element);
        if (value == null) {
            return null;
        }
        if (value instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode elementNode = (DefaultMutableTreeNode)value;
            return parentNode.equals(elementNode.getParent()) ? elementNode : null;
        }
        List allNodesForElement = (List)value;
        for (DefaultMutableTreeNode elementNode : allNodesForElement) {
            if (!parentNode.equals(elementNode.getParent())) continue;
            return elementNode;
        }
        return null;
    }

    private void addNodeAction(Object element, NodeAction action, boolean shouldChildrenBeReady) {
        this._addNodeAction(element, action, this.myNodeActions);
        if (shouldChildrenBeReady) {
            this._addNodeAction(element, action, this.myNodeChildrenActions);
        }
    }

    private void _addNodeAction(Object element, NodeAction action, Map<Object, List<NodeAction>> map) {
        this.maybeSetBusyAndScheduleWaiterForReady(true);
        List<NodeAction> list = map.get(element);
        if (list == null) {
            list = new ArrayList<NodeAction>();
            map.put(element, list);
        }
        list.add(action);
    }

    private void cleanUpNow() {
        if (!this.canInitiateNewActivity()) {
            return;
        }
        UpdaterTreeState state = new UpdaterTreeState(this);
        this.myTree.collapsePath(new TreePath(this.myTree.getModel().getRoot()));
        this.myTree.clearSelection();
        this.getRootNode().removeAllChildren();
        this.myRootNodeWasQueuedToInitialize = false;
        this.myRootNodeInitialized = false;
        this.clearNodeActions();
        this.myElementToNodeMap.clear();
        this.myDeferredSelections.clear();
        this.myDeferredExpansions.clear();
        this.myLoadedInBackground.clear();
        this.myUnbuiltNodes.clear();
        this.myUpdateFromRootRequested = true;
        if (this.myWorker != null) {
            Disposer.dispose((Disposable)this.myWorker);
            this.myWorker = null;
        }
        this.myTree.invalidate();
        state.restore(null);
    }

    public AbstractTreeUi setClearOnHideDelay(long clearOnHideDelay) {
        this.myClearOnHideDelay = clearOnHideDelay;
        return this;
    }

    public void setJantorPollPeriod(long time) {
        this.myJanitorPollPeriod = time;
    }

    private void maybeUpdateSubtreeToUpdate(final DefaultMutableTreeNode subtreeRoot) {
        if (!this.myUnbuiltNodes.contains((Object)subtreeRoot)) {
            return;
        }
        TreePath path = AbstractTreeUi.getPathFor(subtreeRoot);
        if (this.myTree.getRowForPath(path) == -1) {
            return;
        }
        DefaultMutableTreeNode parent = this.getParentBuiltNode(subtreeRoot);
        if (parent == null) {
            if (!this.getBuilder().isAlwaysShowPlus(this.getDescriptorFrom(subtreeRoot))) {
                this.addSubtreeToUpdate(subtreeRoot);
            }
        } else if (parent != subtreeRoot) {
            this.addNodeAction(this.getElementFor(subtreeRoot), new NodeAction(){

                @Override
                public void onReady(DefaultMutableTreeNode parent) {
                    AbstractTreeUi.this.maybeUpdateSubtreeToUpdate(subtreeRoot);
                }
            }, true);
        }
    }

    private boolean isSelectionInside(DefaultMutableTreeNode parent) {
        TreePath path = new TreePath(this.myTreeModel.getPathToRoot(parent));
        TreePath[] paths = this.myTree.getSelectionPaths();
        if (paths == null) {
            return false;
        }
        for (TreePath path1 : paths) {
            if (!path.isDescendant(path1)) continue;
            return true;
        }
        return false;
    }

    public boolean isInStructure(@Nullable Object element) {
        Object eachParent = element;
        while (eachParent != null) {
            if (this.getTreeStructure().getRootElement().equals(eachParent)) {
                return true;
            }
            eachParent = this.getTreeStructure().getParentElement(eachParent);
        }
        return false;
    }

    public void setCanYield(boolean canYield) {
        this.myCanYield = canYield;
    }

    public Collection<TreeUpdatePass> getYeildingPasses() {
        return this.myYeildingPasses;
    }

    public boolean isBuilt(Object element) {
        if (!this.myElementToNodeMap.containsKey(element)) {
            return false;
        }
        Object node = this.myElementToNodeMap.get(element);
        return !this.myUnbuiltNodes.contains(node);
    }

    UpdaterTreeState getUpdaterState() {
        return this.myUpdaterState;
    }

    private long getComparatorStamp() {
        if (this.myNodeDescriptorComparator instanceof NodeDescriptor.NodeComparator) {
            long currentComparatorStamp = ((NodeDescriptor.NodeComparator)this.myNodeDescriptorComparator).getStamp();
            if (currentComparatorStamp > this.myLastComparatorStamp) {
                this.myOwnComparatorStamp = Math.max(this.myOwnComparatorStamp, currentComparatorStamp) + 1L;
            }
            this.myLastComparatorStamp = currentComparatorStamp;
            return Math.max(currentComparatorStamp, this.myOwnComparatorStamp);
        }
        return this.myOwnComparatorStamp;
    }

    public void incComparatorStamp() {
        this.myOwnComparatorStamp = this.getComparatorStamp() + 1L;
    }

    public void setPassthroughMode(boolean passthrough) {
        this.myPassthroughMode = passthrough;
        AbstractTreeUpdater updater = this.getUpdater();
        if (updater != null) {
            updater.setPassThroughMode(this.myPassthroughMode);
        }
        if (this.isUnitTestingMode() || passthrough) {
            // empty if block
        }
    }

    public boolean isPassthroughMode() {
        return this.myPassthroughMode;
    }

    private boolean isUnitTestingMode() {
        Application app = ApplicationManager.getApplication();
        return app != null && app.isUnitTestMode();
    }

    private void addModelListenerToDianoseAccessOutsideEdt() {
        this.myTreeModel.addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                AbstractTreeUi.this.assertIsDispatchThread();
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                AbstractTreeUi.this.assertIsDispatchThread();
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
                AbstractTreeUi.this.assertIsDispatchThread();
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                AbstractTreeUi.this.assertIsDispatchThread();
            }
        });
    }

    public static class UpdateInfo {
        NodeDescriptor myDescriptor;
        TreeUpdatePass myPass;
        boolean myCanSmartExpand;
        boolean myWasExpanded;
        boolean myForceUpdate;
        boolean myDescriptorIsUpToDate;

        public UpdateInfo(NodeDescriptor descriptor, TreeUpdatePass pass, boolean canSmartExpand, boolean wasExpanded, boolean forceUpdate, boolean descriptorIsUpToDate) {
            this.myDescriptor = descriptor;
            this.myPass = pass;
            this.myCanSmartExpand = canSmartExpand;
            this.myWasExpanded = wasExpanded;
            this.myForceUpdate = forceUpdate;
            this.myDescriptorIsUpToDate = descriptorIsUpToDate;
        }

        synchronized NodeDescriptor getDescriptor() {
            return this.myDescriptor;
        }

        synchronized TreeUpdatePass getPass() {
            return this.myPass;
        }

        synchronized boolean isCanSmartExpand() {
            return this.myCanSmartExpand;
        }

        synchronized boolean isWasExpanded() {
            return this.myWasExpanded;
        }

        synchronized boolean isForceUpdate() {
            return this.myForceUpdate;
        }

        synchronized boolean isDescriptorIsUpToDate() {
            return this.myDescriptorIsUpToDate;
        }

        public synchronized void apply(UpdateInfo updateInfo) {
            this.myDescriptor = updateInfo.myDescriptor;
            this.myPass = updateInfo.myPass;
            this.myCanSmartExpand = updateInfo.myCanSmartExpand;
            this.myWasExpanded = updateInfo.myWasExpanded;
            this.myForceUpdate = updateInfo.myForceUpdate;
            this.myDescriptorIsUpToDate = updateInfo.myDescriptorIsUpToDate;
        }

        public String toString() {
            return "UpdateInfo: desc=" + this.myDescriptor + " pass=" + this.myPass + " canSmartExpand=" + this.myCanSmartExpand + " wasExpanded=" + this.myWasExpanded + " forceUpdate=" + this.myForceUpdate + " descriptorUpToDate=" + this.myDescriptorIsUpToDate;
        }
    }

    class LoadedChildren {
        private final List myElements;
        private final Map<Object, NodeDescriptor> myDescriptors = new HashMap<Object, NodeDescriptor>();
        private final Map<NodeDescriptor, Boolean> myChanges = new HashMap<NodeDescriptor, Boolean>();

        LoadedChildren(Object[] elements) {
            this.myElements = Arrays.asList(elements != null ? elements : ArrayUtil.EMPTY_OBJECT_ARRAY);
        }

        void putDescriptor(Object element, NodeDescriptor descriptor, boolean isChanged) {
            if (AbstractTreeUi.this.isUnitTestingMode()) assert (this.myElements.contains(element));
            this.myDescriptors.put(element, descriptor);
            this.myChanges.put(descriptor, isChanged);
        }

        List getElements() {
            return this.myElements;
        }

        NodeDescriptor getDescriptor(Object element) {
            return this.myDescriptors.get(element);
        }

        public String toString() {
            return Arrays.asList(this.myElements) + "->" + this.myChanges;
        }

        public boolean isUpdated(Object element) {
            NodeDescriptor desc = this.getDescriptor(element);
            return this.myChanges.get(desc);
        }
    }

    static interface NodeAction {
        public void onReady(DefaultMutableTreeNode var1);
    }

    private class MyExpansionListener
    implements TreeExpansionListener {
        private MyExpansionListener() {
        }

        @Override
        public void treeExpanded(TreeExpansionEvent event) {
            final TreePath path = event.getPath();
            if (AbstractTreeUi.this.mySilentExpand != null && AbstractTreeUi.this.mySilentExpand.equals(path)) {
                return;
            }
            AbstractTreeUi.this.dropUpdaterStateIfExternalChange();
            if (AbstractTreeUi.this.myRequestedExpand != null && !AbstractTreeUi.this.myRequestedExpand.equals(path)) {
                AbstractTreeUi.this.getReady(AbstractTreeUi.this).doWhenDone(new Runnable(){

                    @Override
                    public void run() {
                        Object element = AbstractTreeUi.this.getElementFor(path.getLastPathComponent());
                        AbstractTreeUi.this.expand(element, null);
                    }
                });
                return;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (!AbstractTreeUi.this.myUnbuiltNodes.contains((Object)node)) {
                AbstractTreeUi.this.removeLoading(node, false);
                HashSet childrenToUpdate = new HashSet();
                for (int i = 0; i < node.getChildCount(); ++i) {
                    DefaultMutableTreeNode each = (DefaultMutableTreeNode)node.getChildAt(i);
                    if (!AbstractTreeUi.this.myUnbuiltNodes.contains((Object)each)) continue;
                    AbstractTreeUi.this.makeLoadingOrLeafIfNoChildren(each);
                    childrenToUpdate.add(each);
                }
                if (childrenToUpdate.size() > 0) {
                    for (DefaultMutableTreeNode each : childrenToUpdate) {
                        AbstractTreeUi.this.maybeUpdateSubtreeToUpdate(each);
                    }
                }
            } else {
                AbstractTreeUi.this.getBuilder().expandNodeChildren(node);
            }
            AbstractTreeUi.this.processSmartExpand(node, AbstractTreeUi.this.canSmartExpand(node, true), false);
            AbstractTreeUi.this.processNodeActionsIfReady(node);
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent e) {
            AbstractTreeUi.this.dropUpdaterStateIfExternalChange();
            TreePath path = e.getPath();
            final DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (!(node.getUserObject() instanceof NodeDescriptor)) {
                return;
            }
            TreePath pathToSelect = null;
            if (AbstractTreeUi.this.isSelectionInside(node)) {
                pathToSelect = new TreePath(node.getPath());
            }
            NodeDescriptor descriptor = AbstractTreeUi.this.getDescriptorFrom(node);
            if (AbstractTreeUi.this.getBuilder().isDisposeOnCollapsing(descriptor)) {
                AbstractTreeUi.this.runDone(new Runnable(){

                    @Override
                    public void run() {
                        if (AbstractTreeUi.this.isDisposed(node)) {
                            return;
                        }
                        TreePath nodePath = new TreePath(node.getPath());
                        if (AbstractTreeUi.this.myTree.isExpanded(nodePath)) {
                            return;
                        }
                        MyExpansionListener.this.removeChildren(node);
                        AbstractTreeUi.this.makeLoadingOrLeafIfNoChildren(node);
                    }
                });
                if (node.equals(AbstractTreeUi.this.getRootNode())) {
                    if (AbstractTreeUi.this.myTree.isRootVisible()) {
                        // empty if block
                    }
                } else {
                    AbstractTreeUi.this.myTreeModel.reload(node);
                }
            }
            if (pathToSelect != null && AbstractTreeUi.this.myTree.isSelectionEmpty()) {
                AbstractTreeUi.this.addSelectionPath(pathToSelect, true, Condition.FALSE, null);
            }
        }

        private void removeChildren(DefaultMutableTreeNode node) {
            EnumerationCopy copy = new EnumerationCopy(node.children());
            while (copy.hasMoreElements()) {
                AbstractTreeUi.this.disposeNode((DefaultMutableTreeNode)copy.nextElement());
            }
            node.removeAllChildren();
            AbstractTreeUi.this.myTreeModel.nodeStructureChanged(node);
        }
    }

    private class MySelectionListener
    implements TreeSelectionListener {
        private MySelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            if (AbstractTreeUi.this.mySilentSelect != null && AbstractTreeUi.this.mySilentSelect.equals(e.getNewLeadSelectionPath())) {
                return;
            }
            AbstractTreeUi.this.dropUpdaterStateIfExternalChange();
        }
    }

    static class ElementNode
    extends DefaultMutableTreeNode {
        Set<Object> myElements = new HashSet();
        AbstractTreeUi myUi;

        ElementNode(AbstractTreeUi ui, NodeDescriptor descriptor) {
            super(descriptor);
            this.myUi = ui;
        }

        @Override
        public void insert(MutableTreeNode newChild, int childIndex) {
            super.insert(newChild, childIndex);
            Object element = this.myUi.getElementFor(newChild);
            if (element != null) {
                this.myElements.add(element);
            }
        }

        @Override
        public void remove(int childIndex) {
            TreeNode node = this.getChildAt(childIndex);
            super.remove(childIndex);
            Object element = this.myUi.getElementFor(node);
            if (element != null) {
                this.myElements.remove(element);
            }
        }

        boolean isValidChild(Object childElement) {
            return this.myElements.contains(childElement);
        }

        @Override
        public String toString() {
            return String.valueOf(this.getUserObject());
        }
    }
}

