/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ExportableApplicationComponent;
import com.intellij.openapi.util.NamedJDOMExternalizable;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class GeneralSettings
implements NamedJDOMExternalizable,
ExportableApplicationComponent {
    @NonNls
    private static final String OPTION_INACTIVE_TIMEOUT = "inactiveTimeout";
    @NonNls
    public static final String PROP_INACTIVE_TIMEOUT = "inactiveTimeout";
    private static final int DEFAULT_INACTIVE_TIMEOUT = 15;
    @NonNls
    private String myBrowserPath = SystemInfo.isWindows ? "C:\\Program Files\\Internet Explorer\\IExplore.exe" : (SystemInfo.isMac ? "open" : "");
    private boolean myShowTipsOnStartup = true;
    private int myLastTip = 0;
    private boolean myShowOccupiedMemory = false;
    private boolean myReopenLastProject = true;
    private boolean mySyncOnFrameActivation = true;
    private boolean mySaveOnFrameDeactivation = true;
    private boolean myAutoSaveIfInactive = false;
    private int myInactiveTimeout = 15;
    private final PropertyChangeSupport myPropertyChangeSupport = new PropertyChangeSupport(this);
    private boolean myUseDefaultBrowser = true;
    private boolean myConfirmExtractFiles = true;
    private String myLastProjectLocation;
    private boolean mySearchInBackground;
    private boolean myConfirmExit = true;
    @NonNls
    private static final String ELEMENT_OPTION = "option";
    @NonNls
    private static final String ATTRIBUTE_NAME = "name";
    @NonNls
    private static final String ATTRIBUTE_VALUE = "value";
    @NonNls
    private static final String OPTION_BROWSER_PATH = "browserPath";
    @NonNls
    private static final String OPTION_LAST_TIP = "lastTip";
    @NonNls
    private static final String OPTION_SHOW_TIPS_ON_STARTUP = "showTipsOnStartup";
    @NonNls
    private static final String OPTION_SHOW_OCCUPIED_MEMORY = "showOccupiedMemory";
    @NonNls
    private static final String OPTION_REOPEN_LAST_PROJECT = "reopenLastProject";
    @NonNls
    private static final String OPTION_AUTO_SYNC_FILES = "autoSyncFiles";
    @NonNls
    private static final String OPTION_AUTO_SAVE_FILES = "autoSaveFiles";
    @NonNls
    private static final String OPTION_AUTO_SAVE_IF_INACTIVE = "autoSaveIfInactive";
    @Deprecated
    @NonNls
    private static final String OPTION_CHARSET = "charset";
    @Deprecated
    @NonNls
    private static final String OPTION_UTFGUESSING = "UTFGuessing";
    @NonNls
    private static final String OPTION_USE_DEFAULT_BROWSER = "useDefaultBrowser";
    @NonNls
    private static final String OPTION_CONFIRM_EXTRACT_FILES = "confirmExtractFiles";
    @NonNls
    private static final String OPTION_USE_CYCLIC_BUFFER = "useCyclicBuffer";
    @NonNls
    private static final String OPTION_SEARCH_IN_BACKGROUND = "searchInBackground";
    @NonNls
    private static final String OPTION_CONFIRM_EXIT = "confirmExit";
    @NonNls
    private static final String OPTION_CYCLIC_BUFFER_SIZE = "cyclicBufferSize";
    @NonNls
    private static final String OPTION_LAST_PROJECT_LOCATION = "lastProjectLocation";
    @Deprecated
    private Charset myCharset;
    @Deprecated
    private boolean myUseUTFGuessing;
    @Deprecated
    private boolean oldCharsetSettingsHaveBeenRead;

    public static GeneralSettings getInstance() {
        return ApplicationManager.getApplication().getComponent(GeneralSettings.class);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.myPropertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.myPropertyChangeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public void initComponent() {
    }

    @Override
    public void disposeComponent() {
    }

    public String getBrowserPath() {
        return this.myBrowserPath;
    }

    public String getLastProjectLocation() {
        return this.myLastProjectLocation;
    }

    public void setLastProjectLocation(String lastProjectLocation) {
        this.myLastProjectLocation = lastProjectLocation;
    }

    public void setBrowserPath(String browserPath) {
        this.myBrowserPath = browserPath;
    }

    public boolean showTipsOnStartup() {
        return this.myShowTipsOnStartup;
    }

    public void setShowTipsOnStartup(boolean b) {
        this.myShowTipsOnStartup = b;
    }

    public int getLastTip() {
        return this.myLastTip;
    }

    public void setLastTip(int i) {
        this.myLastTip = i;
    }

    public boolean isShowOccupiedMemory() {
        return this.myShowOccupiedMemory;
    }

    public boolean isReopenLastProject() {
        return this.myReopenLastProject;
    }

    public void setReopenLastProject(boolean reopenLastProject) {
        this.myReopenLastProject = reopenLastProject;
    }

    public boolean isSyncOnFrameActivation() {
        return this.mySyncOnFrameActivation;
    }

    public void setSyncOnFrameActivation(boolean syncOnFrameActivation) {
        this.mySyncOnFrameActivation = syncOnFrameActivation;
    }

    public boolean isSaveOnFrameDeactivation() {
        return this.mySaveOnFrameDeactivation;
    }

    public void setSaveOnFrameDeactivation(boolean saveOnFrameDeactivation) {
        this.mySaveOnFrameDeactivation = saveOnFrameDeactivation;
    }

    public boolean isAutoSaveIfInactive() {
        return this.myAutoSaveIfInactive;
    }

    public void setAutoSaveIfInactive(boolean autoSaveIfInactive) {
        this.myAutoSaveIfInactive = autoSaveIfInactive;
    }

    public int getInactiveTimeout() {
        return this.myInactiveTimeout;
    }

    public void setInactiveTimeout(int inactiveTimeout) {
        int oldInactiveTimeout = this.myInactiveTimeout;
        this.myInactiveTimeout = inactiveTimeout;
        this.myPropertyChangeSupport.firePropertyChange("inactiveTimeout", (Object)oldInactiveTimeout, (Object)inactiveTimeout);
    }

    public void readExternal(Element parentNode) {
        List children = parentNode.getChildren(ELEMENT_OPTION);
        for (Object aChildren : children) {
            Element element = (Element)aChildren;
            String name = element.getAttributeValue(ATTRIBUTE_NAME);
            String value = element.getAttributeValue(ATTRIBUTE_VALUE);
            if (OPTION_BROWSER_PATH.equals(name)) {
                this.myBrowserPath = value;
            }
            if (OPTION_LAST_TIP.equals(name)) {
                try {
                    this.myLastTip = Integer.parseInt(value);
                }
                catch (NumberFormatException ex) {
                    this.myLastTip = 0;
                }
            }
            if (OPTION_SHOW_TIPS_ON_STARTUP.equals(name)) {
                try {
                    this.myShowTipsOnStartup = Boolean.valueOf(value);
                }
                catch (Exception ex) {
                    this.myShowTipsOnStartup = true;
                }
            }
            if (OPTION_SHOW_OCCUPIED_MEMORY.equals(name)) {
                try {
                    this.myShowOccupiedMemory = Boolean.valueOf(value);
                }
                catch (Exception ex) {
                    this.myShowOccupiedMemory = false;
                }
            }
            if (OPTION_REOPEN_LAST_PROJECT.equals(name)) {
                try {
                    this.myReopenLastProject = Boolean.valueOf(value);
                }
                catch (Exception ex) {
                    this.myReopenLastProject = true;
                }
            }
            if (OPTION_AUTO_SYNC_FILES.equals(name)) {
                try {
                    this.mySyncOnFrameActivation = Boolean.valueOf(value);
                }
                catch (Exception ex) {
                    this.mySyncOnFrameActivation = true;
                }
            }
            if (OPTION_AUTO_SAVE_FILES.equals(name)) {
                try {
                    this.mySaveOnFrameDeactivation = Boolean.valueOf(value);
                }
                catch (Exception ex) {
                    this.mySaveOnFrameDeactivation = true;
                }
            }
            if (OPTION_AUTO_SAVE_IF_INACTIVE.equals(name) && value != null) {
                this.myAutoSaveIfInactive = Boolean.valueOf(value);
            }
            if ("inactiveTimeout".equals(name)) {
                try {
                    int inactiveTimeout = Integer.parseInt(value);
                    if (inactiveTimeout > 0) {
                        this.myInactiveTimeout = inactiveTimeout;
                    }
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
            if (OPTION_CHARSET.equals(name)) {
                this.myCharset = CharsetToolkit.forName(value);
                this.oldCharsetSettingsHaveBeenRead = true;
            }
            if (OPTION_UTFGUESSING.equals(name)) {
                this.myUseUTFGuessing = Boolean.valueOf(value);
                this.oldCharsetSettingsHaveBeenRead = true;
            }
            if (OPTION_USE_DEFAULT_BROWSER.equals(name)) {
                try {
                    this.myUseDefaultBrowser = Boolean.valueOf(value);
                }
                catch (Exception ex) {
                    this.myUseDefaultBrowser = true;
                }
            }
            if (OPTION_CONFIRM_EXTRACT_FILES.equals(name)) {
                try {
                    this.myConfirmExtractFiles = Boolean.valueOf(value);
                }
                catch (Exception ex) {
                    this.myConfirmExtractFiles = true;
                }
            }
            if (OPTION_SEARCH_IN_BACKGROUND.equals(name)) {
                try {
                    this.mySearchInBackground = Boolean.valueOf(value);
                }
                catch (Exception ex) {
                    this.mySearchInBackground = false;
                }
            }
            if (OPTION_CONFIRM_EXIT.equals(name)) {
                try {
                    this.myConfirmExit = Boolean.valueOf(value);
                }
                catch (Exception ex) {
                    this.myConfirmExit = false;
                }
            }
            if (!OPTION_LAST_PROJECT_LOCATION.equals(name)) continue;
            try {
                this.myLastProjectLocation = value;
            }
            catch (Exception ex) {
                this.myLastProjectLocation = null;
            }
        }
    }

    public void writeExternal(Element parentNode) {
        if (this.myBrowserPath != null) {
            Element element = new Element(ELEMENT_OPTION);
            element.setAttribute(ATTRIBUTE_NAME, OPTION_BROWSER_PATH);
            element.setAttribute(ATTRIBUTE_VALUE, this.myBrowserPath);
            parentNode.addContent(element);
        }
        Element optionElement = new Element(ELEMENT_OPTION);
        optionElement.setAttribute(ATTRIBUTE_NAME, OPTION_LAST_TIP);
        optionElement.setAttribute(ATTRIBUTE_VALUE, Integer.toString(this.myLastTip));
        parentNode.addContent(optionElement);
        optionElement = new Element(ELEMENT_OPTION);
        optionElement.setAttribute(ATTRIBUTE_NAME, OPTION_SHOW_TIPS_ON_STARTUP);
        optionElement.setAttribute(ATTRIBUTE_VALUE, Boolean.toString(this.myShowTipsOnStartup));
        parentNode.addContent(optionElement);
        optionElement = new Element(ELEMENT_OPTION);
        optionElement.setAttribute(ATTRIBUTE_NAME, OPTION_SHOW_OCCUPIED_MEMORY);
        optionElement.setAttribute(ATTRIBUTE_VALUE, Boolean.toString(this.myShowOccupiedMemory));
        parentNode.addContent(optionElement);
        optionElement = new Element(ELEMENT_OPTION);
        optionElement.setAttribute(ATTRIBUTE_NAME, OPTION_REOPEN_LAST_PROJECT);
        optionElement.setAttribute(ATTRIBUTE_VALUE, Boolean.toString(this.myReopenLastProject));
        parentNode.addContent(optionElement);
        optionElement = new Element(ELEMENT_OPTION);
        optionElement.setAttribute(ATTRIBUTE_NAME, OPTION_AUTO_SYNC_FILES);
        optionElement.setAttribute(ATTRIBUTE_VALUE, Boolean.toString(this.mySyncOnFrameActivation));
        parentNode.addContent(optionElement);
        optionElement = new Element(ELEMENT_OPTION);
        optionElement.setAttribute(ATTRIBUTE_NAME, OPTION_AUTO_SAVE_FILES);
        optionElement.setAttribute(ATTRIBUTE_VALUE, Boolean.toString(this.mySaveOnFrameDeactivation));
        parentNode.addContent(optionElement);
        optionElement = new Element(ELEMENT_OPTION);
        optionElement.setAttribute(ATTRIBUTE_NAME, OPTION_AUTO_SAVE_IF_INACTIVE);
        optionElement.setAttribute(ATTRIBUTE_VALUE, (this.myAutoSaveIfInactive ? Boolean.TRUE : Boolean.FALSE).toString());
        parentNode.addContent(optionElement);
        optionElement = new Element(ELEMENT_OPTION);
        optionElement.setAttribute(ATTRIBUTE_NAME, "inactiveTimeout");
        optionElement.setAttribute(ATTRIBUTE_VALUE, Integer.toString(this.myInactiveTimeout));
        parentNode.addContent(optionElement);
        optionElement = new Element(ELEMENT_OPTION);
        optionElement.setAttribute(ATTRIBUTE_NAME, OPTION_USE_DEFAULT_BROWSER);
        optionElement.setAttribute(ATTRIBUTE_VALUE, Boolean.toString(this.myUseDefaultBrowser));
        parentNode.addContent(optionElement);
        optionElement = new Element(ELEMENT_OPTION);
        optionElement.setAttribute(ATTRIBUTE_NAME, OPTION_CONFIRM_EXTRACT_FILES);
        optionElement.setAttribute(ATTRIBUTE_VALUE, Boolean.toString(this.myConfirmExtractFiles));
        parentNode.addContent(optionElement);
        optionElement = new Element(ELEMENT_OPTION);
        optionElement.setAttribute(ATTRIBUTE_NAME, OPTION_SEARCH_IN_BACKGROUND);
        optionElement.setAttribute(ATTRIBUTE_VALUE, Boolean.toString(this.mySearchInBackground));
        parentNode.addContent(optionElement);
        optionElement = new Element(ELEMENT_OPTION);
        optionElement.setAttribute(ATTRIBUTE_NAME, OPTION_CONFIRM_EXIT);
        optionElement.setAttribute(ATTRIBUTE_VALUE, Boolean.toString(this.myConfirmExit));
        parentNode.addContent(optionElement);
        if (this.myLastProjectLocation != null) {
            optionElement = new Element(ELEMENT_OPTION);
            optionElement.setAttribute(ATTRIBUTE_NAME, OPTION_LAST_PROJECT_LOCATION);
            optionElement.setAttribute(ATTRIBUTE_VALUE, this.myLastProjectLocation);
            parentNode.addContent(optionElement);
        }
    }

    public String getExternalFileName() {
        return "ide.general";
    }

    @Override
    @NotNull
    public File[] getExportFiles() {
        File[] fileArray = new File[]{PathManager.getOptionsFile((NamedJDOMExternalizable)this)};
        if (fileArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/GeneralSettings.getExportFiles must not return null");
        }
        return fileArray;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = IdeBundle.message("general.settings", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/GeneralSettings.getPresentableName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String getComponentName() {
        if ("GeneralSettings" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/GeneralSettings.getComponentName must not return null");
        }
        return "GeneralSettings";
    }

    public boolean isUseDefaultBrowser() {
        return this.myUseDefaultBrowser;
    }

    public void setUseDefaultBrowser(boolean value) {
        this.myUseDefaultBrowser = value;
    }

    public boolean isConfirmExtractFiles() {
        return this.myConfirmExtractFiles;
    }

    public void setConfirmExtractFiles(boolean value) {
        this.myConfirmExtractFiles = value;
    }

    public boolean isConfirmExit() {
        return this.myConfirmExit;
    }

    public void setConfirmExit(boolean confirmExit) {
        this.myConfirmExit = confirmExit;
    }

    public boolean isSearchInBackground() {
        return this.mySearchInBackground;
    }

    public void setSearchInBackground(boolean searchInBackground) {
        this.mySearchInBackground = searchInBackground;
    }

    public boolean migrateCharsetSettingsTo(EncodingManager encodingProjectManager) {
        if (this.oldCharsetSettingsHaveBeenRead) {
            encodingProjectManager.setEncoding(null, this.myCharset);
            encodingProjectManager.setUseUTFGuessing(null, this.myUseUTFGuessing);
        }
        return this.oldCharsetSettingsHaveBeenRead;
    }
}

