/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationInfoProvider;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.UnknownConfigurationType;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnknownRunConfiguration
implements RunConfiguration {
    private ConfigurationFactory myFactory;
    private Element myStoredElement;
    private String myName;
    private Project myProject;
    private static final AtomicInteger myUniqueName = new AtomicInteger(1);
    private boolean myDoNotStore;

    public UnknownRunConfiguration(@NotNull ConfigurationFactory factory, @NotNull Project project) {
        if (factory == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/configurations/UnknownRunConfiguration.<init> must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/execution/configurations/UnknownRunConfiguration.<init> must not be null");
        }
        this.myFactory = factory;
        this.myProject = project;
    }

    public void setDoNotStore(boolean b) {
        this.myDoNotStore = b;
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return null;
    }

    public boolean isDoNotStore() {
        return this.myDoNotStore;
    }

    @Override
    public ConfigurationFactory getFactory() {
        return this.myFactory;
    }

    @Override
    public void setName(String name) {
        this.myName = name;
    }

    @Override
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        return new UnknownSettingsEditor();
    }

    @Override
    public Project getProject() {
        return this.myProject;
    }

    @Override
    @NotNull
    public ConfigurationType getType() {
        UnknownConfigurationType unknownConfigurationType = UnknownConfigurationType.INSTANCE;
        if (unknownConfigurationType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/execution/configurations/UnknownRunConfiguration.getType must not return null");
        }
        return unknownConfigurationType;
    }

    @Override
    public JDOMExternalizable createRunnerSettings(ConfigurationInfoProvider provider) {
        return null;
    }

    @Override
    public SettingsEditor<JDOMExternalizable> getRunnerSettingsEditor(ProgramRunner runner) {
        return null;
    }

    @Override
    public RunConfiguration clone() {
        try {
            UnknownRunConfiguration cloned = (UnknownRunConfiguration)super.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public int getUniqueID() {
        return System.identityHashCode(this);
    }

    @Override
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/configurations/UnknownRunConfiguration.getState must not be null");
        }
        if (env == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/execution/configurations/UnknownRunConfiguration.getState must not be null");
        }
        return null;
    }

    @Override
    public String getName() {
        if (this.myName == null) {
            this.myName = String.format("Unknown%s", myUniqueName.getAndAdd(1));
        }
        return this.myName;
    }

    @Override
    public void checkConfiguration() throws RuntimeConfigurationException {
        throw new RuntimeConfigurationException("Broken configuration due to unavailable plugin or invalid configuration data.");
    }

    public void readExternal(Element element) throws InvalidDataException {
        this.myStoredElement = (Element)element.clone();
    }

    public void writeExternal(Element element) throws WriteExternalException {
        if (this.myStoredElement != null) {
            List attributeList = this.myStoredElement.getAttributes();
            for (Object anAttributeList : attributeList) {
                Attribute a = (Attribute)anAttributeList;
                element.setAttribute(a.getName(), a.getValue());
            }
            List list = this.myStoredElement.getChildren();
            for (Object child : list) {
                Element c = (Element)child;
                element.addContent((Element)c.clone());
            }
        }
    }

    private static class UnknownSettingsEditor
    extends SettingsEditor<UnknownRunConfiguration> {
        private JPanel myPanel = new JPanel();

        private UnknownSettingsEditor() {
            this.myPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 50, 0));
            this.myPanel.add(new JLabel("This configuration can not be edited", 0));
        }

        @Override
        protected void resetEditorFrom(UnknownRunConfiguration s) {
        }

        @Override
        protected void applyEditorTo(UnknownRunConfiguration s) throws ConfigurationException {
        }

        @Override
        @NotNull
        protected JComponent createEditor() {
            JPanel jPanel = this.myPanel;
            if (jPanel == null) {
                throw new IllegalStateException("@NotNull method com/intellij/execution/configurations/UnknownRunConfiguration$UnknownSettingsEditor.createEditor must not return null");
            }
            return jPanel;
        }

        @Override
        protected void disposeEditor() {
        }
    }
}

