/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.trivialif;

import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.psiutils.BoolUtils;
import com.siyeh.ipp.psiutils.ConditionalUtils;
import com.siyeh.ipp.trivialif.SimplifyIfElsePredicate;
import org.jetbrains.annotations.NotNull;

public class SimplifyIfElseIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        SimplifyIfElsePredicate simplifyIfElsePredicate = new SimplifyIfElsePredicate();
        if (simplifyIfElsePredicate == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ipp/trivialif/SimplifyIfElseIntention.getElementPredicate must not return null");
        }
        return simplifyIfElsePredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/trivialif/SimplifyIfElseIntention.processIntention must not be null");
        }
        PsiIfStatement statement = (PsiIfStatement)element.getParent();
        if (SimplifyIfElsePredicate.isSimplifiableAssignment(statement)) {
            SimplifyIfElseIntention.replaceSimplifiableAssignment(statement);
        } else if (SimplifyIfElsePredicate.isSimplifiableReturn(statement)) {
            SimplifyIfElseIntention.replaceSimplifiableReturn(statement);
        } else if (SimplifyIfElsePredicate.isSimplifiableImplicitReturn(statement)) {
            SimplifyIfElseIntention.replaceSimplifiableImplicitReturn(statement);
        } else if (SimplifyIfElsePredicate.isSimplifiableAssignmentNegated(statement)) {
            SimplifyIfElseIntention.replaceSimplifiableAssignmentNegated(statement);
        } else if (SimplifyIfElsePredicate.isSimplifiableReturnNegated(statement)) {
            SimplifyIfElseIntention.replaceSimplifiableReturnNegated(statement);
        } else if (SimplifyIfElsePredicate.isSimplifiableImplicitReturnNegated(statement)) {
            SimplifyIfElseIntention.replaceSimplifiableImplicitReturnNegated(statement);
        } else if (SimplifyIfElsePredicate.isSimplifiableImplicitAssignment(statement)) {
            SimplifyIfElseIntention.replaceSimplifiableImplicitAssignment(statement);
        } else if (SimplifyIfElsePredicate.isSimplifiableImplicitAssignmentNegated(statement)) {
            SimplifyIfElseIntention.replaceSimplifiableImplicitAssignmentNegated(statement);
        }
    }

    private static void replaceSimplifiableImplicitReturn(PsiIfStatement statement) throws IncorrectOperationException {
        PsiExpression condition = statement.getCondition();
        if (condition == null) {
            return;
        }
        String conditionText = condition.getText();
        PsiElement nextStatement = PsiTreeUtil.skipSiblingsForward((PsiElement)statement, (Class[])new Class[]{PsiWhiteSpace.class});
        String newStatement = "return " + conditionText + ';';
        SimplifyIfElseIntention.replaceStatement(newStatement, (PsiStatement)statement);
        assert (nextStatement != null);
        nextStatement.delete();
    }

    private static void replaceSimplifiableReturn(PsiIfStatement statement) throws IncorrectOperationException {
        PsiExpression condition = statement.getCondition();
        if (condition == null) {
            return;
        }
        String conditionText = condition.getText();
        String newStatement = "return " + conditionText + ';';
        SimplifyIfElseIntention.replaceStatement(newStatement, (PsiStatement)statement);
    }

    private static void replaceSimplifiableAssignment(PsiIfStatement statement) throws IncorrectOperationException {
        PsiExpression condition = statement.getCondition();
        if (condition == null) {
            return;
        }
        String conditionText = condition.getText();
        PsiStatement thenBranch = statement.getThenBranch();
        PsiExpressionStatement assignmentStatement = (PsiExpressionStatement)ConditionalUtils.stripBraces(thenBranch);
        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)assignmentStatement.getExpression();
        PsiJavaToken operator = assignmentExpression.getOperationSign();
        String operand = operator.getText();
        PsiExpression lhs = assignmentExpression.getLExpression();
        String lhsText = lhs.getText();
        SimplifyIfElseIntention.replaceStatement(lhsText + operand + conditionText + ';', (PsiStatement)statement);
    }

    private static void replaceSimplifiableImplicitAssignment(PsiIfStatement statement) throws IncorrectOperationException {
        PsiElement prevStatement = PsiTreeUtil.skipSiblingsBackward((PsiElement)statement, (Class[])new Class[]{PsiWhiteSpace.class});
        PsiExpression condition = statement.getCondition();
        if (condition == null) {
            return;
        }
        String conditionText = condition.getText();
        PsiStatement thenBranch = statement.getThenBranch();
        PsiExpressionStatement assignmentStatement = (PsiExpressionStatement)ConditionalUtils.stripBraces(thenBranch);
        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)assignmentStatement.getExpression();
        PsiJavaToken operator = assignmentExpression.getOperationSign();
        String operand = operator.getText();
        PsiExpression lhs = assignmentExpression.getLExpression();
        String lhsText = lhs.getText();
        SimplifyIfElseIntention.replaceStatement(lhsText + operand + conditionText + ';', (PsiStatement)statement);
        assert (prevStatement != null);
        prevStatement.delete();
    }

    private static void replaceSimplifiableImplicitAssignmentNegated(PsiIfStatement statement) throws IncorrectOperationException {
        PsiElement prevStatement = PsiTreeUtil.skipSiblingsBackward((PsiElement)statement, (Class[])new Class[]{PsiWhiteSpace.class});
        PsiExpression condition = statement.getCondition();
        String conditionText = BoolUtils.getNegatedExpressionText(condition);
        PsiStatement thenBranch = statement.getThenBranch();
        PsiExpressionStatement assignmentStatement = (PsiExpressionStatement)ConditionalUtils.stripBraces(thenBranch);
        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)assignmentStatement.getExpression();
        PsiJavaToken operator = assignmentExpression.getOperationSign();
        String operand = operator.getText();
        PsiExpression lhs = assignmentExpression.getLExpression();
        String lhsText = lhs.getText();
        SimplifyIfElseIntention.replaceStatement(lhsText + operand + conditionText + ';', (PsiStatement)statement);
        assert (prevStatement != null);
        prevStatement.delete();
    }

    private static void replaceSimplifiableImplicitReturnNegated(PsiIfStatement statement) throws IncorrectOperationException {
        PsiExpression condition = statement.getCondition();
        String conditionText = BoolUtils.getNegatedExpressionText(condition);
        PsiElement nextStatement = PsiTreeUtil.skipSiblingsForward((PsiElement)statement, (Class[])new Class[]{PsiWhiteSpace.class});
        String newStatement = "return " + conditionText + ';';
        SimplifyIfElseIntention.replaceStatement(newStatement, (PsiStatement)statement);
        assert (nextStatement != null);
        nextStatement.delete();
    }

    private static void replaceSimplifiableReturnNegated(PsiIfStatement statement) throws IncorrectOperationException {
        PsiExpression condition = statement.getCondition();
        String conditionText = BoolUtils.getNegatedExpressionText(condition);
        String newStatement = "return " + conditionText + ';';
        SimplifyIfElseIntention.replaceStatement(newStatement, (PsiStatement)statement);
    }

    private static void replaceSimplifiableAssignmentNegated(PsiIfStatement statement) throws IncorrectOperationException {
        PsiExpression condition = statement.getCondition();
        String conditionText = BoolUtils.getNegatedExpressionText(condition);
        PsiStatement thenBranch = statement.getThenBranch();
        PsiExpressionStatement assignmentStatement = (PsiExpressionStatement)ConditionalUtils.stripBraces(thenBranch);
        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)assignmentStatement.getExpression();
        PsiJavaToken operator = assignmentExpression.getOperationSign();
        String operand = operator.getText();
        PsiExpression lhs = assignmentExpression.getLExpression();
        String lhsText = lhs.getText();
        SimplifyIfElseIntention.replaceStatement(lhsText + operand + conditionText + ';', (PsiStatement)statement);
    }
}

