/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.trivialif;

import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.trivialif.ExpandBooleanPredicate;
import org.jetbrains.annotations.NotNull;

public class ExpandBooleanIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        ExpandBooleanPredicate expandBooleanPredicate = new ExpandBooleanPredicate();
        if (expandBooleanPredicate == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ipp/trivialif/ExpandBooleanIntention.getElementPredicate must not return null");
        }
        return expandBooleanPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/trivialif/ExpandBooleanIntention.processIntention must not be null");
        }
        PsiStatement containingStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiStatement.class);
        if (containingStatement == null) {
            return;
        }
        if (ExpandBooleanPredicate.isBooleanAssignment(containingStatement)) {
            PsiExpressionStatement assignmentStatement = (PsiExpressionStatement)containingStatement;
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)assignmentStatement.getExpression();
            PsiExpression rhs = assignmentExpression.getRExpression();
            if (rhs == null) {
                return;
            }
            String rhsText = rhs.getText();
            PsiExpression lhs = assignmentExpression.getLExpression();
            String lhsText = lhs.getText();
            PsiJavaToken sign = assignmentExpression.getOperationSign();
            String signText = sign.getText();
            String conditionText = signText.length() == 2 ? lhsText + signText.charAt(0) + rhsText : rhsText;
            String statement = "if(" + conditionText + ") " + lhsText + " = true; else " + lhsText + " = false;";
            ExpandBooleanIntention.replaceStatement(statement, containingStatement);
        } else if (ExpandBooleanPredicate.isBooleanReturn(containingStatement)) {
            PsiReturnStatement returnStatement = (PsiReturnStatement)containingStatement;
            PsiExpression returnValue = returnStatement.getReturnValue();
            if (returnValue == null) {
                return;
            }
            String valueText = returnValue.getText();
            String statement = "if(" + valueText + ") return true; else return false;";
            ExpandBooleanIntention.replaceStatement(statement, containingStatement);
        }
    }
}

