/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.propertyInspector.properties;

import com.intellij.uiDesigner.propertyInspector.Property;
import com.intellij.uiDesigner.propertyInspector.PropertyEditor;
import com.intellij.uiDesigner.propertyInspector.PropertyRenderer;
import com.intellij.uiDesigner.propertyInspector.editors.AbstractTextFieldEditor;
import com.intellij.uiDesigner.propertyInspector.editors.BooleanEditor;
import com.intellij.uiDesigner.propertyInspector.editors.IntEditor;
import com.intellij.uiDesigner.propertyInspector.editors.PrimitiveTypeEditor;
import com.intellij.uiDesigner.propertyInspector.renderers.BooleanRenderer;
import com.intellij.uiDesigner.propertyInspector.renderers.LabelPropertyRenderer;
import com.intellij.uiDesigner.radComponents.RadComponent;
import org.jetbrains.annotations.NotNull;

public class ClientPropertyProperty
extends Property {
    private final PropertyRenderer myRenderer;
    private PropertyEditor myEditor;

    public ClientPropertyProperty(Property parent, String name, String valueClass) {
        super(parent, name);
        if (valueClass.equals(Boolean.class.getName())) {
            this.myRenderer = new BooleanRenderer();
            this.myEditor = new BooleanEditor();
        } else if (valueClass.equals(Double.class.getName())) {
            this.myRenderer = new LabelPropertyRenderer();
            this.myEditor = new PrimitiveTypeEditor<Double>(Double.class);
        } else {
            this.myRenderer = new LabelPropertyRenderer();
            if (valueClass.equals(Integer.class.getName())) {
                this.myEditor = new IntEditor(Integer.MIN_VALUE);
            } else if (valueClass.equals(String.class.getName())) {
                this.myEditor = new AbstractTextFieldEditor<String>(){

                    @Override
                    public String getValue() throws Exception {
                        return this.myTf.getText();
                    }
                };
            }
        }
    }

    public Object getValue(RadComponent component) {
        return component.getDelegee().getClientProperty(this.getName());
    }

    protected void setValueImpl(RadComponent component, Object value) throws Exception {
        component.getDelegee().putClientProperty(this.getName(), value);
    }

    public boolean isModified(RadComponent component) {
        return this.getValue(component) != null;
    }

    public void resetValue(RadComponent component) throws Exception {
        component.getDelegee().putClientProperty(this.getName(), null);
    }

    @NotNull
    public PropertyRenderer getRenderer() {
        PropertyRenderer propertyRenderer = this.myRenderer;
        if (propertyRenderer == null) {
            throw new IllegalStateException("@NotNull method com/intellij/uiDesigner/propertyInspector/properties/ClientPropertyProperty.getRenderer must not return null");
        }
        return propertyRenderer;
    }

    public PropertyEditor getEditor() {
        return this.myEditor;
    }
}

