/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.EmptyIterator;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class SmartList<E>
extends AbstractList<E> {
    private int mySize = 0;
    private Object myElem = null;

    public SmartList() {
    }

    public SmartList(E elem) {
        this.add(elem);
    }

    public SmartList(Collection<? extends E> c) {
        this.addAll(c);
    }

    @Override
    public E get(int index) {
        if (index < 0 || index >= this.mySize) {
            throw new IndexOutOfBoundsException("index= " + index + ". Must be index >= 0 && index < " + this.mySize);
        }
        if (this.mySize == 1) {
            return (E)this.myElem;
        }
        if (this.mySize == 2) {
            return (E)((Object[])this.myElem)[index];
        }
        return ((List)this.myElem).get(index);
    }

    @Override
    public boolean add(E e) {
        if (this.mySize == 0) {
            this.myElem = e;
        } else if (this.mySize == 1) {
            Object[] array = new Object[]{this.myElem, e};
            this.myElem = array;
        } else if (this.mySize == 2) {
            ArrayList<Object> list = new ArrayList<Object>(3);
            Object[] array = (Object[])this.myElem;
            list.add(array[0]);
            list.add(array[1]);
            list.add(e);
            this.myElem = list;
        } else {
            ((List)this.myElem).add(e);
        }
        ++this.mySize;
        ++this.modCount;
        return true;
    }

    @Override
    public int size() {
        return this.mySize;
    }

    @Override
    public void clear() {
        this.myElem = null;
        this.mySize = 0;
        ++this.modCount;
    }

    @Override
    public E set(int index, E element) {
        Object oldValue;
        if (index < 0 || index >= this.mySize) {
            throw new IndexOutOfBoundsException("index= " + index + ". Must be index > 0 && index < " + this.mySize);
        }
        if (this.mySize == 1) {
            oldValue = this.myElem;
            this.myElem = element;
        } else if (this.mySize == 2) {
            Object[] array = (Object[])this.myElem;
            oldValue = array[index];
            array[index] = element;
        } else {
            oldValue = ((List)this.myElem).set(index, element);
        }
        return (E)oldValue;
    }

    @Override
    public E remove(int index) {
        Object oldValue;
        if (index < 0 || index >= this.mySize) {
            throw new IndexOutOfBoundsException("index= " + index + ". Must be index >= 0 && index < " + this.mySize);
        }
        if (this.mySize == 1) {
            oldValue = this.myElem;
            this.myElem = null;
        } else if (this.mySize == 2) {
            Object[] array = (Object[])this.myElem;
            oldValue = array[index];
            this.myElem = array[1 - index];
        } else if (this.mySize == 3) {
            int i0;
            List list = (List)this.myElem;
            oldValue = list.get(index);
            Object[] array = new Object[2];
            int n = i0 = index == 0 ? 1 : 0;
            int i1 = index == 0 ? 2 : (index == 1 ? 2 : 1);
            array[0] = list.get(i0);
            array[1] = list.get(i1);
            this.myElem = array;
        } else {
            List list = (List)this.myElem;
            oldValue = list.remove(index);
        }
        --this.mySize;
        ++this.modCount;
        return (E)oldValue;
    }

    @Override
    public Iterator<E> iterator() {
        return this.mySize == 0 ? EmptyIterator.getInstance() : super.iterator();
    }

    @Override
    public boolean isEmpty() {
        return this.mySize == 0;
    }

    @Override
    public void sort(Comparator<E> comparator) {
        if (this.mySize < 2) {
            return;
        }
        if (this.mySize == 2) {
            Object[] array = (Object[])this.myElem;
            if (comparator.compare(array[0], array[1]) > 0) {
                Object t = array[0];
                array[0] = array[1];
                array[1] = t;
            }
        } else {
            ContainerUtil.sort((List)this.myElem, comparator);
        }
    }
}

