/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.move;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.refactoring.MoveDestination;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesProcessor;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesUtil;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.refactoring.GroovyChangeContextUtil;

public class MoveGroovyScriptProcessor
extends MoveClassesOrPackagesProcessor {
    public MoveGroovyScriptProcessor(Project project, PsiElement[] elements, MoveDestination moveDestination, boolean searchInComments, boolean searchInNonJavaFiles, MoveCallback moveCallback) {
        super(project, elements, moveDestination, searchInComments, searchInNonJavaFiles, moveCallback);
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        ArrayList<Object> allUsages = new ArrayList<Object>();
        MultiMap conflicts = new MultiMap();
        List elements = this.getElements();
        for (PsiElement element : elements) {
            GroovyFile groovyFile = (GroovyFile)element;
            PsiClass scriptClass = groovyFile.getClasses()[0];
            String newName = this.getTargetPackage().getQualifiedName() + scriptClass.getName();
            UsageInfo[] usages = MoveClassesOrPackagesUtil.findUsages((PsiElement)scriptClass, (boolean)this.isSearchInComments(), (boolean)this.isSearchInNonJavaFiles(), (String)newName);
            allUsages.addAll(new ArrayList<UsageInfo>(Arrays.asList(usages)));
        }
        this.myMoveDestination.analyzeModuleConflicts((Collection)elements, conflicts, allUsages.toArray(new UsageInfo[allUsages.size()]));
        if (!conflicts.isEmpty()) {
            allUsages.add(new MoveClassesOrPackagesProcessor.ConflictsUsageInfo((PsiElement)elements.get(0), conflicts));
        }
        UsageInfo[] usageInfoArray = UsageViewUtil.removeDuplicatedUsages((UsageInfo[])allUsages.toArray(new UsageInfo[allUsages.size()]));
        if (usageInfoArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/refactoring/move/MoveGroovyScriptProcessor.findUsages must not return null");
        }
        return usageInfoArray;
    }

    protected boolean preprocessUsages(Ref<UsageInfo[]> refUsages) {
        return this.showConflicts(new MultiMap());
    }

    protected void performRefactoring(UsageInfo[] usages) {
        try {
            HashMap oldToNewElementsMapping = new HashMap();
            List elements = this.getElements();
            for (PsiElement element : elements) {
                GroovyFile file = (GroovyFile)element;
                RefactoringElementListener elementListener = this.getTransaction().getElementListener((PsiElement)file);
                PsiClass oldScriptClass = file.getClasses()[0];
                GroovyChangeContextUtil.encodeContextInfo(file);
                PsiManager.getInstance((Project)this.myProject).moveFile((PsiFile)file, this.myMoveDestination.getTargetDirectory((PsiFile)file));
                file.setPackageName(this.getTargetPackage().getQualifiedName());
                PsiClass newScriptClass = file.getClasses()[0];
                oldToNewElementsMapping.put(oldScriptClass, newScriptClass);
                elementListener.elementMoved((PsiElement)file);
            }
            for (PsiElement element : elements) {
                GroovyChangeContextUtil.decodeContextInfo(element, null, null);
            }
            this.myNonCodeUsages = MoveGroovyScriptProcessor.retargetUsages((UsageInfo[])usages, (Map)oldToNewElementsMapping);
        }
        catch (IncorrectOperationException e) {
            this.myNonCodeUsages = new NonCodeUsageInfo[0];
            RefactoringUIUtil.processIncorrectOperation((Project)this.myProject, (IncorrectOperationException)e);
        }
    }
}

