/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.util;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;

public class PsiElementUtil {
    public static final String GETTER_PREFIX = "get";
    public static final String SETTER_PREFIX = "set";

    public static boolean isPropertyAccessor(GrCall call) {
        return PsiElementUtil.isGetterInvocation(call) || PsiElementUtil.isSetterInvocation(call);
    }

    public static boolean isSetterInvocation(GrCall call) {
        GrArgumentList args;
        PsiMethod method;
        PsiElement element;
        GrExpression expr;
        if (!(call instanceof GrMethodCallExpression) && !(call instanceof GrApplicationStatement)) {
            return false;
        }
        GrExpression grExpression = expr = call instanceof GrMethodCallExpression ? ((GrMethodCallExpression)call).getInvokedExpression() : ((GrApplicationStatement)call).getFunExpression();
        if (!(expr instanceof GrReferenceExpression)) {
            return false;
        }
        GrReferenceExpression refExpr = (GrReferenceExpression)expr;
        String name = refExpr.getName();
        if (name == null || !name.startsWith(SETTER_PREFIX)) {
            return false;
        }
        String propName = StringUtil.decapitalize((String)(name = name.substring(SETTER_PREFIX.length())));
        if (propName.length() == 0 || name.equals(propName)) {
            return false;
        }
        if (call instanceof GrApplicationStatement ? !((element = refExpr.resolve()) instanceof PsiMethod) || !GroovyPropertyUtils.isSimplePropertySetter((PsiMethod)element) : !GroovyPropertyUtils.isSimplePropertySetter(method = ((GrMethodCallExpression)call).resolveMethod())) {
            return false;
        }
        if (call instanceof GrMethodCallExpression) {
            args = call.getArgumentList();
            return args != null && args.getExpressionArguments().length == 1 && args.getNamedArguments().length == 0;
        }
        args = call.getArgumentList();
        return args != null && args.getExpressionArguments().length == 1 && args.getNamedArguments().length == 0;
    }

    public static boolean isGetterInvocation(GrCall call) {
        if (!(call instanceof GrMethodCallExpression)) {
            return false;
        }
        GrMethodCallExpression methodCall = (GrMethodCallExpression)call;
        GrExpression expr = methodCall.getInvokedExpression();
        if (!(expr instanceof GrReferenceExpression)) {
            return false;
        }
        GrReferenceExpression refExpr = (GrReferenceExpression)expr;
        String name = refExpr.getName();
        if (name == null || !name.startsWith(GETTER_PREFIX)) {
            return false;
        }
        String propName = StringUtil.decapitalize((String)(name = name.substring(GETTER_PREFIX.length())));
        if (propName.length() == 0 || name.equals(propName)) {
            return false;
        }
        PsiMethod method = methodCall.resolveMethod();
        if (!GroovyPropertyUtils.isSimplePropertyGetter(method)) {
            return false;
        }
        GrArgumentList args = methodCall.getArgumentList();
        return args != null && args.getExpressionArguments().length == 0;
    }
}

