/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.path;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrTupleType;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrExpressionImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public class GrIndexPropertyImpl
extends GrExpressionImpl
implements GrIndexProperty {
    public GrIndexPropertyImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/path/GrIndexPropertyImpl.<init> must not be null");
        }
        super(node);
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitIndexProperty(this);
    }

    public String toString() {
        return "Property by index";
    }

    @Override
    @NotNull
    public GrExpression getSelectedExpression() {
        GrExpression result = (GrExpression)this.findChildByClass(GrExpression.class);
        assert (result != null);
        GrExpression grExpression = result;
        if (grExpression == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/path/GrIndexPropertyImpl.getSelectedExpression must not return null");
        }
        return grExpression;
    }

    @Override
    public GrArgumentList getArgumentList() {
        return (GrArgumentList)this.findChildByClass(GrArgumentList.class);
    }

    @Override
    public PsiType getType() {
        GrArgumentList argList;
        GrExpression selected = this.getSelectedExpression();
        PsiType thisType = selected.getType();
        if (thisType != null && (argList = this.getArgumentList()) != null) {
            PsiType iterType;
            PsiElement element;
            GrExpression[] arguments = argList.getExpressionArguments();
            PsiType[] argTypes = new PsiType[arguments.length];
            for (int i = 0; i < arguments.length; ++i) {
                PsiType argType = arguments[i].getType();
                if (argType == null) {
                    argType = TypesUtil.getJavaLangObject(argList);
                }
                argTypes[i] = argType;
            }
            if (thisType instanceof GrTupleType) {
                PsiType[] types = ((GrTupleType)thisType).getParameters();
                return types.length == 1 ? types[0] : null;
            }
            PsiType overloadedOperatorType = null;
            GroovyResolveResult[] candidates = TypesUtil.getOverloadedOperatorCandidates(thisType, "getAt", (GroovyPsiElement)this, argTypes);
            if (candidates.length == 1 && (element = candidates[0].getElement()) instanceof PsiMethod && (overloadedOperatorType = candidates[0].getSubstitutor().substitute(((PsiMethod)element).getReturnType())) != null && !(element instanceof GrGdkMethod)) {
                return overloadedOperatorType;
            }
            if (thisType instanceof PsiArrayType) {
                PsiType componentType = ((PsiArrayType)thisType).getComponentType();
                return TypesUtil.boxPrimitiveType(componentType, (PsiManager)this.getManager(), this.getResolveScope());
            }
            if (InheritanceUtil.isInheritor((PsiType)thisType, (String)"java.util.List") && (iterType = PsiUtil.extractIterableTypeParameter((PsiType)thisType, (boolean)true)) != null) {
                return iterType;
            }
            if (InheritanceUtil.isInheritor((PsiType)thisType, (String)"java.util.Map")) {
                return PsiUtil.substituteTypeParameter((PsiType)thisType, (String)"java.util.Map", (int)1, (boolean)true);
            }
            return overloadedOperatorType;
        }
        return null;
    }
}

