/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyParser;
import org.jetbrains.plugins.groovy.lang.parser.parsing.auxiliary.VariableInitializer;
import org.jetbrains.plugins.groovy.lang.parser.parsing.auxiliary.annotations.Annotation;
import org.jetbrains.plugins.groovy.lang.parser.parsing.auxiliary.modifiers.Modifiers;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.BranchStatement;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.declaration.DeclarationStart;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.ExpressionStatement;
import org.jetbrains.plugins.groovy.lang.parser.parsing.types.TypeSpec;
import org.jetbrains.plugins.groovy.lang.parser.parsing.util.ParserUtils;

public class StrictContextExpression
implements GroovyElementTypes {
    public static boolean parse(PsiBuilder builder, GroovyParser parser) {
        if (BranchStatement.BRANCH_KEYWORDS.contains(builder.getTokenType())) {
            return BranchStatement.parse(builder, parser);
        }
        if (mAT.equals(builder.getTokenType())) {
            return Annotation.parse(builder, parser);
        }
        if (DeclarationStart.parse(builder, parser)) {
            StrictContextExpression.singleDeclarationParse(builder, parser);
            return true;
        }
        return ExpressionStatement.argParse(builder, parser);
    }

    public static void singleDeclarationParse(PsiBuilder builder, GroovyParser parser) {
        PsiBuilder.Marker marker = builder.mark();
        if (Modifiers.parse(builder, parser)) {
            PsiBuilder.Marker rb = builder.mark();
            TypeSpec.parse(builder);
            if (!mIDENT.equals(builder.getTokenType())) {
                rb.rollbackTo();
            } else {
                rb.drop();
            }
            ParserUtils.getToken(builder, mIDENT, GroovyBundle.message("identifier.expected", new Object[0]));
            if (mASSIGN.equals(builder.getTokenType())) {
                VariableInitializer.parse(builder, parser);
            }
            marker.done((IElementType)VARIABLE_DEFINITION);
        } else if (TypeSpec.parse(builder)) {
            ParserUtils.getToken(builder, mIDENT, GroovyBundle.message("identifier.expected", new Object[0]));
            if (mASSIGN.equals(builder.getTokenType())) {
                VariableInitializer.parse(builder, parser);
            }
            marker.done((IElementType)VARIABLE_DEFINITION);
        } else {
            builder.error(GroovyBundle.message("type.specification.expected", new Object[0]));
        }
    }
}

