/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.conversions;

import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import java.math.BigInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.IntentionUtils;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.intentions.conversions.ConvertIntegerToOctalPredicate;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;

public class ConvertIntegerToOctalIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        ConvertIntegerToOctalPredicate convertIntegerToOctalPredicate = new ConvertIntegerToOctalPredicate();
        if (convertIntegerToOctalPredicate == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/intentions/conversions/ConvertIntegerToOctalIntention.getElementPredicate must not return null");
        }
        return convertIntegerToOctalPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        BigInteger val;
        boolean isLong;
        int textLength;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/intentions/conversions/ConvertIntegerToOctalIntention.processIntention must not be null");
        }
        GrLiteral exp = (GrLiteral)element;
        String textString = exp.getText();
        char lastChar = textString.charAt((textLength = textString.length()) - 1);
        boolean bl = isLong = lastChar == 'l' || lastChar == 'L';
        if (isLong) {
            textString = textString.substring(0, textLength - 1);
        }
        if (textString.startsWith("0x")) {
            String rawTextString = textString.substring(2);
            val = new BigInteger(rawTextString, 16);
        } else {
            val = new BigInteger(textString, 10);
        }
        String octString = '0' + val.toString(8);
        if (isLong) {
            octString = octString + 'L';
        }
        IntentionUtils.replaceExpression(octString, exp);
    }
}

