/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.gradle;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.lang.UrlClassLoader;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ReferenceType;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.extensions.GroovyScriptType;
import org.jetbrains.plugins.groovy.extensions.debugger.ScriptPositionManagerHelper;
import org.jetbrains.plugins.groovy.gradle.GradleLibraryManager;
import org.jetbrains.plugins.groovy.gradle.GradleScriptType;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;

public class GradlePositionManager
extends ScriptPositionManagerHelper {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.groovy.gradle.GradlePositionManager");
    private static final Pattern GRADLE_CLASS_PATTERN = Pattern.compile(".*_gradle_.*");
    private static final Key<CachedValue<ClassLoader>> GRADLE_CLASS_LOADER = Key.create((String)"GRADLE_CLASS_LOADER");
    private static final Key<CachedValue<FactoryMap<File, String>>> GRADLE_CLASS_NAME = Key.create((String)"GRADLE_CLASS_NAME");

    @Override
    public boolean isAppropriateRuntimeName(@NotNull String runtimeName) {
        if (runtimeName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/gradle/GradlePositionManager.isAppropriateRuntimeName must not be null");
        }
        return GRADLE_CLASS_PATTERN.matcher(runtimeName).matches();
    }

    @Override
    public boolean isAppropriateScriptFile(@NotNull PsiFile scriptFile) {
        if (scriptFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/gradle/GradlePositionManager.isAppropriateScriptFile must not be null");
        }
        return GroovyScriptType.getScriptType((GroovyFile)scriptFile) instanceof GradleScriptType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public String getRuntimeScriptName(@NotNull String originalName, GroovyFile groovyFile) {
        if (originalName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/gradle/GradlePositionManager.getRuntimeScriptName must not be null");
        }
        VirtualFile virtualFile = groovyFile.getVirtualFile();
        if (virtualFile == null) {
            return "";
        }
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)groovyFile);
        if (module == null) {
            return "";
        }
        File scriptFile = VfsUtil.virtualToIoFile((VirtualFile)virtualFile);
        String className = (String)((FactoryMap)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, GRADLE_CLASS_NAME, (CachedValueProvider)new ScriptSourceMapCalculator(module), false)).get((Object)scriptFile);
        if (className == null) {
            return "";
        }
        String string = className;
        String string2 = string;
        if (string == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/gradle/GradlePositionManager.getRuntimeScriptName must not return null");
        return string2;
    }

    @Override
    public PsiFile getExtraScriptIfNotFound(ReferenceType refType, @NotNull String runtimeName, Project project) {
        if (runtimeName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/gradle/GradlePositionManager.getExtraScriptIfNotFound must not be null");
        }
        String sourceFilePath = GradlePositionManager.getScriptForClassName(refType);
        if (sourceFilePath == null) {
            return null;
        }
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)sourceFilePath));
        if (virtualFile == null) {
            return null;
        }
        return PsiManager.getInstance((Project)project).findFile(virtualFile);
    }

    @Nullable
    private static String getScriptForClassName(@NotNull ReferenceType refType) {
        if (refType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/gradle/GradlePositionManager.getScriptForClassName must not be null");
        }
        try {
            List<String> data = refType.sourcePaths(null);
            if (!data.isEmpty()) {
                return data.get(0);
            }
        }
        catch (AbsentInformationException absentInformationException) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    private static ClassLoader getGradleClassLoader(final @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/gradle/GradlePositionManager.getGradleClassLoader must not be null");
        }
        final Project project = module.getProject();
        return (ClassLoader)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)module, GRADLE_CLASS_LOADER, (CachedValueProvider)new CachedValueProvider<ClassLoader>(){

            public CachedValueProvider.Result<ClassLoader> compute() {
                return CachedValueProvider.Result.create((Object)GradlePositionManager.createGradleClassLoader(module), (Object[])new Object[]{ProjectRootManager.getInstance((Project)project)});
            }
        }, false);
    }

    @Nullable
    private static ClassLoader createGradleClassLoader(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/gradle/GradlePositionManager.createGradleClassLoader must not be null");
        }
        VirtualFile sdkHome = GradleLibraryManager.getSdkHome(module, module.getProject());
        if (sdkHome == null) {
            return null;
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        VirtualFile libDir = sdkHome.findChild("lib");
        assert (libDir != null);
        for (VirtualFile child : libDir.getChildren()) {
            if (!"jar".equals(child.getExtension())) continue;
            urls.add(VfsUtil.convertToURL((String)child.getUrl()));
        }
        return new UrlClassLoader(urls, null);
    }

    private static class ScriptSourceMapCalculator
    implements CachedValueProvider<FactoryMap<File, String>> {
        private final Module myModule;

        public ScriptSourceMapCalculator(Module module) {
            this.myModule = module;
        }

        public CachedValueProvider.Result<FactoryMap<File, String>> compute() {
            ConcurrentFactoryMap<File, String> result = new ConcurrentFactoryMap<File, String>(){

                protected String create(File scriptFile) {
                    return ScriptSourceMapCalculator.this.calcClassName(scriptFile);
                }
            };
            return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{ProjectRootManager.getInstance((Project)this.myModule.getProject())});
        }

        @Nullable
        private String calcClassName(File scriptFile) {
            ClassLoader loader = GradlePositionManager.getGradleClassLoader(this.myModule);
            if (loader != null) {
                Class<?> fileScriptSource;
                try {
                    fileScriptSource = Class.forName("org.gradle.groovy.scripts.UriScriptSource", true, loader);
                }
                catch (ClassNotFoundException e) {
                    try {
                        fileScriptSource = Class.forName("org.gradle.groovy.scripts.FileScriptSource", true, loader);
                    }
                    catch (ClassNotFoundException e1) {
                        return null;
                    }
                }
                try {
                    Object source = fileScriptSource.getConstructor(String.class, File.class).newInstance("script", scriptFile);
                    return (String)fileScriptSource.getMethod("getClassName", new Class[0]).invoke(source, new Object[0]);
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            }
            return null;
        }
    }
}

