/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.commands.GitCommand;
import git4idea.commands.GitSimpleHandler;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitFileRevision
implements VcsFileRevision,
Comparable<VcsFileRevision> {
    private static final Charset BIN_ENCODING = Charset.forName("ISO-8859-1");
    private final FilePath path;
    private final GitRevisionNumber revision;
    private final String author;
    private final String message;
    private byte[] content;
    private final Project project;
    private final String branch;

    public GitFileRevision(@NotNull Project project, @NotNull FilePath path, @NotNull GitRevisionNumber revision) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/GitFileRevision.<init> must not be null");
        }
        if (path == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of git4idea/GitFileRevision.<init> must not be null");
        }
        if (revision == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of git4idea/GitFileRevision.<init> must not be null");
        }
        this(project, path, revision, null, null, null);
    }

    public GitFileRevision(@NotNull Project project, @NotNull FilePath path, @NotNull GitRevisionNumber revision, @Nullable String author, @Nullable String message, @Nullable String branch) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/GitFileRevision.<init> must not be null");
        }
        if (path == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of git4idea/GitFileRevision.<init> must not be null");
        }
        if (revision == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of git4idea/GitFileRevision.<init> must not be null");
        }
        this.project = project;
        this.path = path;
        this.revision = revision;
        this.author = author;
        this.message = message;
        this.branch = branch;
    }

    public FilePath getPath() {
        return this.path;
    }

    public VcsRevisionNumber getRevisionNumber() {
        return this.revision;
    }

    public Date getRevisionDate() {
        return this.revision.getTimestamp();
    }

    public String getAuthor() {
        return this.author;
    }

    public String getCommitMessage() {
        return this.message;
    }

    public String getBranchName() {
        return this.branch;
    }

    public synchronized void loadContent() throws VcsException {
        VirtualFile root = GitUtil.getGitRoot(this.path);
        GitSimpleHandler h = new GitSimpleHandler(this.project, root, GitCommand.SHOW);
        h.setNoSSH(true);
        h.setCharset(BIN_ENCODING);
        h.setSilent(true);
        h.addParameters(this.revision.getRev() + ":" + GitUtil.relativePath(root, this.path));
        String result = h.run();
        try {
            this.content = result.getBytes(BIN_ENCODING.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new VcsException("Unable to locate encoding: " + BIN_ENCODING.name() + " Reason: " + e.toString(), (Throwable)e);
        }
    }

    public synchronized byte[] getContent() throws IOException {
        if (this.content == null) {
            try {
                this.loadContent();
            }
            catch (VcsException e) {
                throw new IOException(e.getMessage());
            }
        }
        return this.content;
    }

    @Override
    public int compareTo(VcsFileRevision rev) {
        if (rev instanceof GitFileRevision) {
            return this.revision.compareTo(((GitFileRevision)rev).revision);
        }
        return this.getRevisionDate().compareTo(rev.getRevisionDate());
    }
}

