/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.impl.XDebuggerHistoryManager;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public abstract class XDebuggerEditorBase {
    private final Project myProject;
    private final XDebuggerEditorsProvider myDebuggerEditorsProvider;
    @Nullable
    private final String myHistoryId;
    private final XSourcePosition mySourcePosition;
    private int myHistoryIndex;

    protected XDebuggerEditorBase(Project project, XDebuggerEditorsProvider debuggerEditorsProvider, @Nullable @NonNls String historyId, @Nullable XSourcePosition sourcePosition) {
        this.myProject = project;
        this.myDebuggerEditorsProvider = debuggerEditorsProvider;
        this.myHistoryId = historyId;
        this.mySourcePosition = sourcePosition;
    }

    public abstract JComponent getComponent();

    protected abstract void doSetText(String var1);

    public void setText(String text) {
        this.saveTextInHistory(text);
        this.doSetText(text);
    }

    public abstract String getText();

    @Nullable
    public abstract JComponent getPreferredFocusedComponent();

    public abstract void selectAll();

    protected void onHistoryChanged() {
    }

    protected List<String> getRecentExpressions() {
        if (this.myHistoryId != null) {
            return XDebuggerHistoryManager.getInstance(this.myProject).getRecentExpressions(this.myHistoryId);
        }
        return Collections.emptyList();
    }

    public void saveTextInHistory() {
        this.saveTextInHistory(this.getText());
    }

    private void saveTextInHistory(String text) {
        if (this.myHistoryId != null) {
            XDebuggerHistoryManager.getInstance(this.myProject).addRecentExpression(this.myHistoryId, text);
            this.myHistoryIndex = 0;
            this.onHistoryChanged();
        }
    }

    public XDebuggerEditorsProvider getEditorsProvider() {
        return this.myDebuggerEditorsProvider;
    }

    public Project getProject() {
        return this.myProject;
    }

    protected Document createDocument(String text) {
        return this.getEditorsProvider().createDocument(this.getProject(), text, this.mySourcePosition);
    }

    public boolean canGoBackward() {
        return this.myHistoryIndex < this.getRecentExpressions().size() - 1;
    }

    public boolean canGoForward() {
        return this.myHistoryIndex > 0;
    }

    public void goBackward() {
        List<String> expressions = this.getRecentExpressions();
        if (this.myHistoryIndex < expressions.size() - 1) {
            ++this.myHistoryIndex;
            this.doSetText(expressions.get(this.myHistoryIndex));
        }
    }

    public void goForward() {
        List<String> expressions = this.getRecentExpressions();
        if (this.myHistoryIndex > 0) {
            --this.myHistoryIndex;
            this.doSetText(expressions.get(this.myHistoryIndex));
        }
    }
}

