/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions.handlers;

import com.intellij.codeInsight.folding.impl.ExpandRegionHandler;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.actions.DebuggerActionHandler;
import org.jetbrains.annotations.NotNull;

public class XToggleLineBreakpointActionHandler
extends DebuggerActionHandler {
    @Override
    public boolean isEnabled(@NotNull Project project, AnActionEvent event) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/actions/handlers/XToggleLineBreakpointActionHandler.isEnabled must not be null");
        }
        XSourcePosition position = XDebuggerUtilImpl.getCaretPosition(project, event.getDataContext());
        if (position == null) {
            return false;
        }
        XLineBreakpointType[] breakpointTypes = XDebuggerUtil.getInstance().getLineBreakpointTypes();
        XBreakpointManager breakpointManager = XDebuggerManager.getInstance((Project)project).getBreakpointManager();
        for (XLineBreakpointType breakpointType : breakpointTypes) {
            int line;
            VirtualFile file = position.getFile();
            if (!breakpointType.canPutAt(file, line = position.getLine(), project) && breakpointManager.findBreakpointAtLine(breakpointType, file, line) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public void perform(@NotNull Project project, AnActionEvent event) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/actions/handlers/XToggleLineBreakpointActionHandler.perform must not be null");
        }
        XSourcePosition position = XDebuggerUtilImpl.getCaretPosition(project, event.getDataContext());
        if (position == null) {
            return;
        }
        ExpandRegionHandler.expandRegionAtCaret(project, (Editor)event.getData(PlatformDataKeys.EDITOR));
        int line = position.getLine();
        VirtualFile file = position.getFile();
        XBreakpointManager breakpointManager = XDebuggerManager.getInstance((Project)project).getBreakpointManager();
        for (XLineBreakpointType type : XDebuggerUtil.getInstance().getLineBreakpointTypes()) {
            if (!type.canPutAt(file, line, project) && breakpointManager.findBreakpointAtLine(type, file, line) == null) continue;
            XDebuggerUtil.getInstance().toggleLineBreakpoint(project, type, file, line);
            return;
        }
    }
}

