/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.JavaResolveCache;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.java.ExpressionPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiBinaryExpressionImpl
extends ExpressionPsiElement
implements PsiBinaryExpression {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.tree.java.PsiBinaryExpressionImpl");
    private static final Function<PsiBinaryExpressionImpl, PsiType> MY_TYPE_EVALUATOR = new Function<PsiBinaryExpressionImpl, PsiType>(){

        public PsiType fun(PsiBinaryExpressionImpl expression) {
            return PsiBinaryExpressionImpl.doGetType(expression);
        }
    };
    private static final TokenSet OUR_OPERATIONS_BIT_SET = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.OROR, JavaTokenType.ANDAND, JavaTokenType.OR, JavaTokenType.XOR, JavaTokenType.AND, JavaTokenType.EQEQ, JavaTokenType.NE, JavaTokenType.LT, JavaTokenType.GT, JavaTokenType.LE, JavaTokenType.GE, JavaTokenType.LTLT, JavaTokenType.GTGT, JavaTokenType.GTGTGT, JavaTokenType.PLUS, JavaTokenType.MINUS, JavaTokenType.ASTERISK, JavaTokenType.DIV, JavaTokenType.PERC});

    public PsiBinaryExpressionImpl() {
        super(JavaElementType.BINARY_EXPRESSION);
    }

    @NotNull
    public PsiExpression getLOperand() {
        PsiExpression psiExpression = (PsiExpression)this.findChildByRoleAsPsiElement(61);
        if (psiExpression == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiBinaryExpressionImpl.getLOperand must not return null");
        }
        return psiExpression;
    }

    public PsiExpression getROperand() {
        return (PsiExpression)this.findChildByRoleAsPsiElement(62);
    }

    @NotNull
    public PsiJavaToken getOperationSign() {
        PsiJavaToken psiJavaToken = (PsiJavaToken)this.findChildByRoleAsPsiElement(63);
        if (psiJavaToken == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiBinaryExpressionImpl.getOperationSign must not return null");
        }
        return psiJavaToken;
    }

    @NotNull
    public IElementType getOperationTokenType() {
        IElementType iElementType = this.getOperationSign().getTokenType();
        if (iElementType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiBinaryExpressionImpl.getOperationTokenType must not return null");
        }
        return iElementType;
    }

    private static PsiType doGetType(PsiBinaryExpressionImpl param) {
        IElementType sign;
        PsiExpression lOperand = param.getLOperand();
        PsiExpression rOperand = param.getROperand();
        if (rOperand == null) {
            return null;
        }
        PsiType rType = rOperand.getType();
        PsiType type = PsiBinaryExpressionImpl.calcTypeForBinaryExpression(null, rType, sign = param.getOperationSign().getNode().getElementType(), false);
        if (type != JavaResolveCache.NULL_TYPE) {
            return type;
        }
        if (lOperand instanceof PsiBinaryExpressionImpl && !JavaResolveCache.getInstance(param.getProject()).isTypeCached(lOperand)) {
            PsiBinaryExpressionImpl topLevel = param;
            PsiBinaryExpressionImpl element = param;
            while (element instanceof PsiBinaryExpressionImpl) {
                topLevel = element;
                element = element.getParent();
            }
            topLevel.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                protected void elementFinished(PsiElement element) {
                    if (element instanceof PsiExpression) {
                        ProgressManager.checkCanceled();
                        ((PsiExpression)element).getType();
                    }
                }
            });
        }
        PsiType lType = lOperand.getType();
        return PsiBinaryExpressionImpl.calcTypeForBinaryExpression(lType, rType, sign, true);
    }

    public PsiType getType() {
        return JavaResolveCache.getInstance(this.getProject()).getType(this, MY_TYPE_EVALUATOR);
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 61: {
                return this.getFirstChildNode();
            }
            case 62: {
                return ElementType.EXPRESSION_BIT_SET.contains(this.getLastChildNode().getElementType()) ? this.getLastChildNode() : null;
            }
            case 63: 
        }
        return this.findChildByType(OUR_OPERATIONS_BIT_SET);
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        if (ElementType.EXPRESSION_BIT_SET.contains(child.getElementType())) {
            if (child == this.getFirstChildNode()) {
                return 61;
            }
            if (child == this.getLastChildNode()) {
                return 62;
            }
            return 0;
        }
        if (OUR_OPERATIONS_BIT_SET.contains(child.getElementType())) {
            return 63;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiBinaryExpressionImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitBinaryExpression((PsiBinaryExpression)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    public String toString() {
        return "PsiBinaryExpression:" + this.getText();
    }

    @Nullable
    public static PsiType calcTypeForBinaryExpression(PsiType lType, PsiType rType, IElementType sign, boolean accessLType) {
        if (sign == JavaTokenType.PLUS) {
            if (rType == null) {
                return null;
            }
            if (rType.equalsToText("java.lang.String")) {
                return rType;
            }
            if (!accessLType) {
                return JavaResolveCache.NULL_TYPE;
            }
            if (lType == null) {
                return null;
            }
            if (lType.equalsToText("java.lang.String")) {
                return lType;
            }
            return TypeConversionUtil.unboxAndBalanceTypes((PsiType)lType, (PsiType)rType);
        }
        if (sign == JavaTokenType.MINUS || sign == JavaTokenType.ASTERISK || sign == JavaTokenType.DIV || sign == JavaTokenType.PERC) {
            if (rType == null) {
                return null;
            }
            if (!accessLType) {
                return JavaResolveCache.NULL_TYPE;
            }
            if (lType == null) {
                return null;
            }
            return TypeConversionUtil.unboxAndBalanceTypes((PsiType)lType, (PsiType)rType);
        }
        if (sign == JavaTokenType.LTLT || sign == JavaTokenType.GTGT || sign == JavaTokenType.GTGTGT) {
            if (!accessLType) {
                return JavaResolveCache.NULL_TYPE;
            }
            if (PsiType.BYTE.equals(lType) || PsiType.CHAR.equals(lType) || PsiType.SHORT.equals(lType)) {
                return PsiType.INT;
            }
            return lType;
        }
        if (sign == JavaTokenType.EQEQ || sign == JavaTokenType.NE || sign == JavaTokenType.LT || sign == JavaTokenType.GT || sign == JavaTokenType.LE || sign == JavaTokenType.GE || sign == JavaTokenType.OROR || sign == JavaTokenType.ANDAND) {
            return PsiType.BOOLEAN;
        }
        if (sign == JavaTokenType.OR || sign == JavaTokenType.XOR || sign == JavaTokenType.AND) {
            if (rType instanceof PsiClassType) {
                rType = PsiPrimitiveType.getUnboxedType((PsiType)rType);
            }
            if (lType instanceof PsiClassType) {
                lType = PsiPrimitiveType.getUnboxedType((PsiType)lType);
            }
            if (rType == null) {
                return null;
            }
            if (PsiType.BOOLEAN.equals(rType)) {
                return PsiType.BOOLEAN;
            }
            if (!accessLType) {
                return JavaResolveCache.NULL_TYPE;
            }
            if (lType == null) {
                return null;
            }
            if (PsiType.BOOLEAN.equals(lType)) {
                return PsiType.BOOLEAN;
            }
            if (PsiType.LONG.equals(lType) || PsiType.LONG.equals(rType)) {
                return PsiType.LONG;
            }
            return PsiType.INT;
        }
        LOG.error("Unknown token: " + sign);
        return null;
    }
}

