/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference;

import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.util.Trinity;
import com.intellij.patterns.ElementPattern;
import com.intellij.pom.references.PomReferenceProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.resolve.reference.ProviderBinding;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ConcurrentHashMap;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NamedObjectProviderBinding<PsiReferenceProvider>
implements ProviderBinding<PsiReferenceProvider> {
    private final ConcurrentMap<String, CopyOnWriteArrayList<Trinity<PsiReferenceProvider, ElementPattern, Double>>> myNamesToProvidersMap = new ConcurrentHashMap(5);
    private final ConcurrentMap<String, CopyOnWriteArrayList<Trinity<PsiReferenceProvider, ElementPattern, Double>>> myNamesToProvidersMapInsensitive = new ConcurrentHashMap(5);

    public void registerProvider(@NonNls String[] names, ElementPattern filter, boolean caseSensitive, PsiReferenceProvider provider, double priority) {
        ConcurrentMap<String, CopyOnWriteArrayList<Trinity<PsiReferenceProvider, ElementPattern, Double>>> map = caseSensitive ? this.myNamesToProvidersMap : this.myNamesToProvidersMapInsensitive;
        for (String attributeName : names) {
            CopyOnWriteArrayList psiReferenceProviders = (CopyOnWriteArrayList)map.get(attributeName);
            if (psiReferenceProviders == null) {
                psiReferenceProviders = (CopyOnWriteArrayList)ConcurrencyUtil.cacheOrGet(map, (Object)(caseSensitive ? attributeName : attributeName.toLowerCase()), (Object)ContainerUtil.createEmptyCOWList());
            }
            psiReferenceProviders.add(new Trinity(provider, (Object)filter, (Object)priority));
        }
    }

    @Override
    public void addAcceptableReferenceProviders(@NotNull PsiElement position, @NotNull List<Trinity<PsiReferenceProvider, ProcessingContext, Double>> list, Integer offset) {
        if (position == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/NamedObjectProviderBinding.addAcceptableReferenceProviders must not be null");
        }
        if (list == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/NamedObjectProviderBinding.addAcceptableReferenceProviders must not be null");
        }
        String name = this.getName(position);
        if (name != null) {
            NamedObjectProviderBinding.addMatchingProviders(position, (List)this.myNamesToProvidersMap.get(name), list, offset);
            NamedObjectProviderBinding.addMatchingProviders(position, (List)this.myNamesToProvidersMapInsensitive.get(name.toLowerCase()), list, offset);
        }
    }

    @Override
    public void unregisterProvider(PsiReferenceProvider provider) {
        for (CopyOnWriteArrayList list : this.myNamesToProvidersMap.values()) {
            for (Trinity trinity : new ArrayList(list)) {
                if (!trinity.first.equals(provider)) continue;
                list.remove(trinity);
            }
        }
        for (CopyOnWriteArrayList list : this.myNamesToProvidersMapInsensitive.values()) {
            for (Trinity trinity : new ArrayList(list)) {
                if (!trinity.first.equals(provider)) continue;
                list.remove(trinity);
            }
        }
    }

    @Nullable
    protected abstract String getName(PsiElement var1);

    private static <PsiReferenceProvider> void addMatchingProviders(PsiElement position, @Nullable List<Trinity<PsiReferenceProvider, ElementPattern, Double>> providerList, List<Trinity<PsiReferenceProvider, ProcessingContext, Double>> ret, Integer offset) {
        if (providerList == null) {
            return;
        }
        for (Trinity<PsiReferenceProvider, ElementPattern, Double> trinity : providerList) {
            ProcessingContext context = new ProcessingContext();
            if (offset != null) {
                context.put(PomReferenceProvider.OFFSET_IN_ELEMENT, (Object)offset);
            }
            boolean suitable = false;
            try {
                suitable = ((ElementPattern)trinity.second).accepts((Object)position, context);
            }
            catch (IndexNotReadyException ignored) {
                // empty catch block
            }
            if (!suitable) continue;
            ret.add(Trinity.create((Object)trinity.first, (Object)context, (Object)trinity.third));
        }
    }
}

