/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportHolder;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.source.PsiJavaCodeReferenceElementImpl;
import com.intellij.psi.impl.source.SourceJavaCodeReference;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.ImportHelper;
import com.intellij.psi.impl.source.jsp.jspJava.JspClass;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReferenceAdjuster {
    private final boolean myUseFqClassnamesInJavadoc;
    private final boolean myUseFqClassNames;

    public ReferenceAdjuster(boolean useFqInJavadoc, boolean useFqInCode) {
        this.myUseFqClassnamesInJavadoc = useFqInJavadoc;
        this.myUseFqClassNames = useFqInCode;
    }

    public ReferenceAdjuster(Project project) {
        this(CodeStyleSettingsManager.getSettings((Project)project));
    }

    public ReferenceAdjuster(CodeStyleSettings settings) {
        this(settings.USE_FQ_CLASS_NAMES_IN_JAVADOC, settings.USE_FQ_CLASS_NAMES);
    }

    public TreeElement process(TreeElement element, boolean addImports, boolean uncompleteCode) {
        IElementType elementType = element.getElementType();
        if (!(elementType != JavaElementType.JAVA_CODE_REFERENCE && elementType != JavaElementType.REFERENCE_EXPRESSION || elementType != JavaElementType.JAVA_CODE_REFERENCE && element.getTreeParent().getElementType() != JavaElementType.REFERENCE_EXPRESSION && !uncompleteCode)) {
            PsiJavaCodeReferenceElement ref = (PsiJavaCodeReferenceElement)SourceTreeToPsiMap.treeElementToPsi(element);
            PsiReferenceParameterList parameterList = ref.getParameterList();
            if (parameterList != null) {
                PsiTypeElement[] typeParameters;
                for (PsiTypeElement typeParameter : typeParameters = parameterList.getTypeParameterElements()) {
                    this.process((TreeElement)SourceTreeToPsiMap.psiElementToTree((PsiElement)typeParameter), addImports, uncompleteCode);
                }
            }
            boolean rightKind = true;
            if (elementType == JavaElementType.JAVA_CODE_REFERENCE) {
                int kind = ((PsiJavaCodeReferenceElementImpl)element).getKind();
                boolean bl = rightKind = kind == 1 || kind == 3;
            }
            if (rightKind) {
                PsiElement refElement;
                boolean isShort;
                boolean isInsideDocComment = TreeUtil.findParent(element, (IElementType)JavaDocElementType.DOC_COMMENT) != null;
                boolean bl = isShort = !((SourceJavaCodeReference)((Object)element)).isQualified();
                if (!this.makeFQ(isInsideDocComment) && isShort) {
                    return element;
                }
                if (!uncompleteCode) {
                    refElement = ref.resolve();
                } else {
                    PsiResolveHelper helper = JavaPsiFacade.getInstance((Project)element.getManager().getProject()).getResolveHelper();
                    refElement = helper.resolveReferencedClass(((SourceJavaCodeReference)((Object)element)).getClassNameText(), SourceTreeToPsiMap.treeElementToPsi(element));
                }
                if (refElement instanceof PsiClass) {
                    if (this.makeFQ(isInsideDocComment)) {
                        String thisPackageName;
                        String qName = ((PsiClass)refElement).getQualifiedName();
                        if (qName == null) {
                            return element;
                        }
                        PsiImportHolder file = (PsiImportHolder)SourceTreeToPsiMap.treeElementToPsi(element).getContainingFile();
                        if (file instanceof PsiJavaFile && ImportHelper.isImplicitlyImported(qName, (PsiJavaFile)file)) {
                            if (isShort) {
                                return element;
                            }
                            return (TreeElement)ReferenceAdjuster.makeShortReference((CompositeElement)element, (PsiClass)refElement, addImports);
                        }
                        if (file instanceof PsiJavaFile && ImportHelper.hasPackage(qName, thisPackageName = ((PsiJavaFile)file).getPackageName()) && !isShort) {
                            return (TreeElement)ReferenceAdjuster.makeShortReference((CompositeElement)element, (PsiClass)refElement, addImports);
                        }
                        return (TreeElement)ReferenceAdjuster.replaceReferenceWithFQ(element, (PsiClass)refElement);
                    }
                    return (TreeElement)ReferenceAdjuster.makeShortReference((CompositeElement)element, (PsiClass)refElement, addImports);
                }
            }
        }
        for (TreeElement child = element.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            child = this.process(child, addImports, uncompleteCode);
        }
        return element;
    }

    private boolean makeFQ(boolean isInsideDocComment) {
        if (isInsideDocComment) {
            return this.myUseFqClassnamesInJavadoc;
        }
        return this.myUseFqClassNames;
    }

    public void processRange(TreeElement element, int startOffset, int endOffset) {
        ArrayList<ASTNode> array = new ArrayList<ASTNode>();
        ReferenceAdjuster.addReferencesInRange(array, element, startOffset, endOffset);
        for (ASTNode ref : array) {
            if (!SourceTreeToPsiMap.treeElementToPsi(ref).isValid()) continue;
            this.process((TreeElement)ref, true, true);
        }
    }

    private static void addReferencesInRange(ArrayList<ASTNode> array, TreeElement parent, int startOffset, int endOffset) {
        if (parent.getElementType() == JavaElementType.JAVA_CODE_REFERENCE || parent.getElementType() == JavaElementType.REFERENCE_EXPRESSION) {
            array.add(parent);
            return;
        }
        if (parent.getPsi() instanceof PsiFile && JspPsiUtil.isInJspFile((PsiElement)parent.getPsi())) {
            JspFile jspFile = JspPsiUtil.getJspFile((PsiElement)parent.getPsi());
            JspClass jspClass = (JspClass)jspFile.getJavaClass();
            ReferenceAdjuster.addReferencesInRange(array, (TreeElement)jspClass.getNode(), startOffset, endOffset);
            return;
        }
        ReferenceAdjuster.addReferencesInRangeForComposite(array, parent, startOffset, endOffset);
    }

    private static void addReferencesInRangeForComposite(ArrayList<ASTNode> array, TreeElement parent, int startOffset, int endOffset) {
        int offset = 0;
        for (TreeElement child = parent.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            int length = child.getTextLength();
            if (startOffset <= offset + length && offset <= endOffset) {
                IElementType type = child.getElementType();
                if (type == JavaElementType.JAVA_CODE_REFERENCE || type == JavaElementType.REFERENCE_EXPRESSION) {
                    array.add(child);
                } else {
                    ReferenceAdjuster.addReferencesInRangeForComposite(array, child, startOffset - offset, endOffset - offset);
                }
            }
            offset += length;
        }
    }

    private static ASTNode makeShortReference(@NotNull CompositeElement reference, @NotNull PsiClass refClass, boolean addImports) {
        if (reference == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/ReferenceAdjuster.makeShortReference must not be null");
        }
        if (refClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/ReferenceAdjuster.makeShortReference must not be null");
        }
        PsiJavaCodeReferenceElement psiReference = (PsiJavaCodeReferenceElement)reference.getPsi();
        PsiQualifiedReference reference1 = ReferenceAdjuster.getClassReferenceToShorten(refClass, addImports, (PsiQualifiedReference)psiReference);
        if (reference1 != null) {
            ReferenceAdjuster.replaceReferenceWithShort(reference1);
        }
        return reference;
    }

    @Nullable
    public static PsiQualifiedReference getClassReferenceToShorten(@NotNull PsiClass refClass, boolean addImports, @NotNull PsiQualifiedReference reference) {
        if (refClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/ReferenceAdjuster.getClassReferenceToShorten must not be null");
        }
        if (reference == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/ReferenceAdjuster.getClassReferenceToShorten must not be null");
        }
        PsiClass parentClass = refClass.getContainingClass();
        if (parentClass != null) {
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)parentClass.getProject());
            PsiResolveHelper resolveHelper = facade.getResolveHelper();
            if (resolveHelper.isAccessible((PsiMember)refClass, (PsiElement)reference, null) && ReferenceAdjuster.isSafeToShortenReference(reference.getReferenceName(), (PsiElement)reference, refClass)) {
                return reference;
            }
            if (!CodeStyleSettingsManager.getSettings((Project)reference.getProject()).INSERT_INNER_CLASS_IMPORTS) {
                PsiElement qualifier = reference.getQualifier();
                if (qualifier instanceof PsiQualifiedReference) {
                    return ReferenceAdjuster.getClassReferenceToShorten(parentClass, addImports, (PsiQualifiedReference)qualifier);
                }
                return null;
            }
        }
        if (addImports && !((PsiImportHolder)reference.getContainingFile()).importClass(refClass)) {
            return null;
        }
        if (!ReferenceAdjuster.isSafeToShortenReference((PsiElement)reference, refClass)) {
            return null;
        }
        return reference;
    }

    private static boolean isSafeToShortenReference(@NotNull PsiElement psiReference, @NotNull PsiClass refClass) {
        if (psiReference == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/ReferenceAdjuster.isSafeToShortenReference must not be null");
        }
        if (refClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/ReferenceAdjuster.isSafeToShortenReference must not be null");
        }
        return ReferenceAdjuster.isSafeToShortenReference(refClass.getName(), psiReference, refClass);
    }

    private static boolean isSafeToShortenReference(String referenceText, PsiElement psiReference, PsiClass refClass) {
        PsiManager manager = refClass.getManager();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)manager.getProject());
        return manager.areElementsEquivalent((PsiElement)refClass, (PsiElement)facade.getResolveHelper().resolveReferencedClass(referenceText, psiReference));
    }

    @NotNull
    private static ASTNode replaceReferenceWithShort(PsiQualifiedReference reference) {
        ASTNode node = reference.getNode();
        assert (node != null);
        ReferenceAdjuster.dequalifyImpl((CompositeElement)node);
        ASTNode aSTNode = node;
        if (aSTNode == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/codeStyle/ReferenceAdjuster.replaceReferenceWithShort must not return null");
        }
        return aSTNode;
    }

    private static void dequalifyImpl(@NotNull CompositeElement reference) {
        if (reference == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/ReferenceAdjuster.dequalifyImpl must not be null");
        }
        ASTNode qualifier = reference.findChildByRole(54);
        if (qualifier != null) {
            reference.deleteChildInternal(qualifier);
        }
    }

    private static ASTNode replaceReferenceWithFQ(ASTNode reference, PsiClass refClass) {
        ((SourceJavaCodeReference)reference).fullyQualify(refClass);
        return reference;
    }
}

