/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.formatting.Block;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.formatter.DocumentBasedFormattingModel;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.FormattingDocumentModelImpl;
import com.intellij.psi.formatter.PsiBasedFormattingModel;
import com.intellij.psi.impl.source.codeStyle.ShiftIndentInsideHelper;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlElementType;
import org.jetbrains.annotations.NotNull;

public class PsiBasedFormatterModelWithShiftIndentInside
extends PsiBasedFormattingModel {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.codeStyle.PsiBasedFormatterModelWithShiftIndentInside");
    private final Project myProject;

    public PsiBasedFormatterModelWithShiftIndentInside(PsiFile file, @NotNull Block rootBlock, FormattingDocumentModelImpl documentModel) {
        if (rootBlock == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/PsiBasedFormatterModelWithShiftIndentInside.<init> must not be null");
        }
        super(file, rootBlock, documentModel);
        this.myProject = file.getProject();
    }

    @Override
    public TextRange shiftIndentInsideRange(TextRange textRange, int shift) {
        return this.shiftIndentInsideWithPsi(textRange, shift);
    }

    @Override
    public void commitChanges() {
    }

    private TextRange shiftIndentInsideWithPsi(TextRange textRange, int shift) {
        ASTNode leafElement;
        int offset = textRange.getStartOffset();
        for (leafElement = this.findElementAt(offset); leafElement != null && !leafElement.getTextRange().equals((Object)textRange); leafElement = leafElement.getTreeParent()) {
        }
        if (leafElement != null && leafElement.getTextRange().equals((Object)textRange) && ShiftIndentInsideHelper.mayShiftIndentInside(leafElement)) {
            return new ShiftIndentInsideHelper((FileType)StdFileTypes.JAVA, this.myProject).shiftIndentInside(leafElement, shift).getTextRange();
        }
        return textRange;
    }

    @Override
    protected String replaceWithPsiInLeaf(TextRange textRange, String whiteSpace, ASTNode leafElement) {
        if (!this.myCanModifyAllWhiteSpaces) {
            if (leafElement.getElementType() == TokenType.WHITE_SPACE) {
                return null;
            }
            ASTNode prevNode = TreeUtil.prevLeaf(leafElement);
            if (prevNode != null) {
                IElementType type = prevNode.getElementType();
                if (type == TokenType.WHITE_SPACE) {
                    String text = prevNode.getText();
                    String cdataStartMarker = "<![CDATA[";
                    int cdataPos = text.indexOf("<![CDATA[");
                    if (cdataPos != -1 && whiteSpace.indexOf("<![CDATA[") == -1 && (whiteSpace = DocumentBasedFormattingModel.mergeWsWithCdataMarker(whiteSpace, text, cdataPos)) == null) {
                        return null;
                    }
                    type = (prevNode = TreeUtil.prevLeaf(prevNode)) != null ? prevNode.getElementType() : null;
                }
                String cdataEndMarker = "]]>";
                if (type == XmlElementType.XML_CDATA_END && whiteSpace.indexOf("]]>") == -1) {
                    ASTNode at = this.findElementAt(prevNode.getStartOffset());
                    if (at != null && at.getPsi() instanceof PsiWhiteSpace) {
                        String s = at.getText();
                        int cdataEndPos = s.indexOf("]]>");
                        whiteSpace = DocumentBasedFormattingModel.mergeWsWithCdataMarker(whiteSpace, s, cdataEndPos);
                        leafElement = at;
                    } else {
                        whiteSpace = null;
                    }
                    if (whiteSpace == null) {
                        return null;
                    }
                }
            }
        }
        FormatterUtil.replaceWhiteSpace(whiteSpace, leafElement, TokenType.WHITE_SPACE, textRange);
        return whiteSpace;
    }
}

