/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.smartPointers.SmartPointerEx;
import com.intellij.util.ReflectionCache;
import org.jetbrains.annotations.NotNull;

public class LazyPointerImpl<E extends PsiElement>
implements SmartPointerEx<E> {
    private E myElement = null;
    private PsiAnchor myAnchor = null;
    private SmartPsiElementPointer myPointer = null;
    private final Class<? extends PsiElement> myElementClass;
    private final Project myProject;

    public LazyPointerImpl(E element) {
        this.myElementClass = element.getClass();
        if (element instanceof PsiCompiledElement) {
            this.myElement = element;
        } else {
            this.myAnchor = PsiAnchor.create(element);
        }
        this.myProject = element.getProject();
    }

    private static SmartPsiElementPointer setupPointer(PsiElement element) {
        return SmartPointerManager.getInstance((Project)element.getProject()).createSmartPsiElementPointer(element);
    }

    @Override
    public void fastenBelt() {
        if (this.myAnchor != null) {
            PsiElement element = this.myAnchor.retrieve();
            if (element != null) {
                this.myPointer = LazyPointerImpl.setupPointer(element);
                ((SmartPointerEx)this.myPointer).fastenBelt();
                this.myAnchor = null;
            } else {
                this.myAnchor = null;
            }
        }
    }

    @Override
    public void documentAndPsiInSync() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LazyPointerImpl)) {
            return false;
        }
        LazyPointerImpl that = (LazyPointerImpl)o;
        if (this.myAnchor != null ? !this.myAnchor.equals(that.myAnchor) : that.myAnchor != null) {
            return false;
        }
        if (this.myElement != null ? !this.myElement.equals(that.myElement) : that.myElement != null) {
            return false;
        }
        if (this.myElementClass != null ? !this.myElementClass.equals(that.myElementClass) : that.myElementClass != null) {
            return false;
        }
        return !(this.myPointer != null ? !this.myPointer.equals(that.myPointer) : that.myPointer != null);
    }

    public int hashCode() {
        int result = this.myElement != null ? this.myElement.hashCode() : 0;
        result = 31 * result + (this.myAnchor != null ? this.myAnchor.hashCode() : 0);
        result = 31 * result + (this.myPointer != null ? this.myPointer.hashCode() : 0);
        result = 31 * result + (this.myElementClass != null ? this.myElementClass.hashCode() : 0);
        return result;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/smartPointers/LazyPointerImpl.getProject must not return null");
        }
        return project;
    }

    public E getElement() {
        PsiElement psiElement;
        if (this.myElement != null) {
            return this.myElement.isValid() ? (E)this.myElement : null;
        }
        if (this.myPointer != null) {
            return (E)this.myPointer.getElement();
        }
        if (this.myAnchor != null && (psiElement = this.myAnchor.retrieve()) != null) {
            return (E)(ReflectionCache.isAssignable(this.myElementClass, psiElement.getClass()) ? psiElement : null);
        }
        return null;
    }

    public PsiFile getContainingFile() {
        if (this.myElement != null) {
            return this.myElement.getContainingFile();
        }
        if (this.myAnchor != null) {
            return this.myAnchor.getFile();
        }
        return null;
    }
}

