/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.controlFlow;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.ControlFlowPolicy;
import com.intellij.psi.controlFlow.ControlFlowUtil;

public class LocalsControlFlowPolicy
implements ControlFlowPolicy {
    private final PsiElement myCodeFragment;

    public LocalsControlFlowPolicy(PsiElement codeFragment) {
        this.myCodeFragment = codeFragment;
    }

    @Override
    public PsiVariable getUsedVariable(PsiReferenceExpression refExpr) {
        if (refExpr.isQualified()) {
            return null;
        }
        PsiElement refElement = refExpr.resolve();
        if (refElement instanceof PsiLocalVariable || refElement instanceof PsiParameter) {
            return this.checkCodeFragment(refElement);
        }
        return null;
    }

    private PsiVariable checkCodeFragment(PsiElement refElement) {
        Object codeFragement = refElement instanceof PsiParameter && ((PsiParameter)refElement).getDeclarationScope() instanceof PsiMethod ? ((PsiMethod)((PsiParameter)refElement).getDeclarationScope()).getBody() : ControlFlowUtil.findCodeFragment(refElement);
        if (this.myCodeFragment.getContainingFile() == codeFragement.getContainingFile() && !this.myCodeFragment.equals(codeFragement)) {
            return null;
        }
        return (PsiVariable)refElement;
    }

    @Override
    public boolean isParameterAccepted(PsiParameter psiParameter) {
        return this.checkCodeFragment((PsiElement)psiParameter) != null;
    }

    @Override
    public boolean isLocalVariableAccepted(PsiLocalVariable psiVariable) {
        return this.checkCodeFragment((PsiElement)psiVariable) != null;
    }
}

