/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.compiler;

import com.intellij.compiler.impl.packagingCompiler.DestinationInfo;
import com.intellij.openapi.compiler.ValidityState;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.StringSetSpinAllocator;
import com.intellij.util.io.IOUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class ArtifactPackagingItemValidityState
implements ValidityState {
    private final SmartList<Pair<String, Long>> myDestinations;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArtifactPackagingItemValidityState(List<DestinationInfo> destinationInfos, boolean sourceFileModified, @Nullable ArtifactPackagingItemValidityState oldState) {
        this.myDestinations = new SmartList();
        Set paths = StringSetSpinAllocator.alloc();
        try {
            for (DestinationInfo info : destinationInfos) {
                VirtualFile outputFile = info.getOutputFile();
                long timestamp = outputFile != null ? outputFile.getTimeStamp() : -1L;
                String path = info.getOutputPath();
                this.myDestinations.add((Object)Pair.create((Object)path, (Object)timestamp));
                paths.add(path);
            }
            if (!sourceFileModified && oldState != null) {
                for (Pair pair : oldState.myDestinations) {
                    if (paths.contains(pair.getFirst())) continue;
                    this.myDestinations.add((Object)pair);
                }
            }
        }
        finally {
            StringSetSpinAllocator.dispose((Set)paths);
        }
    }

    public ArtifactPackagingItemValidityState(DataInput input) throws IOException {
        int size = input.readInt();
        this.myDestinations = new SmartList();
        while (size-- > 0) {
            String path = IOUtil.readString((DataInput)input);
            long timestamp = input.readLong();
            this.myDestinations.add((Object)Pair.create((Object)path, (Object)timestamp));
        }
    }

    public boolean equalsTo(ValidityState otherState) {
        if (!(otherState instanceof ArtifactPackagingItemValidityState)) {
            return false;
        }
        SmartList<Pair<String, Long>> otherDestinations = ((ArtifactPackagingItemValidityState)otherState).myDestinations;
        if (otherDestinations.size() != this.myDestinations.size()) {
            return false;
        }
        if (this.myDestinations.size() == 1) {
            return ((Pair)this.myDestinations.get(0)).equals(otherDestinations.get(0));
        }
        return Comparing.haveEqualElements(this.myDestinations, otherDestinations);
    }

    public void save(DataOutput output) throws IOException {
        output.writeInt(this.myDestinations.size());
        for (Pair pair : this.myDestinations) {
            IOUtil.writeString((String)((String)pair.getFirst()), (DataOutput)output);
            output.writeLong((Long)pair.getSecond());
        }
    }
}

