/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies.ui;

import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.ide.scopeView.nodes.BasePsiNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.ui.DependenciesPanel;
import com.intellij.packageDependencies.ui.DependencyNodeComparator;
import com.intellij.packageDependencies.ui.DirectoryNode;
import com.intellij.packageDependencies.ui.FileNode;
import com.intellij.packageDependencies.ui.Marker;
import com.intellij.packageDependencies.ui.ModuleGroupNode;
import com.intellij.packageDependencies.ui.ModuleNode;
import com.intellij.packageDependencies.ui.PackageDependenciesNode;
import com.intellij.packageDependencies.ui.RootNode;
import com.intellij.packageDependencies.ui.TreeModel;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.HashSet;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileTreeModelBuilder {
    private static final Key<Integer> FILE_COUNT = Key.create((String)"FILE_COUNT");
    private final ProjectFileIndex myFileIndex;
    private final PsiManager myPsiManager;
    private final Project myProject;
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.packageDependencies.ui.TreeModelBuilder");
    private final boolean myShowModuleGroups;
    private final boolean myShowModules;
    private final boolean myFlattenPackages;
    private final boolean myCompactEmptyMiddlePackages;
    private boolean myShowFiles;
    private final Marker myMarker;
    private final boolean myAddUnmarkedFiles;
    private final PackageDependenciesNode myRoot;
    private final Map<PsiDirectory, DirectoryNode> myModuleDirNodes = new HashMap<PsiDirectory, DirectoryNode>();
    private final Map<Module, ModuleNode> myModuleNodes = new HashMap<Module, ModuleNode>();
    private final Map<String, ModuleGroupNode> myModuleGroupNodes = new HashMap<String, ModuleGroupNode>();
    private int myScannedFileCount = 0;
    private int myTotalFileCount = 0;
    private int myMarkedFileCount = 0;

    public FileTreeModelBuilder(Project project, Marker marker, DependenciesPanel.DependencyPanelSettings settings) {
        this.myProject = project;
        this.myShowModules = settings.UI_SHOW_MODULES;
        this.myFlattenPackages = settings.UI_FLATTEN_PACKAGES;
        this.myCompactEmptyMiddlePackages = settings.UI_COMPACT_EMPTY_MIDDLE_PACKAGES;
        this.myShowFiles = settings.UI_SHOW_FILES;
        this.myShowModuleGroups = settings.UI_SHOW_MODULE_GROUPS;
        this.myMarker = marker;
        this.myAddUnmarkedFiles = !settings.UI_FILTER_LEGALS;
        this.myRoot = new RootNode();
        this.myFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        this.myPsiManager = PsiManager.getInstance((Project)project);
    }

    public static synchronized TreeModel createTreeModel(Project project, boolean showProgress, Set<PsiFile> files, Marker marker, DependenciesPanel.DependencyPanelSettings settings) {
        return new FileTreeModelBuilder(project, marker, settings).build(files, showProgress);
    }

    public static synchronized TreeModel createTreeModel(Project project, Marker marker, DependenciesPanel.DependencyPanelSettings settings) {
        return new FileTreeModelBuilder(project, marker, settings).build(project, false);
    }

    public static synchronized TreeModel createTreeModel(Project project, boolean showProgress, Marker marker) {
        return new FileTreeModelBuilder(project, marker, new DependenciesPanel.DependencyPanelSettings()).build(project, showProgress);
    }

    private void countFiles(Project project) {
        Integer fileCount = (Integer)project.getUserData(FILE_COUNT);
        if (fileCount == null) {
            this.myFileIndex.iterateContent(new ContentIterator(){

                public boolean processFile(VirtualFile fileOrDir) {
                    if (!fileOrDir.isDirectory()) {
                        FileTreeModelBuilder.this.counting(fileOrDir);
                    }
                    return true;
                }
            });
            project.putUserData(FILE_COUNT, (Object)this.myTotalFileCount);
        } else {
            this.myTotalFileCount = fileCount;
        }
    }

    public static void clearCaches(Project project) {
        project.putUserData(FILE_COUNT, null);
    }

    public TreeModel build(Project project, boolean showProgress) {
        return this.build(project, showProgress, false);
    }

    public TreeModel build(final Project project, boolean showProgress, boolean sortByType) {
        Runnable buildingRunnable = new Runnable(){

            @Override
            public void run() {
                FileTreeModelBuilder.this.countFiles(project);
                final PsiManager psiManager = PsiManager.getInstance((Project)project);
                FileTreeModelBuilder.this.myFileIndex.iterateContent(new ContentIterator(){

                    public boolean processFile(VirtualFile fileOrDir) {
                        PsiFile psiFile;
                        if (!fileOrDir.isDirectory() && (psiFile = psiManager.findFile(fileOrDir)) != null) {
                            FileTreeModelBuilder.this.buildFileNode(psiFile);
                        }
                        return true;
                    }
                });
            }
        };
        if (showProgress) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(buildingRunnable, AnalysisScopeBundle.message((String)"package.dependencies.build.process.title", (Object[])new Object[0]), true, project);
        } else {
            buildingRunnable.run();
        }
        TreeUtil.sort((DefaultMutableTreeNode)this.myRoot, (Comparator)new DependencyNodeComparator(sortByType));
        return new TreeModel(this.myRoot, this.myTotalFileCount, this.myMarkedFileCount);
    }

    private void counting(VirtualFile file) {
        ++this.myTotalFileCount;
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            indicator.setText(AnalysisScopeBundle.message((String)"package.dependencies.build.progress.text", (Object[])new Object[0]));
            indicator.setIndeterminate(true);
            indicator.setText2(file.getPresentableUrl());
        }
    }

    private TreeModel build(final Set<PsiFile> files, boolean showProgress) {
        if (files.size() == 1) {
            this.myShowFiles = true;
        }
        Runnable buildingRunnable = new Runnable(){

            @Override
            public void run() {
                for (PsiFile file : files) {
                    if (file == null) continue;
                    FileTreeModelBuilder.this.buildFileNode(file);
                }
            }
        };
        if (showProgress) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(buildingRunnable, AnalysisScopeBundle.message((String)"package.dependencies.build.process.title", (Object[])new Object[0]), false, this.myProject);
        } else {
            buildingRunnable.run();
        }
        TreeUtil.sort((DefaultMutableTreeNode)this.myRoot, (Comparator)new DependencyNodeComparator());
        return new TreeModel(this.myRoot, this.myTotalFileCount, this.myMarkedFileCount);
    }

    private void buildFileNode(PsiFile file) {
        boolean isMarked;
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            indicator.setIndeterminate(false);
            indicator.setText(AnalysisScopeBundle.message((String)"package.dependencies.build.progress.text", (Object[])new Object[0]));
            VirtualFile virtualFile = file.getVirtualFile();
            if (virtualFile != null) {
                indicator.setText2(virtualFile.getPresentableUrl());
            }
            indicator.setFraction((double)this.myScannedFileCount++ / (double)this.myTotalFileCount);
        }
        if (file == null || !file.isValid()) {
            return;
        }
        boolean bl = isMarked = this.myMarker != null && this.myMarker.isMarked(file);
        if (isMarked) {
            ++this.myMarkedFileCount;
        }
        if (isMarked || this.myAddUnmarkedFiles) {
            PackageDependenciesNode dirNode = this.getFileParentNode(file);
            if (this.myShowFiles) {
                FileNode fileNode = new FileNode(file, isMarked);
                dirNode.add(fileNode);
            } else {
                dirNode.addFile(file, isMarked);
            }
        }
    }

    @NotNull
    public PackageDependenciesNode getFileParentNode(PsiFile file) {
        VirtualFile vFile = file.getVirtualFile();
        LOG.assertTrue(vFile != null);
        VirtualFile containingDirectory = vFile.getParent();
        LOG.assertTrue(containingDirectory != null, (Object)("physical: " + file.isPhysical() + ", " + file.getViewProvider().isPhysical()));
        PackageDependenciesNode packageDependenciesNode = this.getModuleDirNode(file.getContainingDirectory(), this.myFileIndex.getModuleForFile(vFile), null);
        if (packageDependenciesNode == null) {
            throw new IllegalStateException("@NotNull method com/intellij/packageDependencies/ui/FileTreeModelBuilder.getFileParentNode must not return null");
        }
        return packageDependenciesNode;
    }

    @Nullable
    public DefaultMutableTreeNode removeNode(PsiElement element, PsiDirectory parent) {
        TreeNode treeNode;
        Module module = this.myFileIndex.getModuleForFile(parent.getVirtualFile());
        if (element instanceof PsiDirectory && this.myFlattenPackages) {
            PackageDependenciesNode moduleNode = this.getModuleNode(module);
            PsiDirectory psiDirectory = (PsiDirectory)element;
            VirtualFile virtualFile = psiDirectory.getVirtualFile();
            PackageDependenciesNode dirNode = this.getModuleDirNode(psiDirectory, this.myFileIndex.getModuleForFile(virtualFile), null);
            dirNode.removeFromParent();
            return moduleNode;
        }
        PackageDependenciesNode dirNode = this.getModuleDirNode(parent, module, null);
        if (dirNode == null) {
            return null;
        }
        PackageDependenciesNode[] classOrDirNodes = FileTreeModelBuilder.findNodeForPsiElement(dirNode, element);
        if (classOrDirNodes != null) {
            for (PackageDependenciesNode classNode : classOrDirNodes) {
                classNode.removeFromParent();
            }
        }
        DefaultMutableTreeNode node = dirNode;
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)node.getParent();
        while (node != null && node.getChildCount() == 0) {
            PsiDirectory directory = parent.getParentDirectory();
            parentNode = (DefaultMutableTreeNode)node.getParent();
            node.removeFromParent();
            if (node instanceof DirectoryNode) {
                while (node != null) {
                    this.myModuleDirNodes.put((PsiDirectory)((DirectoryNode)node).getPsiElement(), null);
                    node = ((DirectoryNode)node).getCompactedDirNode();
                }
            } else if (parentNode instanceof ModuleNode) {
                this.myModuleNodes.put(((ModuleNode)parentNode).getModule(), null);
            } else if (parentNode instanceof ModuleGroupNode) {
                this.myModuleGroupNodes.put(((ModuleGroupNode)parentNode).getModuleGroupName(), null);
            }
            node = parentNode;
            parent = directory;
        }
        if (this.myCompactEmptyMiddlePackages && node instanceof DirectoryNode && node.getChildCount() == 1 && (treeNode = node.getChildAt(0)) instanceof DirectoryNode) {
            node.removeAllChildren();
            for (int i = treeNode.getChildCount() - 1; i >= 0; --i) {
                node.add((MutableTreeNode)treeNode.getChildAt(i));
            }
            ((DirectoryNode)node).setCompactedDirNode((DirectoryNode)treeNode);
        }
        return parentNode;
    }

    @Nullable
    public PackageDependenciesNode addFileNode(PsiFile file) {
        PsiDirectory dirToReload;
        boolean isMarked;
        boolean bl = isMarked = this.myMarker != null && this.myMarker.isMarked(file);
        if (!isMarked) {
            return null;
        }
        VirtualFile vFile = file.getVirtualFile();
        LOG.assertTrue(vFile != null);
        PackageDependenciesNode rootToReload = this.myModuleDirNodes.get(dirToReload);
        if (rootToReload == null && this.myFlattenPackages) {
            Module module = this.myFileIndex.getModuleForFile(vFile);
            boolean moduleNodeExist = this.myModuleNodes.get(module) != null;
            rootToReload = this.getModuleNode(module);
            if (!moduleNodeExist) {
                rootToReload = null;
            }
        } else {
            for (dirToReload = file.getContainingDirectory(); rootToReload == null && dirToReload != null; dirToReload = dirToReload.getParentDirectory()) {
                rootToReload = this.myModuleDirNodes.get(dirToReload);
            }
        }
        PackageDependenciesNode dirNode = this.getFileParentNode(file);
        dirNode.add(new FileNode(file, isMarked));
        return rootToReload;
    }

    @Nullable
    public PackageDependenciesNode findNode(PsiFile file, PsiElement psiElement) {
        PackageDependenciesNode parent = this.getFileParentNode(file);
        PackageDependenciesNode[] nodes = FileTreeModelBuilder.findNodeForPsiElement(parent, (PsiElement)file);
        if (nodes == null || nodes.length == 0) {
            return null;
        }
        for (PackageDependenciesNode node : nodes) {
            if (node.getPsiElement() != psiElement) continue;
            return node;
        }
        return nodes[0];
    }

    @Nullable
    private static PackageDependenciesNode[] findNodeForPsiElement(PackageDependenciesNode parent, PsiElement element) {
        HashSet result = new HashSet();
        for (int i = 0; i < parent.getChildCount(); ++i) {
            TreeNode treeNode = parent.getChildAt(i);
            if (!(treeNode instanceof PackageDependenciesNode)) continue;
            PackageDependenciesNode node = (PackageDependenciesNode)treeNode;
            if (element instanceof PsiDirectory && node.getPsiElement() == element) {
                return new PackageDependenciesNode[]{node};
            }
            if (!(element instanceof PsiFile)) continue;
            PsiFile psiFile = null;
            if (node instanceof BasePsiNode) {
                psiFile = ((BasePsiNode)node).getContainingFile();
            } else if (node instanceof FileNode) {
                psiFile = (PsiFile)node.getPsiElement();
            }
            if (psiFile == null || psiFile.getVirtualFile() != ((PsiFile)element).getVirtualFile()) continue;
            result.add(node);
        }
        return result.isEmpty() ? null : result.toArray(new PackageDependenciesNode[result.size()]);
    }

    private PackageDependenciesNode getModuleDirNode(PsiDirectory psiDirectory, Module module, DirectoryNode childNode) {
        if (psiDirectory == null) {
            return this.getModuleNode(module);
        }
        PackageDependenciesNode directoryNode = this.myModuleDirNodes.get(psiDirectory);
        if (directoryNode != null) {
            if (this.myCompactEmptyMiddlePackages) {
                DirectoryNode parentWrapper;
                DirectoryNode nestedNode = ((DirectoryNode)directoryNode).getCompactedDirNode();
                if (nestedNode != null) {
                    DirectoryNode parentWrapper2 = nestedNode.getWrapper();
                    while (parentWrapper2.getWrapper() != null) {
                        parentWrapper2 = parentWrapper2.getWrapper();
                    }
                    for (int i = parentWrapper2.getChildCount() - 1; i >= 0; --i) {
                        nestedNode.add((MutableTreeNode)parentWrapper2.getChildAt(i));
                    }
                    ((DirectoryNode)directoryNode).setCompactedDirNode(null);
                    parentWrapper2.add(nestedNode);
                    nestedNode.removeUpReference();
                    return parentWrapper2;
                }
                if (directoryNode.getParent() == null && (parentWrapper = ((DirectoryNode)directoryNode).getWrapper()) != null) {
                    while (parentWrapper.getWrapper() != null) {
                        parentWrapper = parentWrapper.getWrapper();
                    }
                    return parentWrapper;
                }
            }
            return directoryNode;
        }
        VirtualFile virtualFile = psiDirectory.getVirtualFile();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        VirtualFile sourceRoot = fileIndex.getSourceRootForFile(virtualFile);
        VirtualFile contentRoot = fileIndex.getContentRootForFile(virtualFile);
        directoryNode = new DirectoryNode(psiDirectory, this.myCompactEmptyMiddlePackages, this.myFlattenPackages);
        this.myModuleDirNodes.put(psiDirectory, (DirectoryNode)directoryNode);
        PsiDirectory directory = psiDirectory.getParentDirectory();
        if (!this.myFlattenPackages && directory != null) {
            VirtualFile parentDir;
            if (this.myCompactEmptyMiddlePackages && sourceRoot != virtualFile && contentRoot != virtualFile) {
                ((DirectoryNode)directoryNode).setCompactedDirNode(childNode);
            }
            if (fileIndex.getModuleForFile(parentDir = directory.getVirtualFile()) == module) {
                DirectoryNode parentDirectoryNode = this.myModuleDirNodes.get(directory);
                if (parentDirectoryNode != null || !this.myCompactEmptyMiddlePackages || parentDir == sourceRoot || parentDir == contentRoot) {
                    this.getModuleDirNode(directory, module, (DirectoryNode)directoryNode).add(directoryNode);
                } else {
                    directoryNode = this.getModuleDirNode(directory, module, (DirectoryNode)directoryNode);
                }
            } else {
                this.getModuleNode(module).add(directoryNode);
            }
        } else if (contentRoot == virtualFile) {
            this.getModuleNode(module).add(directoryNode);
        } else {
            PsiDirectory root = sourceRoot != virtualFile && sourceRoot != null ? this.myPsiManager.findDirectory(sourceRoot) : (contentRoot != null ? this.myPsiManager.findDirectory(contentRoot) : null);
            if (root != null) {
                this.getModuleDirNode(root, module, null).add(directoryNode);
            }
        }
        return directoryNode;
    }

    @Nullable
    private PackageDependenciesNode getModuleNode(Module module) {
        if (module == null || !this.myShowModules) {
            return this.myRoot;
        }
        ModuleNode node = this.myModuleNodes.get(module);
        if (node != null) {
            return node;
        }
        node = new ModuleNode(module);
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        String[] groupPath = moduleManager.getModuleGroupPath(module);
        if (groupPath == null) {
            this.myModuleNodes.put(module, node);
            this.myRoot.add(node);
            return node;
        }
        this.myModuleNodes.put(module, node);
        if (this.myShowModuleGroups) {
            this.getParentModuleGroup(groupPath).add(node);
        } else {
            this.myRoot.add(node);
        }
        return node;
    }

    private PackageDependenciesNode getParentModuleGroup(String[] groupPath) {
        ModuleGroupNode groupNode = this.myModuleGroupNodes.get(groupPath[groupPath.length - 1]);
        if (groupNode == null) {
            groupNode = new ModuleGroupNode(new ModuleGroup(groupPath));
            this.myModuleGroupNodes.put(groupPath[groupPath.length - 1], groupNode);
            this.myRoot.add(groupNode);
        }
        if (groupPath.length > 1) {
            String[] path = new String[groupPath.length - 1];
            System.arraycopy(groupPath, 0, path, 0, groupPath.length - 1);
            PackageDependenciesNode node = this.getParentModuleGroup(path);
            node.add(groupNode);
        }
        return groupNode;
    }
}

