/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.vfs.VfsBundle;
import com.intellij.openapi.vfs.newvfs.RefreshProgress;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.RefreshSession;
import com.intellij.openapi.vfs.newvfs.RefreshSessionImpl;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.ConcurrencyUtil;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.Nullable;

public class RefreshQueueImpl
extends RefreshQueue {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vfs.newvfs.RefreshQueueImpl");
    private final ExecutorService myQueue = ConcurrencyUtil.newSingleThreadExecutor((String)"FS Synchronizer");
    private final ProgressIndicator myRefreshIndicator = new RefreshProgress(VfsBundle.message((String)"file.synchronize.progress", (Object[])new Object[0]));

    public void execute(RefreshSessionImpl session) {
        if (session.isAsynchronous()) {
            this.queueSession(session, ModalityState.NON_MODAL);
        } else {
            Application app = ApplicationManager.getApplication();
            boolean isEDT = app.isDispatchThread();
            boolean hasWriteAction = app.isWriteAccessAllowed();
            if (isEDT || hasWriteAction) {
                session.scan();
                session.fireEvents(hasWriteAction);
            } else {
                if (((ApplicationEx)app).holdsReadLock()) {
                    LOG.error("Do not call synchronous refresh from inside read action except for event dispatch thread. This will eventually cause deadlock if there are events to fire");
                    return;
                }
                this.queueSession(session, ModalityState.defaultModalityState());
                session.waitFor();
            }
        }
    }

    private void queueSession(final RefreshSessionImpl session, final ModalityState modality) {
        this.myQueue.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    RefreshQueueImpl.this.myRefreshIndicator.start();
                    try {
                        session.scan();
                    }
                    finally {
                        RefreshQueueImpl.this.myRefreshIndicator.stop();
                    }
                }
                catch (Throwable throwable) {
                    Application app = ApplicationManager.getApplication();
                    app.invokeLater((Runnable)new DumbAwareRunnable(app){
                        final /* synthetic */ Application val$app;
                        {
                            this.val$app = application;
                        }

                        public void run() {
                            if (this.val$app.isDisposed()) {
                                return;
                            }
                            session.fireEvents(false);
                        }
                    }, modality);
                    throw throwable;
                }
                Application app = ApplicationManager.getApplication();
                app.invokeLater((Runnable)new /* invalid duplicate definition of identical inner class */, modality);
            }
        });
    }

    public RefreshSession createSession(boolean async, boolean recursively, @Nullable Runnable finishRunnable) {
        return new RefreshSessionImpl(async, recursively, finishRunnable);
    }

    public void processSingleEvent(VFileEvent event) {
        new RefreshSessionImpl(Collections.singletonList(event)).launch();
    }
}

