/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot.daemon;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureDaemonAnalyzerListener;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElementUsage;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemsHolderImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectStructureDaemonAnalyzer
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.ui.configuration.projectRoot.validation.ProjectStructureDaemonAnalyzer");
    private Map<ProjectStructureElement, ProjectStructureProblemsHolderImpl> myProblemHolders = new HashMap<ProjectStructureElement, ProjectStructureProblemsHolderImpl>();
    private MultiValuesMap<ProjectStructureElement, ProjectStructureElementUsage> mySourceElement2Usages = new MultiValuesMap();
    private MultiValuesMap<ProjectStructureElement, ProjectStructureElementUsage> myContainingElement2Usages = new MultiValuesMap();
    private Set<ProjectStructureElement> myElementWithNotCalculatedUsages = new HashSet<ProjectStructureElement>();
    private MergingUpdateQueue myAnalyzerQueue;
    private final EventDispatcher<ProjectStructureDaemonAnalyzerListener> myDispatcher = EventDispatcher.create(ProjectStructureDaemonAnalyzerListener.class);
    private final AtomicBoolean myStopped = new AtomicBoolean(false);

    public ProjectStructureDaemonAnalyzer(StructureConfigurableContext context) {
        Disposer.register((Disposable)context, (Disposable)this);
        this.myAnalyzerQueue = new MergingUpdateQueue("Project Structure Daemon Analyzer", 300, false, null, (Disposable)this, null, false);
    }

    private void doUpdate(ProjectStructureElement element, boolean check, boolean collectUsages) {
        if (this.myStopped.get()) {
            return;
        }
        if (check) {
            this.doCheck(element);
        }
        if (collectUsages) {
            this.doCollectUsages(element);
        }
    }

    private void doCheck(final ProjectStructureElement element) {
        final ProjectStructureProblemsHolderImpl problemsHolder = new ProjectStructureProblemsHolderImpl();
        new ReadAction(){

            protected void run(Result result) {
                if (ProjectStructureDaemonAnalyzer.this.myStopped.get()) {
                    return;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("checking " + element);
                }
                element.check(problemsHolder);
            }
        }.execute();
        ProjectStructureDaemonAnalyzer.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ProjectStructureDaemonAnalyzer.this.myStopped.get()) {
                    return;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("updating problems for " + element);
                }
                ProjectStructureDaemonAnalyzer.this.myProblemHolders.put(element, problemsHolder);
                ((ProjectStructureDaemonAnalyzerListener)ProjectStructureDaemonAnalyzer.this.myDispatcher.getMulticaster()).problemsChanged(element);
            }
        });
    }

    private void doCollectUsages(final ProjectStructureElement element) {
        final List usages = (List)new ReadAction<List<ProjectStructureElementUsage>>(){

            protected void run(Result<List<ProjectStructureElementUsage>> result) {
                if (ProjectStructureDaemonAnalyzer.this.myStopped.get()) {
                    return;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("collecting usages in " + element);
                }
                result.setResult(element.getUsagesInElement());
            }
        }.execute().getResultObject();
        ProjectStructureDaemonAnalyzer.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ProjectStructureDaemonAnalyzer.this.myStopped.get()) {
                    return;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("updating usages for " + element);
                }
                ProjectStructureDaemonAnalyzer.this.updateUsages(element, usages);
                ((ProjectStructureDaemonAnalyzerListener)ProjectStructureDaemonAnalyzer.this.myDispatcher.getMulticaster()).usagesCollected(element);
            }
        });
    }

    private void updateUsages(ProjectStructureElement element, List<ProjectStructureElementUsage> usages) {
        this.removeUsagesInElement(element);
        for (ProjectStructureElementUsage usage : usages) {
            this.addUsage(usage);
        }
        this.myElementWithNotCalculatedUsages.remove(element);
    }

    private static void invokeLater(Runnable runnable) {
        SwingUtilities.invokeLater(runnable);
    }

    public void queueUpdate(@NotNull ProjectStructureElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/ProjectStructureDaemonAnalyzer.queueUpdate must not be null");
        }
        this.queueUpdate(element, true, true);
    }

    public void queueUpdate(@NotNull ProjectStructureElement element, boolean check, boolean collectUsages) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/ProjectStructureDaemonAnalyzer.queueUpdate must not be null");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("start " + (check ? "checking " : "") + (collectUsages ? "collecting usages " : "") + "for " + element);
        }
        if (collectUsages) {
            this.myElementWithNotCalculatedUsages.add(element);
        }
        this.myAnalyzerQueue.queue((Update)new AnalyzeElementUpdate(element, check, collectUsages));
    }

    public void removeElement(ProjectStructureElement element) {
        this.myElementWithNotCalculatedUsages.remove(element);
        this.myProblemHolders.remove(element);
        Collection usages = this.mySourceElement2Usages.removeAll((Object)element);
        if (usages != null) {
            for (ProjectStructureElementUsage usage : usages) {
                this.myProblemHolders.remove(usage.getContainingElement());
            }
        }
        this.removeUsagesInElement(element);
        ((ProjectStructureDaemonAnalyzerListener)this.myDispatcher.getMulticaster()).problemsChanged(element);
    }

    public boolean isUnused(ProjectStructureElement element) {
        if (!element.highlightIfUnused()) {
            return false;
        }
        if (!this.myElementWithNotCalculatedUsages.isEmpty()) {
            return false;
        }
        Collection usages = this.mySourceElement2Usages.get((Object)element);
        return usages == null || usages.isEmpty();
    }

    private void removeUsagesInElement(ProjectStructureElement element) {
        Collection usages = this.myContainingElement2Usages.removeAll((Object)element);
        if (usages != null) {
            for (ProjectStructureElementUsage usage : usages) {
                this.mySourceElement2Usages.remove((Object)usage.getSourceElement(), (Object)usage);
            }
        }
    }

    private void addUsage(@NotNull ProjectStructureElementUsage usage) {
        if (usage == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/ProjectStructureDaemonAnalyzer.addUsage must not be null");
        }
        this.mySourceElement2Usages.put((Object)usage.getSourceElement(), (Object)usage);
        this.myContainingElement2Usages.put((Object)usage.getContainingElement(), (Object)usage);
    }

    public void stop() {
        LOG.debug("analyzer stopped");
        this.myStopped.set(true);
        this.myAnalyzerQueue.cancelAllUpdates();
        this.clearCaches();
        this.myAnalyzerQueue.deactivate();
    }

    public void clearCaches() {
        LOG.debug("clear caches");
        this.myProblemHolders.clear();
    }

    public void clearAllProblems() {
        this.myProblemHolders.clear();
        ((ProjectStructureDaemonAnalyzerListener)this.myDispatcher.getMulticaster()).allProblemsChanged();
    }

    public void dispose() {
        this.myStopped.set(true);
        this.myAnalyzerQueue.cancelAllUpdates();
    }

    @Nullable
    public ProjectStructureProblemsHolderImpl getProblemsHolder(ProjectStructureElement element) {
        return this.myProblemHolders.get(element);
    }

    public Collection<ProjectStructureElementUsage> getUsages(ProjectStructureElement selected) {
        ProjectStructureElement[] elements;
        for (ProjectStructureElement element : elements = this.myElementWithNotCalculatedUsages.toArray(new ProjectStructureElement[this.myElementWithNotCalculatedUsages.size()])) {
            this.updateUsages(element, element.getUsagesInElement());
        }
        List<ProjectStructureElementUsage> usages = this.mySourceElement2Usages.get((Object)selected);
        return usages != null ? usages : Collections.emptyList();
    }

    public void addListener(ProjectStructureDaemonAnalyzerListener listener) {
        LOG.debug("listener added " + listener);
        this.myDispatcher.addListener((EventListener)listener);
    }

    public void reset() {
        LOG.debug("analyzer started");
        this.myAnalyzerQueue.activate();
        this.myAnalyzerQueue.queue(new Update("reset"){

            public void run() {
                ProjectStructureDaemonAnalyzer.this.myStopped.set(false);
            }
        });
    }

    public void clear() {
        this.mySourceElement2Usages.clear();
        this.myContainingElement2Usages.clear();
        this.myElementWithNotCalculatedUsages.clear();
    }

    private class AnalyzeElementUpdate
    extends Update {
        private final ProjectStructureElement myElement;
        private final boolean myCheck;
        private final boolean myCollectUsages;
        private final Object[] myEqualityObjects;

        public AnalyzeElementUpdate(ProjectStructureElement element, boolean check, boolean collectUsages) {
            super((Object)element);
            this.myElement = element;
            this.myCheck = check;
            this.myCollectUsages = collectUsages;
            this.myEqualityObjects = new Object[]{this.myElement, this.myCheck, this.myCollectUsages};
        }

        public boolean canEat(Update update) {
            if (!(update instanceof AnalyzeElementUpdate)) {
                return false;
            }
            AnalyzeElementUpdate other = (AnalyzeElementUpdate)update;
            return !(!this.myElement.equals(other.myElement) || other.myCheck && !this.myCheck || other.myCollectUsages && !this.myCollectUsages);
        }

        public Object[] getEqualityObjects() {
            return this.myEqualityObjects;
        }

        public void run() {
            try {
                ProjectStructureDaemonAnalyzer.this.doUpdate(this.myElement, this.myCheck, this.myCollectUsages);
            }
            catch (Throwable t) {
                LOG.error(t);
            }
        }
    }
}

