/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorEx;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactProblemsHolderImpl;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactsStructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.artifacts.UsageInArtifact;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.LibraryProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ModuleProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElementUsage;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemsHolder;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.artifacts.PackagingElementPath;
import com.intellij.packaging.impl.artifacts.PackagingElementProcessor;
import com.intellij.packaging.impl.elements.ArtifactPackagingElement;
import com.intellij.packaging.impl.elements.LibraryPackagingElement;
import com.intellij.packaging.impl.elements.ModuleOutputPackagingElement;
import com.intellij.packaging.ui.ArtifactProblemsHolder;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ArtifactProjectStructureElement
extends ProjectStructureElement {
    private final ArtifactsStructureConfigurableContext myArtifactsStructureContext;
    private final Artifact myOriginalArtifact;

    ArtifactProjectStructureElement(StructureConfigurableContext context, ArtifactsStructureConfigurableContext artifactsStructureContext, Artifact artifact) {
        super(context);
        this.myArtifactsStructureContext = artifactsStructureContext;
        this.myOriginalArtifact = artifactsStructureContext.getOriginalArtifact(artifact);
    }

    @Override
    public void check(ProjectStructureProblemsHolder problemsHolder) {
        ArtifactEditorEx artifactEditor = (ArtifactEditorEx)this.myArtifactsStructureContext.getOrCreateEditor(this.myOriginalArtifact);
        Artifact artifact = artifactEditor.getArtifact();
        artifact.getArtifactType().checkRootElement(artifactEditor.getRootElement(), artifact, (ArtifactProblemsHolder)new ArtifactProblemsHolderImpl(artifactEditor.getContext(), problemsHolder));
    }

    public Artifact getOriginalArtifact() {
        return this.myOriginalArtifact;
    }

    @Override
    public List<ProjectStructureElementUsage> getUsagesInElement() {
        Artifact artifact = this.myArtifactsStructureContext.getArtifactModel().getArtifactByOriginal(this.myOriginalArtifact);
        final ArrayList<ProjectStructureElementUsage> usages = new ArrayList<ProjectStructureElementUsage>();
        ArtifactUtil.processPackagingElements(this.myArtifactsStructureContext.getRootElement(artifact), null, new PackagingElementProcessor<PackagingElement<?>>(){

            @Override
            public boolean process(@NotNull PackagingElement<?> packagingElement, @NotNull PackagingElementPath path) {
                Artifact usedArtifact;
                if (packagingElement == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactProjectStructureElement$1.process must not be null");
                }
                if (path == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactProjectStructureElement$1.process must not be null");
                }
                if (packagingElement instanceof ModuleOutputPackagingElement) {
                    Module module = ((ModuleOutputPackagingElement)packagingElement).findModule(ArtifactProjectStructureElement.this.myArtifactsStructureContext);
                    if (module != null) {
                        usages.add(new UsageInArtifact(ArtifactProjectStructureElement.this.myOriginalArtifact, ArtifactProjectStructureElement.this.myArtifactsStructureContext, new ModuleProjectStructureElement(ArtifactProjectStructureElement.this.myContext, module), ArtifactProjectStructureElement.this, path.getPathString(), packagingElement));
                    }
                } else if (packagingElement instanceof LibraryPackagingElement) {
                    Library library = ((LibraryPackagingElement)packagingElement).findLibrary(ArtifactProjectStructureElement.this.myArtifactsStructureContext);
                    if (library != null) {
                        usages.add(new UsageInArtifact(ArtifactProjectStructureElement.this.myOriginalArtifact, ArtifactProjectStructureElement.this.myArtifactsStructureContext, new LibraryProjectStructureElement(ArtifactProjectStructureElement.this.myContext, library), ArtifactProjectStructureElement.this, path.getPathString(), packagingElement));
                    }
                } else if (packagingElement instanceof ArtifactPackagingElement && (usedArtifact = ((ArtifactPackagingElement)packagingElement).findArtifact(ArtifactProjectStructureElement.this.myArtifactsStructureContext)) != null) {
                    ArtifactProjectStructureElement artifactElement = ArtifactProjectStructureElement.this.myArtifactsStructureContext.getOrCreateArtifactElement(usedArtifact);
                    usages.add(new UsageInArtifact(ArtifactProjectStructureElement.this.myOriginalArtifact, ArtifactProjectStructureElement.this.myArtifactsStructureContext, artifactElement, ArtifactProjectStructureElement.this, path.getPathString(), packagingElement));
                }
                return true;
            }
        }, this.myArtifactsStructureContext, false, artifact.getArtifactType());
        return usages;
    }

    public String toString() {
        return "artifact:" + this.myOriginalArtifact.getName();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArtifactProjectStructureElement)) {
            return false;
        }
        return this.myOriginalArtifact.equals(((ArtifactProjectStructureElement)o).myOriginalArtifact);
    }

    @Override
    public int hashCode() {
        return this.myOriginalArtifact.hashCode();
    }

    @Override
    public boolean highlightIfUnused() {
        return false;
    }
}

