/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.facet.impl.ProjectFacetsConfigurator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleConfigurationEditor;
import com.intellij.openapi.module.impl.ModuleConfigurationStateImpl;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.ModuleRootManagerImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.ui.configuration.FacetsProvider;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurationEditorProvider;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurationState;
import com.intellij.openapi.roots.ui.configuration.ModuleElementsEditor;
import com.intellij.openapi.roots.ui.configuration.ModuleLevelConfigurablesEditorProvider;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.roots.ui.configuration.UIRootConfigurationAccessor;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import com.intellij.util.EventDispatcher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ModuleEditor
implements Place.Navigator,
Disposable {
    private final Project myProject;
    private JPanel myGenericSettingsPanel;
    private ModifiableRootModel myModifiableRootModel;
    private static String ourSelectedTabName;
    private TabbedPaneWrapper myTabbedPane;
    private final ModulesProvider myModulesProvider;
    private String myName;
    private final Module myModule;
    private final List<ModuleConfigurationEditor> myEditors;
    private ModifiableRootModel myModifiableRootModelProxy;
    private final EventDispatcher<ChangeListener> myEventDispatcher;
    @NonNls
    private static final String METHOD_COMMIT = "commit";
    private History myHistory;

    public ModuleEditor(Project project, ModulesProvider modulesProvider, @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/ModuleEditor.<init> must not be null");
        }
        this.myEditors = new ArrayList<ModuleConfigurationEditor>();
        this.myEventDispatcher = EventDispatcher.create(ChangeListener.class);
        this.myProject = project;
        this.myModulesProvider = modulesProvider;
        this.myModule = module;
        this.myName = module.getName();
    }

    public void init(String selectedTab, History history) {
        this.myHistory = history;
        for (ModuleConfigurationEditor each : this.myEditors) {
            if (!(each instanceof ModuleElementsEditor)) continue;
            ((ModuleElementsEditor)each).setHistory(this.myHistory);
        }
        this.setSelectedTabName(selectedTab);
    }

    public abstract ProjectFacetsConfigurator getFacetsConfigurator();

    public void addChangeListener(ChangeListener listener) {
        this.myEventDispatcher.addListener((EventListener)listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.myEventDispatcher.removeListener((EventListener)listener);
    }

    @Nullable
    public Module getModule() {
        Module[] all;
        for (Module each : all = this.myModulesProvider.getModules()) {
            if (each != this.myModule) continue;
            return this.myModule;
        }
        return this.myModulesProvider.getModule(this.myName);
    }

    public ModifiableRootModel getModifiableRootModel() {
        Module module;
        if (this.myModifiableRootModel == null && (module = this.getModule()) != null) {
            this.myModifiableRootModel = ((ModuleRootManagerImpl)ModuleRootManager.getInstance((Module)module)).getModifiableModel(new UIRootConfigurationAccessor(this.myProject));
        }
        return this.myModifiableRootModel;
    }

    public OrderEntry[] getOrderEntries() {
        if (this.myModifiableRootModel == null) {
            return ModuleRootManager.getInstance((Module)this.getModule()).getOrderEntries();
        }
        return this.myModifiableRootModel.getOrderEntries();
    }

    public ModifiableRootModel getModifiableRootModelProxy() {
        ModifiableRootModel rootModel;
        if (this.myModifiableRootModelProxy == null && (rootModel = this.getModifiableRootModel()) != null) {
            this.myModifiableRootModelProxy = (ModifiableRootModel)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{ModifiableRootModel.class}, (InvocationHandler)new ModifiableRootModelInvocationHandler(rootModel));
        }
        return this.myModifiableRootModelProxy;
    }

    public ModuleRootModel getRootModel() {
        if (this.myModifiableRootModel != null) {
            return this.getModifiableRootModelProxy();
        }
        return ModuleRootManager.getInstance((Module)this.myModule);
    }

    public boolean isModified() {
        for (ModuleConfigurationEditor moduleElementsEditor : this.myEditors) {
            if (!moduleElementsEditor.isModified()) continue;
            return true;
        }
        return false;
    }

    private void createEditors(Module module) {
        ModuleConfigurationEditorProvider[] providers = ModuleEditor.collectProviders(module);
        ModuleConfigurationState state = this.createModuleConfigurationState();
        ArrayList<ModuleLevelConfigurablesEditorProvider> moduleLevelProviders = new ArrayList<ModuleLevelConfigurablesEditorProvider>();
        for (ModuleConfigurationEditorProvider provider : providers) {
            if (provider instanceof ModuleLevelConfigurablesEditorProvider) {
                moduleLevelProviders.add((ModuleLevelConfigurablesEditorProvider)provider);
                continue;
            }
            this.processEditorsProvider(provider, state);
        }
        for (ModuleLevelConfigurablesEditorProvider provider : moduleLevelProviders) {
            this.processEditorsProvider(provider, state);
        }
    }

    private static ModuleConfigurationEditorProvider[] collectProviders(Module module) {
        ArrayList<Object> result = new ArrayList<Object>();
        result.addAll(Arrays.asList(module.getComponents(ModuleConfigurationEditorProvider.class)));
        result.addAll(Arrays.asList(Extensions.getExtensions((ExtensionPointName)ModuleConfigurationEditorProvider.EP_NAME, (AreaInstance)module)));
        return result.toArray(new ModuleConfigurationEditorProvider[result.size()]);
    }

    public ModuleConfigurationState createModuleConfigurationState() {
        return new ModuleConfigurationStateImpl(this.myProject, this.myModulesProvider){

            @Override
            public ModifiableRootModel getRootModel() {
                return ModuleEditor.this.getModifiableRootModelProxy();
            }

            @Override
            public FacetsProvider getFacetsProvider() {
                return ModuleEditor.this.getFacetsConfigurator();
            }
        };
    }

    private void processEditorsProvider(ModuleConfigurationEditorProvider provider, ModuleConfigurationState state) {
        ModuleConfigurationEditor[] editors = provider.createEditors(state);
        this.myEditors.addAll(Arrays.asList(editors));
    }

    private JPanel createPanel() {
        this.getModifiableRootModel();
        this.getModifiableRootModelProxy();
        this.myGenericSettingsPanel = new ModuleEditorPanel();
        this.createEditors(this.getModule());
        JPanel northPanel = new JPanel(new GridBagLayout());
        this.myGenericSettingsPanel.add((Component)northPanel, "North");
        this.myTabbedPane = new TabbedPaneWrapper(this);
        for (ModuleConfigurationEditor editor : this.myEditors) {
            this.myTabbedPane.addTab(editor.getDisplayName(), editor.getIcon(), editor.createComponent(), null);
            editor.reset();
        }
        this.setSelectedTabName(ourSelectedTabName);
        this.myGenericSettingsPanel.add((Component)this.myTabbedPane.getComponent(), "Center");
        this.myTabbedPane.addChangeListener(new javax.swing.event.ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ourSelectedTabName = ModuleEditor.this.getSelectedTabName();
                if (ModuleEditor.this.myHistory != null) {
                    ModuleEditor.this.myHistory.pushQueryPlace();
                }
            }
        });
        return this.myGenericSettingsPanel;
    }

    public ActionCallback navigateTo(@Nullable Place place, boolean requestFocus) {
        this.myTabbedPane.setSelectedTitle((String)place.getPath("moduleTab"));
        return new ActionCallback.Done();
    }

    public void queryPlace(@NotNull Place place) {
        if (place == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/ModuleEditor.queryPlace must not be null");
        }
        place.putPath("moduleTab", (Object)ourSelectedTabName);
    }

    public static String getSelectedTab() {
        return ourSelectedTabName;
    }

    private int getEditorTabIndex(String editorName) {
        if (this.myTabbedPane != null && editorName != null) {
            int tabCount = this.myTabbedPane.getTabCount();
            for (int idx = 0; idx < tabCount; ++idx) {
                if (!editorName.equals(this.myTabbedPane.getTitleAt(idx))) continue;
                return idx;
            }
        }
        return -1;
    }

    public JPanel getPanel() {
        if (this.myGenericSettingsPanel == null) {
            this.myGenericSettingsPanel = this.createPanel();
        }
        return this.myGenericSettingsPanel;
    }

    public void moduleCountChanged() {
        this.updateOrderEntriesInEditors();
    }

    private void updateOrderEntriesInEditors() {
        if (this.getModule() != null) {
            this.getPanel();
            for (ModuleConfigurationEditor myEditor : this.myEditors) {
                myEditor.moduleStateChanged();
            }
            ((ChangeListener)this.myEventDispatcher.getMulticaster()).moduleStateChanged(this.getModifiableRootModelProxy());
        }
    }

    public void updateCompilerOutputPathChanged(String baseUrl, String moduleName) {
        if (this.myGenericSettingsPanel == null) {
            return;
        }
        for (ModuleConfigurationEditor myEditor : this.myEditors) {
            if (!(myEditor instanceof ModuleElementsEditor)) continue;
            ((ModuleElementsEditor)myEditor).moduleCompileOutputChanged(baseUrl, moduleName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        try {
            for (ModuleConfigurationEditor myEditor : this.myEditors) {
                myEditor.disposeUIResources();
            }
            this.myEditors.clear();
            if (this.myTabbedPane != null) {
                ourSelectedTabName = this.getSelectedTabName();
                this.myTabbedPane = null;
            }
            if (this.myModifiableRootModel != null) {
                this.myModifiableRootModel.dispose();
            }
            this.myGenericSettingsPanel = null;
        }
        finally {
            this.myModifiableRootModel = null;
            this.myModifiableRootModelProxy = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModifiableRootModel apply() throws ConfigurationException {
        try {
            for (ModuleConfigurationEditor editor : this.myEditors) {
                if (!(editor instanceof ModuleElementsEditor)) continue;
                ((ModuleElementsEditor)editor).canApply();
            }
            for (ModuleConfigurationEditor editor : this.myEditors) {
                editor.saveData();
                editor.apply();
            }
            ModifiableRootModel modifiableRootModel = this.myModifiableRootModel;
            return modifiableRootModel;
        }
        finally {
            this.myModifiableRootModel = null;
            this.myModifiableRootModelProxy = null;
        }
    }

    public String getName() {
        return this.myName;
    }

    @Nullable
    public String getSelectedTabName() {
        return this.myTabbedPane == null || this.myTabbedPane.getSelectedIndex() == -1 ? null : this.myTabbedPane.getTitleAt(this.myTabbedPane.getSelectedIndex());
    }

    public void setSelectedTabName(@Nullable String name) {
        if (name != null) {
            this.getPanel();
            int editorTabIndex = this.getEditorTabIndex(name);
            if (editorTabIndex >= 0 && editorTabIndex < this.myTabbedPane.getTabCount()) {
                this.myTabbedPane.setSelectedIndex(editorTabIndex);
                ourSelectedTabName = name;
            }
        }
    }

    @Nullable
    public ModuleConfigurationEditor getEditor(@NotNull String tabName) {
        if (tabName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/ModuleEditor.getEditor must not be null");
        }
        int index = this.getEditorTabIndex(tabName);
        if (0 <= index && index < this.myEditors.size()) {
            return this.myEditors.get(index);
        }
        return null;
    }

    private static Object[] unwrapParams(Object[] params) {
        if (params == null || params.length == 0) {
            return params;
        }
        Object[] unwrappedParams = new Object[params.length];
        for (int idx = 0; idx < params.length; ++idx) {
            InvocationHandler invocationHandler;
            Object param = params[idx];
            if (param != null && Proxy.isProxyClass(param.getClass()) && (invocationHandler = Proxy.getInvocationHandler(param)) instanceof ProxyDelegateAccessor) {
                param = ((ProxyDelegateAccessor)((Object)invocationHandler)).getDelegate();
            }
            unwrappedParams[idx] = param;
        }
        return unwrappedParams;
    }

    @Nullable
    public String getHelpTopic() {
        if (this.myTabbedPane == null || this.myEditors.isEmpty()) {
            return null;
        }
        int selectedIdx = this.myTabbedPane.getSelectedIndex();
        if (selectedIdx == -1) {
            return null;
        }
        ModuleConfigurationEditor moduleElementsEditor = this.myEditors.get(selectedIdx);
        return moduleElementsEditor.getHelpTopic();
    }

    public void setModuleName(String name) {
        this.myName = name;
    }

    public void setHistory(History history) {
    }

    private class ModuleEditorPanel
    extends JPanel
    implements DataProvider {
        public ModuleEditorPanel() {
            super(new BorderLayout());
        }

        public Object getData(String dataId) {
            if (LangDataKeys.MODULE_CONTEXT.is(dataId)) {
                return ModuleEditor.this.getModule();
            }
            return null;
        }
    }

    public static interface ProxyDelegateAccessor {
        public Object getDelegate();
    }

    private class LibraryTableModelInvocationHandler
    implements InvocationHandler {
        private final LibraryTable.ModifiableModel myDelegateModel;

        LibraryTableModelInvocationHandler(LibraryTable.ModifiableModel delegateModel) {
            this.myDelegateModel = delegateModel;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] params) throws Throwable {
            boolean needUpdate = ModuleEditor.METHOD_COMMIT.equals(method.getName());
            try {
                Object result = method.invoke((Object)this.myDelegateModel, ModuleEditor.unwrapParams(params));
                if (result instanceof Library[]) {
                    Library[] libraries = (Library[])result;
                    for (int idx = 0; idx < libraries.length; ++idx) {
                        Library library = libraries[idx];
                        libraries[idx] = (Library)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Library.class}, (InvocationHandler)new LibraryInvocationHandler(library));
                    }
                }
                if (result instanceof Library) {
                    result = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Library.class}, (InvocationHandler)new LibraryInvocationHandler((Library)result));
                }
                Object object2 = result;
                return object2;
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
            finally {
                if (needUpdate) {
                    ModuleEditor.this.updateOrderEntriesInEditors();
                }
            }
        }
    }

    private class LibraryModifiableModelInvocationHandler
    implements InvocationHandler {
        private final Library.ModifiableModel myDelegateModel;

        LibraryModifiableModelInvocationHandler(Library.ModifiableModel delegateModel) {
            this.myDelegateModel = delegateModel;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] params) throws Throwable {
            boolean needUpdate = ModuleEditor.METHOD_COMMIT.equals(method.getName());
            try {
                Object object2 = method.invoke((Object)this.myDelegateModel, ModuleEditor.unwrapParams(params));
                return object2;
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
            finally {
                if (needUpdate) {
                    ModuleEditor.this.updateOrderEntriesInEditors();
                }
            }
        }
    }

    private class LibraryInvocationHandler
    implements InvocationHandler,
    ProxyDelegateAccessor {
        private final Library myDelegateLibrary;

        LibraryInvocationHandler(Library delegateLibrary) {
            this.myDelegateLibrary = delegateLibrary;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] params) throws Throwable {
            try {
                Object result = method.invoke((Object)this.myDelegateLibrary, ModuleEditor.unwrapParams(params));
                if (result instanceof Library.ModifiableModel) {
                    return Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Library.ModifiableModel.class}, (InvocationHandler)new LibraryModifiableModelInvocationHandler((Library.ModifiableModel)result));
                }
                return result;
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }

        @Override
        public Object getDelegate() {
            return this.myDelegateLibrary;
        }
    }

    private class LibraryTableInvocationHandler
    implements InvocationHandler {
        private final LibraryTable myDelegateTable;
        @NonNls
        private final Set<String> myCheckedNames = new HashSet<String>(Arrays.asList("removeLibrary"));

        LibraryTableInvocationHandler(LibraryTable table) {
            this.myDelegateTable = table;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] params) throws Throwable {
            boolean needUpdate = this.myCheckedNames.contains(method.getName());
            try {
                Object result = method.invoke((Object)this.myDelegateTable, ModuleEditor.unwrapParams(params));
                if (result instanceof Library) {
                    Object object2 = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Library.class}, (InvocationHandler)new LibraryInvocationHandler((Library)result));
                    return object2;
                }
                if (result instanceof LibraryTable.ModifiableModel) {
                    Object object3 = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{LibraryTable.ModifiableModel.class}, (InvocationHandler)new LibraryTableModelInvocationHandler((LibraryTable.ModifiableModel)result));
                    return object3;
                }
                if (result instanceof Library[]) {
                    Library[] libraries = (Library[])result;
                    for (int idx = 0; idx < libraries.length; ++idx) {
                        Library library = libraries[idx];
                        libraries[idx] = (Library)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Library.class}, (InvocationHandler)new LibraryInvocationHandler(library));
                    }
                }
                Object object4 = result;
                return object4;
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
            finally {
                if (needUpdate) {
                    ModuleEditor.this.updateOrderEntriesInEditors();
                }
            }
        }
    }

    private class ModifiableRootModelInvocationHandler
    implements InvocationHandler {
        private final ModifiableRootModel myDelegateModel;
        @NonNls
        private final Set<String> myCheckedNames = new HashSet<String>(Arrays.asList("addOrderEntry", "addLibraryEntry", "addInvalidLibrary", "addModuleOrderEntry", "addInvalidModuleEntry", "removeOrderEntry", "setSdk", "inheritSdk", "inheritCompilerOutputPath", "setExcludeOutput", "replaceEntryOfType"));

        ModifiableRootModelInvocationHandler(ModifiableRootModel model) {
            this.myDelegateModel = model;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] params) throws Throwable {
            boolean needUpdate = this.myCheckedNames.contains(method.getName());
            try {
                Object result = method.invoke((Object)this.myDelegateModel, ModuleEditor.unwrapParams(params));
                if (result instanceof LibraryTable) {
                    Object object2 = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{LibraryTable.class}, (InvocationHandler)new LibraryTableInvocationHandler((LibraryTable)result));
                    return object2;
                }
                Object object3 = result;
                return object3;
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
            finally {
                if (needUpdate) {
                    ModuleEditor.this.updateOrderEntriesInEditors();
                }
            }
        }
    }

    public static interface ChangeListener
    extends EventListener {
        public void moduleStateChanged(ModifiableRootModel var1);
    }
}

