/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Comparator;

public class LibrariesAlphaComparator
implements Comparator<Library> {
    public static LibrariesAlphaComparator INSTANCE = new LibrariesAlphaComparator();

    @Override
    public int compare(Library library1, Library library2) {
        String name2;
        String name1 = library1.getName();
        if (name1 != null && name1.length() == 0) {
            name1 = null;
        }
        if ((name2 = library2.getName()) != null && name2.length() == 0) {
            name2 = null;
        }
        if (name1 == null && name2 == null) {
            VirtualFile[] files1 = library1.getFiles(OrderRootType.CLASSES);
            VirtualFile[] files2 = library2.getFiles(OrderRootType.CLASSES);
            name1 = files1.length > 0 ? files1[0].getName() : null;
            name2 = files2.length > 0 ? files2[0].getName() : null;
        }
        return this.compareNames(name1, name2);
    }

    public int compareNames(String name1, String name2) {
        if (name1 == null && name2 == null) {
            return 0;
        }
        if (name1 == null) {
            return -1;
        }
        if (name2 == null) {
            return 1;
        }
        return name1.compareToIgnoreCase(name2);
    }
}

