/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.ide.DataManager;
import com.intellij.ide.util.projectWizard.ProjectJdkListRenderer;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.JdkListConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectJdksModel;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.Consumer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;

class JdkComboBox
extends JComboBox {
    private final JButton myEditButton = new JButton(ApplicationBundle.message((String)"button.edit", (Object[])new Object[0]));

    public JdkComboBox(final ProjectJdksModel jdksModel) {
        super(new JdkComboBoxModel(jdksModel));
        this.setRenderer(new ProjectJdkListRenderer(){

            @Override
            protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (JdkComboBox.this.isEnabled()) {
                    if (value instanceof InvalidJdkComboBoxItem) {
                        String str = value.toString();
                        this.append(str, SimpleTextAttributes.ERROR_ATTRIBUTES);
                    } else if (value instanceof ProjectJdkComboBoxItem) {
                        ProjectJdkComboBoxItem item = (ProjectJdkComboBoxItem)value;
                        String str = item.toString();
                        Sdk jdk = jdksModel.getProjectJdk();
                        if (jdk != null) {
                            this.setIcon(jdk.getSdkType().getIcon());
                            this.append(ProjectBundle.message((String)"project.roots.project.jdk.inherited", (Object[])new Object[0]), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                            this.append(" (" + jdk.getName() + ")", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                        } else {
                            this.append(str, SimpleTextAttributes.ERROR_ATTRIBUTES);
                        }
                    } else {
                        super.customizeCellRenderer(list, value != null ? ((JdkComboBoxItem)value).getJdk() : new NoneJdkComboBoxItem(), index, selected, hasFocus);
                    }
                }
            }
        });
    }

    @Override
    public Dimension getPreferredSize() {
        Rectangle rec = ScreenUtil.getScreenRectangle((int)0, (int)0);
        Dimension size = super.getPreferredSize();
        int maxWidth = rec.width / 4;
        if (size.width > maxWidth) {
            size.width = maxWidth;
        }
        return size;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension minSize = super.getMinimumSize();
        Dimension prefSize = this.getPreferredSize();
        if (minSize.width > prefSize.width) {
            minSize.width = prefSize.width;
        }
        return minSize;
    }

    public JButton createSetupButton(Project project, ProjectJdksModel jdksModel, JdkComboBoxItem firstItem) {
        return this.createSetupButton(project, jdksModel, firstItem, null, false);
    }

    public JButton createSetupButton(final Project project, final ProjectJdksModel jdksModel, final JdkComboBoxItem firstItem, final Condition<Sdk> additionalSetup, final boolean moduleJdkSetup) {
        final JButton setUpButton = new JButton(ApplicationBundle.message((String)"button.new", (Object[])new Object[0]));
        setUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final JdkListConfigurable configurable = JdkListConfigurable.getInstance(project);
                DefaultActionGroup group = new DefaultActionGroup();
                jdksModel.createAddActions(group, JdkComboBox.this, new Consumer<Sdk>(){

                    public void consume(Sdk jdk) {
                        configurable.addJdkNode(jdk, false);
                        JdkComboBox.this.reloadModel(firstItem, project);
                        JdkComboBox.this.setSelectedJdk(jdk);
                        if (additionalSetup != null && additionalSetup.value((Object)jdk)) {
                            JdkComboBox.this.setSelectedJdk(firstItem.getJdk());
                        }
                    }
                });
                JBPopupFactory.getInstance().createActionGroupPopup(ProjectBundle.message((String)"project.roots.set.up.jdk.title", (Object[])new Object[]{moduleJdkSetup ? 1 : 2}), (ActionGroup)group, DataManager.getInstance().getDataContext(), JBPopupFactory.ActionSelectionAid.MNEMONICS, false).showUnderneathOf((Component)setUpButton);
            }
        });
        return setUpButton;
    }

    public void appendEditButton(final Project project, JPanel panel, GridBagConstraints gc, final Computable<Sdk> retrieveJDK) {
        this.myEditButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Sdk projectJdk = (Sdk)retrieveJDK.compute();
                ProjectStructureConfigurable.getInstance(project).select(projectJdk, true);
            }
        });
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JdkComboBoxItem selectedItem = JdkComboBox.this.getSelectedItem();
                if (selectedItem instanceof ProjectJdkComboBoxItem) {
                    JdkComboBox.this.myEditButton.setEnabled(ProjectStructureConfigurable.getInstance(project).getProjectJdksModel().getProjectJdk() != null);
                } else {
                    JdkComboBox.this.myEditButton.setEnabled(!(selectedItem instanceof InvalidJdkComboBoxItem) && selectedItem != null && selectedItem.getJdk() != null);
                }
            }
        });
        panel.add((Component)this.myEditButton, gc);
    }

    @Override
    public JdkComboBoxItem getSelectedItem() {
        return (JdkComboBoxItem)super.getSelectedItem();
    }

    public Sdk getSelectedJdk() {
        JdkComboBoxItem selectedItem = (JdkComboBoxItem)super.getSelectedItem();
        return selectedItem != null ? selectedItem.getJdk() : null;
    }

    public void setSelectedJdk(Sdk jdk) {
        int index = this.indexOf(jdk);
        if (index >= 0) {
            this.setSelectedIndex(index);
        }
    }

    public void setInvalidJdk(String name) {
        this.removeInvalidElement();
        this.addItem(new InvalidJdkComboBoxItem(name));
        this.setSelectedIndex(this.getModel().getSize() - 1);
    }

    private int indexOf(Sdk jdk) {
        JdkComboBoxModel model = (JdkComboBoxModel)this.getModel();
        int count = model.getSize();
        for (int idx = 0; idx < count; ++idx) {
            JdkComboBoxItem elementAt = model.getElementAt(idx);
            if (jdk == null) {
                if (elementAt instanceof NoneJdkComboBoxItem) {
                    return idx;
                }
                if (!(elementAt instanceof ProjectJdkComboBoxItem)) continue;
                return idx;
            }
            if (!jdk.equals(elementAt.getJdk())) continue;
            return idx;
        }
        return -1;
    }

    private void removeInvalidElement() {
        JdkComboBoxModel model = (JdkComboBoxModel)this.getModel();
        int count = model.getSize();
        for (int idx = 0; idx < count; ++idx) {
            JdkComboBoxItem elementAt = model.getElementAt(idx);
            if (!(elementAt instanceof InvalidJdkComboBoxItem)) continue;
            this.removeItemAt(idx);
            break;
        }
    }

    public void reloadModel(JdkComboBoxItem firstItem, Project project) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.getModel();
        model.removeAllElements();
        model.addElement(firstItem);
        ArrayList<Sdk> projectJdks = new ArrayList<Sdk>(ProjectJdksModel.getInstance(project).getProjectJdks().values());
        Collections.sort(projectJdks, new Comparator<Sdk>(){

            @Override
            public int compare(Sdk o1, Sdk o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        for (Sdk projectJdk : projectJdks) {
            model.addElement(new JdkComboBoxItem(projectJdk));
        }
    }

    private static class InvalidJdkComboBoxItem
    extends JdkComboBoxItem {
        private final String myName;

        public InvalidJdkComboBoxItem(String name) {
            super(null);
            this.myName = ProjectBundle.message((String)"jdk.combo.box.invalid.item", (Object[])new Object[]{name});
        }

        @Override
        public String toString() {
            return this.myName;
        }
    }

    public static class NoneJdkComboBoxItem
    extends JdkComboBoxItem {
        public NoneJdkComboBoxItem() {
            super(null);
        }

        @Override
        public String toString() {
            return ProjectBundle.message((String)"jdk.combo.box.none.item", (Object[])new Object[0]);
        }
    }

    public static class ProjectJdkComboBoxItem
    extends JdkComboBoxItem {
        public ProjectJdkComboBoxItem() {
            super(null);
        }

        @Override
        public String toString() {
            return ProjectBundle.message((String)"jdk.combo.box.project.item", (Object[])new Object[0]);
        }
    }

    public static class JdkComboBoxItem {
        private final Sdk myJdk;

        public JdkComboBoxItem(Sdk jdk) {
            this.myJdk = jdk;
        }

        public Sdk getJdk() {
            return this.myJdk;
        }

        public String toString() {
            return this.myJdk.getName();
        }
    }

    private static class JdkComboBoxModel
    extends DefaultComboBoxModel {
        public JdkComboBoxModel(ProjectJdksModel jdksModel) {
            Sdk[] jdks = jdksModel.getSdks();
            Arrays.sort(jdks, new Comparator<Sdk>(){

                @Override
                public int compare(Sdk s1, Sdk s2) {
                    return s1.getName().compareToIgnoreCase(s2.getName());
                }
            });
            for (Sdk jdk : jdks) {
                this.addElement(new JdkComboBoxItem(jdk));
            }
        }

        @Override
        public JdkComboBoxItem getElementAt(int index) {
            return (JdkComboBoxItem)super.getElementAt(index);
        }
    }
}

