/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl.libraries;

import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.roots.impl.libraries.LibraryImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.InvalidDataException;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class LibraryTableImplUtil {
    @NonNls
    public static final String MODULE_LEVEL = "module";

    private LibraryTableImplUtil() {
    }

    public static Library loadLibrary(Element rootElement, RootModelImpl rootModel) throws InvalidDataException {
        List children = rootElement.getChildren("library");
        if (children.size() != 1) {
            throw new InvalidDataException();
        }
        Element element = (Element)children.get(0);
        return new LibraryImpl(null, element, (ModifiableRootModel)rootModel);
    }

    public static Library createModuleLevelLibrary(@Nullable String name, RootModelImpl rootModel) {
        return new LibraryImpl(name, null, (ModifiableRootModel)rootModel);
    }
}

