/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.ui;

import com.intellij.application.options.ExportSchemeAction;
import com.intellij.application.options.ImportSchemeAction;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ex.QuickList;
import com.intellij.openapi.actionSystem.ex.QuickListsManager;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.keymap.impl.ui.KeymapPanel;
import com.intellij.openapi.keymap.impl.ui.QuickListPanel;
import com.intellij.openapi.options.MasterDetails;
import com.intellij.openapi.options.SchemesManager;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DetailsComponent;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Factory;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.ListScrollingUtil;
import com.intellij.ui.ReorderableListController;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.ArrayUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.Nls;

public class QuickListsPanel
extends JPanel
implements SearchableConfigurable,
MasterDetails {
    private final DefaultListModel myQuickListsModel = new DefaultListModel();
    private JList myQuickListsList = new JList(this.myQuickListsModel);
    private final JPanel myRightPanel = new JPanel(new BorderLayout());
    private int myCurrentIndex = -1;
    private QuickListPanel myQuickListPanel = null;
    private final KeymapPanel myKeymapPanel;
    private JComponent myToolbar;
    private DetailsComponent myDetailsComponent;
    private JScrollPane myListScrollPane;

    public QuickListsPanel(KeymapPanel panel) {
        super(new BorderLayout());
        this.myKeymapPanel = panel;
        this.add((Component)this.createQuickListsPanel(), "West");
        this.add((Component)this.myRightPanel, "Center");
    }

    public void initUi() {
        this.myDetailsComponent = new DetailsComponent();
        this.myDetailsComponent.setContent((JComponent)this.myRightPanel);
    }

    public JComponent getToolbar() {
        return this.myToolbar;
    }

    public JComponent getMaster() {
        return this.myListScrollPane;
    }

    public DetailsComponent getDetails() {
        return this.myDetailsComponent;
    }

    public void reset() {
        QuickList[] allQuickLists;
        this.myQuickListsModel.removeAllElements();
        for (QuickList list : allQuickLists = QuickListsManager.getInstance().getAllQuickLists()) {
            this.myQuickListsModel.addElement(list);
        }
        if (this.myQuickListsModel.size() > 0) {
            this.myQuickListsList.setSelectedIndex(0);
        }
    }

    public boolean isModified() {
        Object[] modelLists;
        Object[] storedLists = QuickListsManager.getInstance().getAllQuickLists();
        return !Comparing.equal((Object[])storedLists, (Object[])(modelLists = this.getCurrentQuickListIds()));
    }

    public void apply() {
        QuickList[] currentQuickLists;
        QuickListsManager.getInstance().removeAllQuickLists();
        for (QuickList quickList : currentQuickLists = this.getCurrentQuickListIds()) {
            QuickListsManager.getInstance().registerQuickList(quickList);
        }
        QuickListsManager.getInstance().registerActions();
    }

    private JPanel createQuickListsPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        this.myQuickListsList = new JList(this.myQuickListsModel);
        this.myQuickListsList.setSelectionMode(0);
        this.myQuickListsList.setCellRenderer(new MyQuickListCellRenderer());
        this.myQuickListsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                QuickListsPanel.this.myRightPanel.removeAll();
                Object selectedValue = QuickListsPanel.this.myQuickListsList.getSelectedValue();
                if (selectedValue instanceof QuickList) {
                    QuickList quickList = (QuickList)selectedValue;
                    QuickListsPanel.this.updateRightPanel(quickList);
                    QuickListsPanel.this.myQuickListsList.repaint();
                } else {
                    QuickListsPanel.this.addDescriptionLabel();
                }
                QuickListsPanel.this.myRightPanel.revalidate();
            }
        });
        this.addDescriptionLabel();
        this.myListScrollPane = ScrollPaneFactory.createScrollPane((JComponent)this.myQuickListsList);
        this.myListScrollPane.setHorizontalScrollBarPolicy(30);
        Dimension dimension = new Dimension(120, -1);
        this.myListScrollPane.setPreferredSize(dimension);
        this.myListScrollPane.setMinimumSize(dimension);
        panel.add((Component)this.myListScrollPane, "Center");
        DefaultActionGroup group = new DefaultActionGroup();
        ReorderableListController controller = ReorderableListController.create((JList)this.myQuickListsList, (DefaultActionGroup)group);
        ReorderableListController.AddActionDescription addActionDescription = controller.addAddAction(KeyMapBundle.message((String)"add.keymap.label", (Object[])new Object[0]), (Factory)new Factory<QuickList>(){

            public QuickList create() {
                return new QuickList(QuickListsPanel.this.createUniqueName(), "", ArrayUtil.EMPTY_STRING_ARRAY, false);
            }
        }, true);
        addActionDescription.addPostHandler((ReorderableListController.ActionNotification)new ReorderableListController.ActionNotification<QuickList>(){

            public void afterActionPerformed(QuickList change) {
                QuickListsPanel.this.myKeymapPanel.processCurrentKeymapChanged();
            }
        });
        ReorderableListController.RemoveActionDescription removeActionDescription = controller.addRemoveAction(KeyMapBundle.message((String)"remove.keymap.label", (Object[])new Object[0]));
        removeActionDescription.addPostHandler((ReorderableListController.ActionNotification)new ReorderableListController.ActionNotification<List<QuickList>>(){

            public void afterActionPerformed(List<QuickList> change) {
                QuickListsPanel.this.myQuickListsList.repaint();
                QuickListsPanel.this.myKeymapPanel.processCurrentKeymapChanged();
            }
        });
        SchemesManager<QuickList, QuickList> schemesManager = QuickListsManager.getInstance().getSchemesManager();
        if (schemesManager.isExportAvailable()) {
            group.add((AnAction)new ExportSchemeAction<QuickList, QuickList>(schemesManager){

                @Override
                protected QuickList getSelectedScheme() {
                    return (QuickList)QuickListsPanel.this.myQuickListsList.getSelectedValue();
                }
            });
        }
        if (schemesManager.isImportAvailable()) {
            group.add((AnAction)new ImportSchemeAction<QuickList, QuickList>(QuickListsManager.getInstance().getSchemesManager()){

                @Override
                protected Collection<QuickList> collectCurrentSchemes() {
                    return QuickListsPanel.this.collectElements();
                }

                @Override
                protected Component getPanel() {
                    return QuickListsPanel.this.myQuickListsList;
                }

                @Override
                protected void importScheme(QuickList scheme) {
                    QuickListsPanel.this.myQuickListsModel.addElement(scheme);
                    QuickListsPanel.this.myQuickListsList.clearSelection();
                    ListScrollingUtil.selectItem((JList)QuickListsPanel.this.myQuickListsList, (Object)scheme);
                }
            });
        }
        this.myToolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)group, true).getComponent();
        panel.add((Component)this.myToolbar, "North");
        return panel;
    }

    private void addDescriptionLabel() {
        JLabel descLabel = new JLabel("<html>Quick Lists allow you to define commonly used groups of actions (for example, refactoring or VCS actions) and to assign keyboard shortcuts to such groups.</html>");
        descLabel.setBorder(new EmptyBorder(0, 25, 0, 25));
        this.myRightPanel.add((Component)descLabel, "Center");
    }

    private Collection<QuickList> collectElements() {
        HashSet<QuickList> result = new HashSet<QuickList>();
        for (int i = 0; i < this.myQuickListsModel.getSize(); ++i) {
            result.add((QuickList)this.myQuickListsModel.getElementAt(i));
        }
        return result;
    }

    private String createUniqueName() {
        int i;
        String str = KeyMapBundle.message((String)"unnamed.list.display.name", (Object[])new Object[0]);
        ArrayList<String> names = new ArrayList<String>();
        for (i = 0; i < this.myQuickListsModel.getSize(); ++i) {
            names.add(((QuickList)this.myQuickListsModel.getElementAt(i)).getDisplayName());
        }
        if (!names.contains(str)) {
            return str;
        }
        i = 1;
        while (names.contains(str + i)) {
            ++i;
        }
        return str + i;
    }

    private void updateRightPanel(QuickList quickList) {
        final int index = this.myQuickListsList.getSelectedIndex();
        if (this.myQuickListPanel != null && this.myCurrentIndex > -1 && this.myCurrentIndex < this.myQuickListsModel.getSize()) {
            this.updateList(this.myCurrentIndex);
            this.myKeymapPanel.processCurrentKeymapChanged();
        }
        Project project = (Project)PlatformDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext());
        this.myQuickListPanel = new QuickListPanel(quickList, this.getCurrentQuickListIds(), project);
        DocumentAdapter documentAdapter = new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                QuickListsPanel.this.updateList(index);
            }
        };
        this.myQuickListPanel.addNameListener(documentAdapter);
        this.myQuickListPanel.addDescriptionListener(documentAdapter);
        this.myRightPanel.add((Component)this.myQuickListPanel.getPanel(), "Center");
        this.myCurrentIndex = index;
        if (this.myDetailsComponent != null) {
            this.myDetailsComponent.setText(new String[]{quickList.getDisplayName()});
        }
    }

    private void updateList(int index) {
        if (this.myQuickListPanel == null) {
            return;
        }
        QuickList oldQuickList = (QuickList)this.myQuickListsModel.getElementAt(index);
        QuickList newQuickList = this.createNewQuickListAt();
        if (oldQuickList != null) {
            newQuickList.getExternalInfo().copy(oldQuickList.getExternalInfo());
        }
        this.myQuickListsModel.setElementAt(newQuickList, index);
        if (oldQuickList != null && !newQuickList.getName().equals(oldQuickList.getName())) {
            this.myKeymapPanel.quickListRenamed(oldQuickList, newQuickList);
            if (this.myDetailsComponent != null) {
                this.myDetailsComponent.setText(new String[]{newQuickList.getDisplayName()});
            }
        }
    }

    private QuickList createNewQuickListAt() {
        ListModel model = this.myQuickListPanel.getActionsList().getModel();
        int size = model.getSize();
        String[] ids = new String[size];
        for (int i = 0; i < size; ++i) {
            ids[i] = (String)model.getElementAt(i);
        }
        QuickList newQuickList = new QuickList(this.myQuickListPanel.getDisplayName(), this.myQuickListPanel.getDescription(), ids, false);
        return newQuickList;
    }

    public QuickList[] getCurrentQuickListIds() {
        if (this.myCurrentIndex > -1 && this.myQuickListsModel.getSize() > this.myCurrentIndex) {
            this.updateList(this.myCurrentIndex);
        }
        int size = this.myQuickListsModel.size();
        QuickList[] lists = new QuickList[size];
        for (int i = 0; i < lists.length; ++i) {
            lists[i] = (QuickList)this.myQuickListsModel.getElementAt(i);
        }
        return lists;
    }

    public String getId() {
        return this.getHelpTopic();
    }

    public Runnable enableSearch(String option) {
        return null;
    }

    @Nls
    public String getDisplayName() {
        return "Quick Lists";
    }

    public Icon getIcon() {
        return null;
    }

    public String getHelpTopic() {
        return "reference.idesettings.quicklists";
    }

    public JComponent createComponent() {
        return this;
    }

    public void disposeUIResources() {
    }

    private static class MyQuickListCellRenderer
    extends DefaultListCellRenderer {
        private MyQuickListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            QuickList quickList = (QuickList)value;
            this.setText(quickList.getDisplayName());
            return this;
        }
    }
}

