/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.event;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.diff.Diff;
import org.jetbrains.annotations.NotNull;

public class DocumentEventImpl
extends DocumentEvent {
    private final int myOffset;
    private final CharSequence myOldString;
    private final int myOldLength;
    private final CharSequence myNewString;
    private final int myNewLength;
    private boolean isOnlyOneLineChangedCalculated = false;
    private boolean isOnlyOneLineChanged;
    private boolean isStartOldIndexCalculated = false;
    private int myStartOldIndex;
    private final long myOldTimeStamp;
    private final boolean myIsWholeDocReplaced;
    private Diff.Change myChange;
    private int myOptimizedLineShift = -1;
    private boolean myOptimizedLineShiftCalculated;
    private int myOptimizedOldLineShift = -1;
    private boolean myOptimizedOldLineShiftCalculated;

    public DocumentEventImpl(Document document, int offset, CharSequence oldString, CharSequence newString, long oldTimeStamp, boolean wholeTextReplaced) {
        super(document);
        this.myOffset = offset;
        this.myOldString = oldString == null ? "" : oldString;
        this.myOldLength = this.myOldString.length();
        this.myNewString = newString == null ? "" : newString;
        this.myNewLength = this.myNewString.length();
        this.myOldTimeStamp = oldTimeStamp;
        if (this.getDocument().getTextLength() == 0) {
            this.isOnlyOneLineChangedCalculated = true;
            this.isOnlyOneLineChanged = false;
            this.myIsWholeDocReplaced = false;
        } else {
            this.myIsWholeDocReplaced = wholeTextReplaced;
        }
    }

    public int getOffset() {
        return this.myOffset;
    }

    public int getOldLength() {
        return this.myOldLength;
    }

    public int getNewLength() {
        return this.myNewLength;
    }

    public CharSequence getOldFragment() {
        return this.myOldString;
    }

    public CharSequence getNewFragment() {
        return this.myNewString;
    }

    @NotNull
    public Document getDocument() {
        Document document = (Document)this.getSource();
        if (document == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/event/DocumentEventImpl.getDocument must not return null");
        }
        return document;
    }

    public int getStartOldIndex() {
        if (this.isStartOldIndexCalculated) {
            return this.myStartOldIndex;
        }
        this.isStartOldIndexCalculated = true;
        this.myStartOldIndex = this.getDocument().getLineNumber(this.myOffset);
        return this.myStartOldIndex;
    }

    public boolean isOnlyOneLineChanged() {
        int i;
        if (this.isOnlyOneLineChangedCalculated) {
            return this.isOnlyOneLineChanged;
        }
        this.isOnlyOneLineChangedCalculated = true;
        this.isOnlyOneLineChanged = true;
        for (i = 0; i < this.myOldString.length(); ++i) {
            if (this.myOldString.charAt(i) != '\n') continue;
            this.isOnlyOneLineChanged = false;
            break;
        }
        if (this.isOnlyOneLineChanged) {
            for (i = 0; i < this.myNewString.length(); ++i) {
                if (this.myNewString.charAt(i) != '\n') continue;
                this.isOnlyOneLineChanged = false;
                break;
            }
        }
        return this.isOnlyOneLineChanged;
    }

    public long getOldTimeStamp() {
        return this.myOldTimeStamp;
    }

    public String toString() {
        return "DocumentEventImpl[myOffset=" + this.myOffset + ", myOldLength=" + this.myOldLength + ", myNewLength=" + this.myNewLength + ", myOldString='" + this.myOldString + "', myNewString='" + this.myNewString + "']" + (this.isWholeTextReplaced() ? " Whole." : ".");
    }

    public boolean isWholeTextReplaced() {
        return this.myIsWholeDocReplaced;
    }

    public int translateLineViaDiff(int line) {
        if (this.myChange == null) {
            this.buildDiff();
        }
        if (this.myChange == null) {
            return line;
        }
        Diff.Change change = this.myChange;
        int newLine = line;
        while (change != null && line >= change.line0) {
            if (line >= change.line0 + change.deleted) {
                newLine += change.inserted - change.deleted;
            } else {
                int delta = Math.min(change.inserted, line - change.line0);
                newLine = change.line1 + delta;
                break;
            }
            change = change.link;
        }
        return newLine;
    }

    public int translateLineViaDiffStrict(int line) {
        if (this.myChange == null) {
            this.buildDiff();
        }
        if (this.myChange == null) {
            return line;
        }
        Diff.Change change = this.myChange;
        int newLine = line;
        while (change != null && line >= change.line0) {
            if (line >= change.line0 + change.deleted) {
                newLine += change.inserted - change.deleted;
            } else {
                return -1;
            }
            change = change.link;
        }
        return newLine;
    }

    private void buildDiff() {
        Object[] strings1 = LineTokenizer.tokenize((CharSequence)this.myOldString, (boolean)false);
        Object[] strings2 = LineTokenizer.tokenize((CharSequence)this.myNewString, (boolean)false);
        this.myChange = Diff.buildChanges((Object[])strings1, (Object[])strings2);
    }

    public int getOptimizedLineShift() {
        if (!this.myOptimizedLineShiftCalculated) {
            this.myOptimizedLineShiftCalculated = true;
            if (this.myOldLength == 0) {
                int lineShift = StringUtil.countNewLines((CharSequence)this.myNewString);
                this.myOptimizedLineShift = lineShift == 0 ? -1 : lineShift;
            }
        }
        return this.myOptimizedLineShift;
    }

    public int getOptimizedOldLineShift() {
        if (!this.myOptimizedOldLineShiftCalculated) {
            this.myOptimizedOldLineShiftCalculated = true;
            if (this.myNewLength == 0) {
                int lineShift = StringUtil.countNewLines((CharSequence)this.myOldString);
                this.myOptimizedOldLineShift = lineShift == 0 ? -1 : lineShift;
            }
        }
        return this.myOptimizedOldLineShift;
    }
}

