/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.FoldingModelImpl;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FoldRegionImpl
extends RangeMarkerImpl
implements FoldRegion {
    private boolean myIsExpanded;
    private final Editor myEditor;
    private final String myPlaceholderText;
    private final FoldingGroup myGroup;

    FoldRegionImpl(@NotNull Editor editor, int startOffset, int endOffset, @NotNull String placeholder, FoldingGroup group) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/FoldRegionImpl.<init> must not be null");
        }
        if (placeholder == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/openapi/editor/impl/FoldRegionImpl.<init> must not be null");
        }
        super((DocumentEx)editor.getDocument(), startOffset, endOffset);
        this.myGroup = group;
        this.myIsExpanded = true;
        this.myEditor = editor;
        this.myPlaceholderText = placeholder;
    }

    public boolean isExpanded() {
        return this.myIsExpanded;
    }

    public void setExpanded(boolean expanded) {
        FoldingModelImpl foldingModel = (FoldingModelImpl)this.myEditor.getFoldingModel();
        if (this.myGroup == null) {
            FoldRegionImpl.doSetExpanded(expanded, foldingModel, this);
        } else {
            for (FoldRegion region : foldingModel.getGroupedRegions(this.myGroup)) {
                FoldRegionImpl.doSetExpanded(expanded, foldingModel, region);
            }
        }
    }

    private static void doSetExpanded(boolean expanded, FoldingModelImpl foldingModel, FoldRegion region) {
        if (expanded) {
            foldingModel.expandFoldRegion(region);
        } else {
            foldingModel.collapseFoldRegion(region);
        }
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.getStartOffset() + 1 < this.getEndOffset();
    }

    public void setExpandedInternal(boolean toExpand) {
        this.myIsExpanded = toExpand;
    }

    @NotNull
    public String getPlaceholderText() {
        String string = this.myPlaceholderText;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/FoldRegionImpl.getPlaceholderText must not return null");
        }
        return string;
    }

    public Editor getEditor() {
        return this.myEditor;
    }

    @Nullable
    public FoldingGroup getGroup() {
        return this.myGroup;
    }

    @Override
    public String toString() {
        return "FoldRegion " + (this.isExpanded() ? "-" : "+") + "(" + this.getStartOffset() + ":" + this.getEndOffset() + ")";
    }
}

