/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerAdapter;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.FocusWatcher;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.FocusTrackback;
import com.intellij.util.ImageLoader;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.RootPaneContainer;
import org.jetbrains.annotations.NonNls;

public class FrameWrapper
implements Disposable {
    private String myDimensionKey = null;
    private JComponent myComponent = null;
    private JComponent myPreferedFocus = null;
    private String myTitle = "";
    private Image myImage = ImageLoader.loadFromResource((String)ApplicationInfoImpl.getShadowInstance().getIconUrl());
    private boolean myCloseOnEsc = false;
    private JFrame myFrame;
    private final Map<String, Object> myDatas = new HashMap();
    private Project myProject;
    private final ProjectManagerListener myProjectListener = new MyProjectManagerListener();
    private FocusTrackback myFocusTrackback;
    private FocusWatcher myFocusWatcher;
    private ActionCallback myFocusedCallback;

    public FrameWrapper(@NonNls String dimensionServiceKey) {
        this.myDimensionKey = dimensionServiceKey;
    }

    public void setDimensionKey(String dimensionKey) {
        this.myDimensionKey = dimensionKey;
    }

    public void setData(String dataId, Object data) {
        this.myDatas.put(dataId, data);
    }

    public void setProject(Project project) {
        this.myProject = project;
        this.setData(PlatformDataKeys.PROJECT.getName(), project);
        ProjectManager.getInstance().addProjectManagerListener(project, this.myProjectListener);
    }

    public void show() {
        this.myFocusedCallback = new ActionCallback();
        if (this.myProject != null) {
            IdeFocusManager.getInstance((Project)this.myProject).suspendKeyProcessingUntil(this.myFocusedCallback);
        }
        JFrame frame = this.getFrame();
        this.myFocusTrackback = new FocusTrackback((Object)this, null, true);
        frame.setDefaultCloseOperation(2);
        WindowAdapter focusListener = new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                if (FrameWrapper.this.myPreferedFocus != null) {
                    FrameWrapper.this.myPreferedFocus.requestFocusInWindow();
                    FrameWrapper.this.myFocusTrackback.registerFocusComponent(FrameWrapper.this.myPreferedFocus);
                }
                FrameWrapper.this.myFocusedCallback.setDone();
            }
        };
        frame.addWindowListener(focusListener);
        if (this.myCloseOnEsc) {
            FrameWrapper.addDisposeOnEsc(frame);
        }
        frame.getContentPane().add((Component)this.myComponent, "Center");
        frame.setTitle(this.myTitle);
        frame.setIconImage(this.myImage);
        FrameWrapper.loadFrameState(this.myDimensionKey, frame);
        this.myFocusWatcher = new FocusWatcher(){

            protected void focusLostImpl(FocusEvent e) {
                FrameWrapper.this.myFocusTrackback.consume();
            }
        };
        this.myFocusWatcher.install((Component)this.myComponent);
        frame.setVisible(true);
    }

    private static <WindowType extends Window> void addDisposeOnEsc(final WindowType frame) {
        ((RootPaneContainer)((Object)frame)).getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
                MenuElement[] selectedPath = menuSelectionManager.getSelectedPath();
                if (selectedPath.length > 0) {
                    menuSelectionManager.clearSelectedPath();
                } else {
                    frame.dispose();
                }
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
    }

    public JFrame getFrame() {
        if (this.myFrame == null) {
            this.myFrame = new MyJFrame();
        }
        return this.myFrame;
    }

    public void setComponent(JComponent component) {
        this.myComponent = component;
    }

    public void setPreferredFocusedComponent(JComponent preferedFocus) {
        this.myPreferedFocus = preferedFocus;
    }

    public void closeOnEsc() {
        this.myCloseOnEsc = true;
    }

    public void setImage(Image image) {
        this.myImage = image;
    }

    private static void loadFrameState(String dimensionKey, JFrame frame) {
        int extendedState;
        Dimension size;
        Point location;
        DimensionService dimensionService = DimensionService.getInstance();
        if (dimensionKey == null || dimensionService == null) {
            location = null;
            size = null;
            extendedState = -1;
        } else {
            location = dimensionService.getLocation(dimensionKey);
            size = dimensionService.getSize(dimensionKey);
            extendedState = dimensionService.getExtendedState(dimensionKey);
        }
        if (size != null) {
            if (location != null) {
                frame.setLocation(location);
            }
            frame.setSize(size);
            frame.getRootPane().revalidate();
        } else {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            frame.pack();
            int height = Math.min(screenSize.height - 40, frame.getHeight());
            int width = Math.min(screenSize.width - 20, frame.getWidth());
            frame.setBounds(10, 10, width, height);
        }
        if (extendedState == 1 || extendedState == 6) {
            frame.setExtendedState(extendedState);
        }
    }

    private static void saveFrameState(String dimensionKey, JFrame frame) {
        DimensionService dimensionService = DimensionService.getInstance();
        if (dimensionKey == null || dimensionService == null) {
            return;
        }
        dimensionService.setLocation(dimensionKey, frame.getLocation());
        dimensionService.setSize(dimensionKey, frame.getSize());
        dimensionService.setExtendedState(dimensionKey, frame.getExtendedState());
    }

    public void setTitle(String title) {
        this.myTitle = title;
    }

    public void addDisposable(Disposable disposable) {
        Disposer.register((Disposable)this, (Disposable)disposable);
    }

    public void dispose() {
    }

    private class MyProjectManagerListener
    extends ProjectManagerAdapter {
        private MyProjectManagerListener() {
        }

        public void projectClosing(Project project) {
            if (project == FrameWrapper.this.myProject) {
                FrameWrapper.this.myFrame.setVisible(false);
                FrameWrapper.this.myFrame.dispose();
            }
        }
    }

    private class MyJFrame
    extends JFrame
    implements DataProvider {
        private boolean myDisposing;

        private MyJFrame() throws HeadlessException {
        }

        @Override
        public void dispose() {
            if (this.myDisposing) {
                return;
            }
            this.myDisposing = true;
            FrameWrapper.saveFrameState(FrameWrapper.this.myDimensionKey, this);
            Disposer.dispose((Disposable)FrameWrapper.this);
            FrameWrapper.this.myDatas.clear();
            if (FrameWrapper.this.myProject != null) {
                ProjectManager.getInstance().removeProjectManagerListener(FrameWrapper.this.myProject, FrameWrapper.this.myProjectListener);
                FrameWrapper.this.myProject = null;
            }
            FrameWrapper.this.myPreferedFocus = null;
            FrameWrapper.this.myFocusTrackback.restoreFocus();
            if (FrameWrapper.this.myComponent != null && FrameWrapper.this.myFocusWatcher != null) {
                FrameWrapper.this.myFocusWatcher.deinstall((Component)FrameWrapper.this.myComponent);
            }
            FrameWrapper.this.myFocusWatcher = null;
            FrameWrapper.this.myFocusedCallback = null;
            super.dispose();
        }

        public Object getData(String dataId) {
            return FrameWrapper.this.myDatas.get(dataId);
        }

        @Override
        public void paint(Graphics g) {
            UIUtil.applyRenderingHints((Graphics)g);
            super.paint(g);
        }
    }
}

