/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lexer;

import com.intellij.lexer.LexerBase;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.CharArrayUtil;

public class PrefixSuffixStripperLexer
extends LexerBase {
    private CharSequence myBuffer;
    private char[] myBufferArray;
    private int myTokenStart;
    private int myTokenEnd;
    private IElementType myTokenType;
    private int myState;
    private int myBufferEnd;
    private final String myPrefix;
    private final IElementType myPrefixType;
    private final String mySuffix;
    private final IElementType myMiddleTokenType;
    private final IElementType mySuffixType;

    public PrefixSuffixStripperLexer(String prefix, IElementType prefixType, String suffix, IElementType suffixType, IElementType middleTokenType) {
        this.mySuffixType = suffixType;
        this.myMiddleTokenType = middleTokenType;
        this.mySuffix = suffix;
        this.myPrefixType = prefixType;
        this.myPrefix = prefix;
    }

    public void start(CharSequence buffer, int startOffset, int endOffset, int initialState) {
        this.myBuffer = buffer;
        this.myBufferArray = CharArrayUtil.fromSequenceWithoutCopying((CharSequence)buffer);
        this.myTokenStart = startOffset;
        this.myTokenEnd = startOffset;
        this.myTokenType = null;
        this.myState = initialState;
        this.myBufferEnd = endOffset;
    }

    public IElementType getTokenType() {
        this.locateToken();
        return this.myTokenType;
    }

    public int getTokenStart() {
        this.locateToken();
        return this.myTokenStart;
    }

    public int getTokenEnd() {
        this.locateToken();
        return this.myTokenEnd;
    }

    public int getState() {
        return this.myState;
    }

    public int getBufferEnd() {
        return this.myBufferEnd;
    }

    public CharSequence getBufferSequence() {
        return this.myBuffer;
    }

    public void advance() {
        this.myTokenType = null;
    }

    private void locateToken() {
        if (this.myTokenType != null || this.myState == 3) {
            return;
        }
        if (this.myState == 0) {
            this.myTokenEnd = this.myTokenStart + this.myPrefix.length();
            this.myTokenType = this.myPrefixType;
            this.myState = this.myTokenEnd < this.myBufferEnd ? 1 : 3;
            return;
        }
        if (this.myState == 1) {
            this.myTokenStart = this.myTokenEnd;
            int suffixStart = this.myBufferEnd - this.mySuffix.length();
            this.myTokenType = this.myMiddleTokenType;
            if (this.myBufferArray != null && CharArrayUtil.regionMatches((char[])this.myBufferArray, (int)suffixStart, (int)this.myBufferEnd, (CharSequence)this.mySuffix) || this.myBufferArray == null && CharArrayUtil.regionMatches((CharSequence)this.myBuffer, (int)suffixStart, (int)this.myBufferEnd, (CharSequence)this.mySuffix)) {
                this.myTokenEnd = suffixStart;
                if (this.myTokenStart < this.myTokenEnd) {
                    this.myState = 2;
                } else {
                    this.myState = 3;
                    this.myTokenType = this.mySuffixType;
                    this.myTokenEnd = this.myBufferEnd;
                }
            } else {
                this.myTokenEnd = this.myBufferEnd;
                this.myState = 3;
            }
            return;
        }
        if (this.myState == 2) {
            this.myTokenStart = this.myTokenEnd;
            this.myTokenEnd = this.myBufferEnd;
            this.myTokenType = this.mySuffixType;
            this.myState = 3;
        }
    }
}

