/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.scopeChooser;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.scopeChooser.ScopeChooserConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import javax.swing.Icon;

public class EditScopesDialog
extends SingleConfigurableEditor {
    private NamedScope mySelectedScope;
    private final boolean myCheckShared;

    public EditScopesDialog(Project project, boolean checkShared) {
        super(project, (Configurable)ScopeChooserConfigurable.getInstance(project), "scopes");
        this.myCheckShared = checkShared;
    }

    @Override
    protected void doOKAction() {
        String newName;
        Project project;
        DependencyValidationManager manager;
        NamedScope scope;
        Object selectedObject = ((ScopeChooserConfigurable)this.getConfigurable()).getSelectedObject();
        if (selectedObject instanceof NamedScope) {
            this.mySelectedScope = (NamedScope)selectedObject;
        }
        super.doOKAction();
        if (this.myCheckShared && this.mySelectedScope != null && (scope = (manager = DependencyValidationManager.getInstance((Project)(project = this.getProject()))).getScope(this.mySelectedScope.getName())) == null && Messages.showYesNoDialog((String)IdeBundle.message((String)"scope.unable.to.save.scope.message", (Object[])new Object[0]), (String)IdeBundle.message((String)"scope.unable.to.save.scope.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon()) == 0 && (newName = Messages.showInputDialog((Project)project, (String)IdeBundle.message((String)"add.scope.name.label", (Object[])new Object[0]), (String)IdeBundle.message((String)"scopes.save.dialog.title.shared", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), (String)this.mySelectedScope.getName(), (InputValidator)new InputValidator(){

            public boolean checkInput(String inputString) {
                return inputString != null && inputString.length() > 0 && manager.getScope(inputString) == null;
            }

            public boolean canClose(String inputString) {
                return this.checkInput(inputString);
            }
        })) != null) {
            PackageSet packageSet = this.mySelectedScope.getValue();
            this.mySelectedScope = scope = new NamedScope(newName, packageSet != null ? packageSet.createCopy() : null);
            manager.addScope(this.mySelectedScope);
        }
    }

    public static EditScopesDialog editConfigurable(Project project, Runnable advancedInitialization) {
        return EditScopesDialog.editConfigurable(project, advancedInitialization, false);
    }

    public static EditScopesDialog editConfigurable(Project project, Runnable advancedInitialization, boolean checkShared) {
        EditScopesDialog dialog = new EditScopesDialog(project, checkShared);
        if (advancedInitialization != null) {
            advancedInitialization.run();
        }
        dialog.show();
        return dialog;
    }

    public NamedScope getSelectedScope() {
        return this.mySelectedScope;
    }
}

