/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.frameworkSupport;

import com.intellij.CommonBundle;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportProvider;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportUtil;
import com.intellij.ide.util.newProjectWizard.AddSupportForFrameworksPanel;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainerFactory;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Component;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddFrameworkSupportDialog
extends DialogWrapper {
    private final AddSupportForFrameworksPanel myAddSupportPanel;
    private final Module myModule;

    private AddFrameworkSupportDialog(@NotNull Module module, final String contentRootPath, List<FrameworkSupportProvider> providers) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/util/frameworkSupport/AddFrameworkSupportDialog.<init> must not be null");
        }
        super(module.getProject(), true);
        this.setTitle(ProjectBundle.message((String)"dialog.title.add.frameworks.support", (Object[])new Object[0]));
        this.myModule = module;
        this.myAddSupportPanel = new AddSupportForFrameworksPanel(providers, LibrariesContainerFactory.createContainer(module.getProject()), null, new Computable<String>(){

            public String compute() {
                return contentRootPath;
            }
        });
        this.init();
    }

    @Nullable
    public static AddFrameworkSupportDialog createDialog(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/util/frameworkSupport/AddFrameworkSupportDialog.createDialog must not be null");
        }
        VirtualFile[] roots = ModuleRootManager.getInstance((Module)module).getContentRoots();
        if (roots.length == 0) {
            return null;
        }
        List<FrameworkSupportProvider> providers = FrameworkSupportUtil.getProviders(module);
        if (providers.isEmpty()) {
            return null;
        }
        return new AddFrameworkSupportDialog(module, roots[0].getPath(), providers);
    }

    public static boolean isAvailable(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/util/frameworkSupport/AddFrameworkSupportDialog.isAvailable must not be null");
        }
        VirtualFile[] roots = ModuleRootManager.getInstance((Module)module).getContentRoots();
        return roots.length != 0 && FrameworkSupportUtil.hasProviders(module);
    }

    protected void doOKAction() {
        if (this.myAddSupportPanel.haveSelectedFrameworks()) {
            int answer;
            if (!this.myAddSupportPanel.downloadLibraries() && (answer = Messages.showYesNoDialog((Component)this.myAddSupportPanel.getMainPanel(), (String)ProjectBundle.message((String)"warning.message.some.required.libraries.wasn.t.downloaded", (Object[])new Object[0]), (String)CommonBundle.getWarningTitle(), (Icon)Messages.getWarningIcon())) != 0) {
                return;
            }
            new WriteAction(){

                protected void run(Result result) {
                    ModifiableRootModel model = ModuleRootManager.getInstance((Module)AddFrameworkSupportDialog.this.myModule).getModifiableModel();
                    AddFrameworkSupportDialog.this.myAddSupportPanel.addSupport(AddFrameworkSupportDialog.this.myModule, model);
                    model.commit();
                }
            }.execute();
        }
        super.doOKAction();
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.ide.util.frameworkSupport.AddFrameworkSupportDialog";
    }

    protected String getHelpId() {
        return "reference.frameworks.support.dialog";
    }

    protected JComponent createCenterPanel() {
        return this.myAddSupportPanel.getMainPanel();
    }
}

