/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo.configurable;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.todo.TodoConfiguration;
import com.intellij.ide.todo.TodoFilter;
import com.intellij.ide.todo.configurable.FilterDialog;
import com.intellij.ide.todo.configurable.FiltersTableModel;
import com.intellij.ide.todo.configurable.PatternDialog;
import com.intellij.ide.todo.configurable.PatternsTableModel;
import com.intellij.ide.todo.configurable.TodoPatternTableCellRenderer;
import com.intellij.ide.todo.configurable.TodoTypeListCellRenderer;
import com.intellij.ide.todo.configurable.TodoTypeTableCellRenderer;
import com.intellij.openapi.options.BaseConfigurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.util.IconLoader;
import com.intellij.psi.search.TodoAttributes;
import com.intellij.psi.search.TodoPattern;
import com.intellij.ui.PanelWithButtons;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TableUtil;
import com.intellij.util.ui.Table;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.Nullable;

public class TodoConfigurable
extends BaseConfigurable
implements SearchableConfigurable {
    private JPanel myPanel;
    private JTable myPatternsTable;
    private JTable myFiltersTable;
    private JButton myAddPatternButton;
    private JButton myEditPatternButton;
    private JButton myRemovePatternButton;
    private JButton myAddFilterButton;
    private JButton myEditFilterButton;
    private JButton myRemoveFilterButton;
    private final List<TodoPattern> myPatterns = new ArrayList<TodoPattern>();
    private final PatternsTableModel myPatternsModel;
    private final List<TodoFilter> myFilters = new ArrayList<TodoFilter>();
    private final FiltersTableModel myFiltersModel = new FiltersTableModel(this.myFilters);

    public TodoConfigurable() {
        this.myPatternsModel = new PatternsTableModel(this.myPatterns);
    }

    private boolean arePatternsModified() {
        TodoConfiguration todoConfiguration = TodoConfiguration.getInstance();
        TodoPattern[] initialPatterns = todoConfiguration.getTodoPatterns();
        if (initialPatterns.length != this.myPatterns.size()) {
            return true;
        }
        for (int i = 0; i < initialPatterns.length; ++i) {
            TodoPattern initialPattern = initialPatterns[i];
            if (this.myPatterns.contains(initialPattern)) continue;
            return true;
        }
        return false;
    }

    private boolean areFiltersModified() {
        TodoConfiguration todoConfiguration = TodoConfiguration.getInstance();
        TodoFilter[] initialFilters = todoConfiguration.getTodoFilters();
        if (initialFilters.length != this.myFilters.size()) {
            return true;
        }
        for (int i = 0; i < initialFilters.length; ++i) {
            TodoFilter initialFilter = initialFilters[i];
            if (this.myFilters.contains(initialFilter)) continue;
            return true;
        }
        return false;
    }

    public boolean isModified() {
        this.stopEditing();
        return this.arePatternsModified() || this.areFiltersModified();
    }

    public void apply() throws ConfigurationException {
        this.stopEditing();
        if (this.arePatternsModified()) {
            TodoPattern[] patterns = this.myPatterns.toArray(new TodoPattern[this.myPatterns.size()]);
            TodoConfiguration.getInstance().setTodoPatterns(patterns);
        }
        if (this.areFiltersModified()) {
            TodoFilter[] filters = this.myFilters.toArray(new TodoFilter[this.myFilters.size()]);
            TodoConfiguration.getInstance().setTodoFilters(filters);
        }
    }

    public void disposeUIResources() {
        this.myPanel = null;
        this.myPatternsModel.removeTableModelListener(this.myPatternsTable);
        this.myPatternsTable = null;
        this.myAddPatternButton = null;
        this.myEditPatternButton = null;
        this.myRemovePatternButton = null;
        this.myFiltersModel.removeTableModelListener(this.myFiltersTable);
        this.myFiltersTable = null;
        this.myAddFilterButton = null;
        this.myEditFilterButton = null;
        this.myRemoveFilterButton = null;
    }

    public JComponent createComponent() {
        PanelWithButtons patternsPanel = new PanelWithButtons(){
            {
                this.initPanel();
            }

            protected String getLabelText() {
                return IdeBundle.message((String)"label.todo.patterns", (Object[])new Object[0]);
            }

            protected JComponent createMainComponent() {
                TodoConfigurable.this.myPatternsTable = (JTable)new Table((TableModel)TodoConfigurable.this.myPatternsModel);
                TodoConfigurable.this.myPatternsTable.getSelectionModel().setSelectionMode(0);
                JComboBox<Icon> todoTypeCombo = new JComboBox<Icon>(new Icon[]{TodoAttributes.DEFAULT_ICON, TodoAttributes.QUESTION_ICON, TodoAttributes.IMPORTANT_ICON});
                todoTypeCombo.setRenderer(new TodoTypeListCellRenderer());
                TableColumn typeColumn = TodoConfigurable.this.myPatternsTable.getColumnModel().getColumn(0);
                DefaultCellEditor todoTypeEditor = new DefaultCellEditor(todoTypeCombo);
                todoTypeEditor.setClickCountToStart(1);
                typeColumn.setCellEditor(todoTypeEditor);
                TodoTypeTableCellRenderer todoTypeRenderer = new TodoTypeTableCellRenderer();
                typeColumn.setCellRenderer(todoTypeRenderer);
                int width = TodoConfigurable.this.myPatternsTable.getFontMetrics(TodoConfigurable.this.myPatternsTable.getFont()).stringWidth(TodoConfigurable.this.myPatternsTable.getColumnName(0)) + 10;
                typeColumn.setPreferredWidth(width);
                typeColumn.setMaxWidth(width);
                typeColumn.setMinWidth(width);
                TableColumn todoCaseSensitiveColumn = TodoConfigurable.this.myPatternsTable.getColumnModel().getColumn(1);
                width = TodoConfigurable.this.myPatternsTable.getFontMetrics(TodoConfigurable.this.myPatternsTable.getFont()).stringWidth(TodoConfigurable.this.myPatternsTable.getColumnName(1)) + 10;
                todoCaseSensitiveColumn.setPreferredWidth(width);
                todoCaseSensitiveColumn.setMaxWidth(width);
                todoCaseSensitiveColumn.setMinWidth(width);
                TodoPatternTableCellRenderer todoPatternRenderer = new TodoPatternTableCellRenderer(TodoConfigurable.this.myPatterns);
                TableColumn patternColumn = TodoConfigurable.this.myPatternsTable.getColumnModel().getColumn(2);
                patternColumn.setCellRenderer(todoPatternRenderer);
                ((DefaultCellEditor)TodoConfigurable.this.myPatternsTable.getDefaultEditor(String.class)).setClickCountToStart(2);
                JScrollPane myPatternsScroll = ScrollPaneFactory.createScrollPane((JComponent)TodoConfigurable.this.myPatternsTable);
                myPatternsScroll.setPreferredSize(new Dimension(-1, TodoConfigurable.this.myPatternsTable.getRowHeight() * 12));
                return myPatternsScroll;
            }

            protected JButton[] createButtons() {
                TodoConfigurable.this.myAddPatternButton = new JButton(IdeBundle.message((String)"button.add", (Object[])new Object[0]));
                TodoConfigurable.this.myAddPatternButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TodoConfigurable.this.stopEditing();
                        TodoPattern pattern = new TodoPattern();
                        PatternDialog dialog = new PatternDialog(TodoConfigurable.this.myPanel, pattern);
                        dialog.setTitle(IdeBundle.message((String)"title.add.todo.pattern", (Object[])new Object[0]));
                        dialog.show();
                        if (!dialog.isOK()) {
                            return;
                        }
                        TodoConfigurable.this.myPatterns.add(pattern);
                        int index = TodoConfigurable.this.myPatterns.size() - 1;
                        TodoConfigurable.this.myPatternsModel.fireTableRowsInserted(index, index);
                        TodoConfigurable.this.myPatternsTable.getSelectionModel().setSelectionInterval(index, index);
                        TodoConfigurable.this.myPatternsTable.scrollRectToVisible(TodoConfigurable.this.myPatternsTable.getCellRect(index, 0, true));
                    }
                });
                TodoConfigurable.this.myEditPatternButton = new JButton(IdeBundle.message((String)"button.edit", (Object[])new Object[0]));
                TodoConfigurable.this.myEditPatternButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TodoConfigurable.this.editSelectedPattern();
                    }
                });
                TodoConfigurable.this.myRemovePatternButton = new JButton(IdeBundle.message((String)"button.remove", (Object[])new Object[0]));
                TodoConfigurable.this.myRemovePatternButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TodoConfigurable.this.stopEditing();
                        int selectedIndex = TodoConfigurable.this.myPatternsTable.getSelectedRow();
                        if (selectedIndex < 0 || selectedIndex >= TodoConfigurable.this.myPatternsModel.getRowCount()) {
                            return;
                        }
                        TodoPattern patternToBeRemoved = (TodoPattern)TodoConfigurable.this.myPatterns.get(selectedIndex);
                        TableUtil.removeSelectedItems((JTable)TodoConfigurable.this.myPatternsTable);
                        for (int i = 0; i < TodoConfigurable.this.myFilters.size(); ++i) {
                            TodoFilter filter = (TodoFilter)TodoConfigurable.this.myFilters.get(i);
                            if (!filter.contains(patternToBeRemoved)) continue;
                            filter.removeTodoPattern(patternToBeRemoved);
                            TodoConfigurable.this.myFiltersModel.fireTableRowsUpdated(i, i);
                        }
                    }
                });
                return new JButton[]{TodoConfigurable.this.myAddPatternButton, TodoConfigurable.this.myEditPatternButton, TodoConfigurable.this.myRemovePatternButton};
            }
        };
        this.myPatternsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    TodoConfigurable.this.editSelectedPattern();
                }
            }
        });
        this.myPatternsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                TodoConfigurable.this.updateButtonsState();
            }
        });
        PanelWithButtons filtersPanel = new PanelWithButtons(){
            {
                this.initPanel();
            }

            protected String getLabelText() {
                return IdeBundle.message((String)"label.todo.filters", (Object[])new Object[0]);
            }

            protected JComponent createMainComponent() {
                TodoConfigurable.this.myFiltersTable = (JTable)new Table((TableModel)TodoConfigurable.this.myFiltersModel);
                TodoConfigurable.this.myFiltersTable.getSelectionModel().setSelectionMode(0);
                JScrollPane myFiltersScroll = ScrollPaneFactory.createScrollPane((JComponent)TodoConfigurable.this.myFiltersTable);
                myFiltersScroll.setPreferredSize(new Dimension(-1, TodoConfigurable.this.myPatternsTable.getRowHeight() * 12));
                TableColumn nameColumn = TodoConfigurable.this.myFiltersTable.getColumnModel().getColumn(0);
                int width = TodoConfigurable.this.myPatternsTable.getColumnModel().getColumn(0).getPreferredWidth() + TodoConfigurable.this.myPatternsTable.getColumnModel().getColumn(1).getPreferredWidth();
                nameColumn.setPreferredWidth(width);
                nameColumn.setMaxWidth(width);
                nameColumn.setMinWidth(width);
                nameColumn.setCellRenderer(new MyFilterNameTableCellRenderer());
                return myFiltersScroll;
            }

            protected JButton[] createButtons() {
                TodoConfigurable.this.myAddFilterButton = new JButton(IdeBundle.message((String)"button.add.d", (Object[])new Object[0]));
                TodoConfigurable.this.myAddFilterButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TodoConfigurable.this.stopEditing();
                        TodoFilter filter = new TodoFilter();
                        FilterDialog dialog = new FilterDialog(TodoConfigurable.this.myPanel, filter, -1, TodoConfigurable.this.myFilters, TodoConfigurable.this.myPatterns);
                        dialog.setTitle(IdeBundle.message((String)"title.add.todo.filter", (Object[])new Object[0]));
                        dialog.show();
                        int exitCode = dialog.getExitCode();
                        if (0 == exitCode) {
                            TodoConfigurable.this.myFilters.add(filter);
                            int index = TodoConfigurable.this.myFilters.size() - 1;
                            TodoConfigurable.this.myFiltersModel.fireTableRowsInserted(index, index);
                            TodoConfigurable.this.myFiltersTable.getSelectionModel().setSelectionInterval(index, index);
                            TodoConfigurable.this.myFiltersTable.scrollRectToVisible(TodoConfigurable.this.myFiltersTable.getCellRect(index, 0, true));
                        }
                    }
                });
                TodoConfigurable.this.myEditFilterButton = new JButton(IdeBundle.message((String)"button.edit.t", (Object[])new Object[0]));
                TodoConfigurable.this.myEditFilterButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TodoConfigurable.this.editSelectedFilter();
                    }
                });
                TodoConfigurable.this.myRemoveFilterButton = new JButton(IdeBundle.message((String)"button.remove.m", (Object[])new Object[0]));
                TodoConfigurable.this.myRemoveFilterButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TodoConfigurable.this.stopEditing();
                        TableUtil.removeSelectedItems((JTable)TodoConfigurable.this.myFiltersTable);
                    }
                });
                return new JButton[]{TodoConfigurable.this.myAddFilterButton, TodoConfigurable.this.myEditFilterButton, TodoConfigurable.this.myRemoveFilterButton};
            }
        };
        this.myFiltersTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    TodoConfigurable.this.editSelectedFilter();
                }
            }
        });
        this.myFiltersTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                TodoConfigurable.this.updateButtonsState();
            }
        });
        this.myPanel = new JPanel(new GridBagLayout());
        this.myPanel.add((Component)patternsPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(5, 2, 4, 2), 0, 0));
        this.myPanel.add((Component)filtersPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 2, new Insets(5, 2, 4, 2), 0, 0));
        this.myPanel.setPreferredSize(new Dimension(Math.max(700, this.myPanel.getPreferredSize().width), this.myPanel.getPreferredSize().height));
        return this.myPanel;
    }

    private void editSelectedPattern() {
        this.stopEditing();
        int selectedIndex = this.myPatternsTable.getSelectedRow();
        if (selectedIndex < 0 || selectedIndex >= this.myPatternsModel.getRowCount()) {
            return;
        }
        TodoPattern sourcePattern = this.myPatterns.get(selectedIndex);
        TodoPattern pattern = sourcePattern.clone();
        PatternDialog dialog = new PatternDialog(this.myPanel, pattern);
        dialog.setTitle(IdeBundle.message((String)"title.edit.todo.pattern", (Object[])new Object[0]));
        dialog.show();
        if (!dialog.isOK()) {
            return;
        }
        this.myPatterns.set(selectedIndex, pattern);
        this.myPatternsModel.fireTableRowsUpdated(selectedIndex, selectedIndex);
        this.myPatternsTable.getSelectionModel().setSelectionInterval(selectedIndex, selectedIndex);
        for (int i = 0; i < this.myFilters.size(); ++i) {
            TodoFilter filter = this.myFilters.get(i);
            if (!filter.contains(sourcePattern)) continue;
            filter.removeTodoPattern(sourcePattern);
            filter.addTodoPattern(pattern);
            this.myFiltersModel.fireTableRowsUpdated(i, i);
        }
    }

    private void editSelectedFilter() {
        this.stopEditing();
        int selectedIndex = this.myFiltersTable.getSelectedRow();
        if (selectedIndex < 0 || selectedIndex >= this.myFiltersModel.getRowCount()) {
            return;
        }
        TodoFilter sourceFilter = this.myFilters.get(selectedIndex);
        TodoFilter filter = sourceFilter.clone();
        FilterDialog dialog = new FilterDialog(this.myPanel, filter, selectedIndex, this.myFilters, this.myPatterns);
        dialog.setTitle(IdeBundle.message((String)"title.edit.todo.filter", (Object[])new Object[0]));
        dialog.show();
        int exitCode = dialog.getExitCode();
        if (0 == exitCode) {
            this.myFilters.set(selectedIndex, filter);
            this.myFiltersModel.fireTableRowsUpdated(selectedIndex, selectedIndex);
            this.myFiltersTable.getSelectionModel().setSelectionInterval(selectedIndex, selectedIndex);
        }
    }

    private void stopEditing() {
        TableCellEditor editor;
        if (this.myPatternsTable.isEditing() && (editor = this.myPatternsTable.getCellEditor()) != null) {
            editor.stopCellEditing();
        }
        if (this.myFiltersTable.isEditing() && (editor = this.myFiltersTable.getCellEditor()) != null) {
            editor.stopCellEditing();
        }
    }

    private void updateButtonsState() {
        int selectedPatternIndex = this.myPatternsTable.getSelectedRow();
        this.myEditPatternButton.setEnabled(selectedPatternIndex != -1);
        this.myRemovePatternButton.setEnabled(selectedPatternIndex != -1);
        int selectedFilterIndex = this.myFiltersTable.getSelectedRow();
        this.myEditFilterButton.setEnabled(selectedFilterIndex != -1);
        this.myRemoveFilterButton.setEnabled(selectedFilterIndex != -1);
    }

    public String getDisplayName() {
        return IdeBundle.message((String)"title.todo", (Object[])new Object[0]);
    }

    public String getHelpTopic() {
        return "preferences.toDoOptions";
    }

    public Icon getIcon() {
        return IconLoader.getIcon((String)"/general/configurableTodo.png");
    }

    public void reset() {
        this.myPatterns.clear();
        TodoConfiguration todoConfiguration = TodoConfiguration.getInstance();
        TodoPattern[] patterns = todoConfiguration.getTodoPatterns();
        for (int i = 0; i < patterns.length; ++i) {
            this.myPatterns.add(patterns[i].clone());
        }
        this.myPatternsModel.fireTableDataChanged();
        this.myFilters.clear();
        TodoFilter[] filters = todoConfiguration.getTodoFilters();
        for (int i = 0; i < filters.length; ++i) {
            this.myFilters.add(filters[i].clone());
        }
        this.myFiltersModel.fireTableDataChanged();
        this.updateButtonsState();
    }

    public static TodoConfigurable getInstance() {
        return (TodoConfigurable)ShowSettingsUtil.getInstance().findApplicationConfigurable(TodoConfigurable.class);
    }

    public String getId() {
        return this.getHelpTopic();
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return null;
    }

    private final class MyFilterNameTableCellRenderer
    extends DefaultTableCellRenderer {
        private MyFilterNameTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            TodoFilter filter = (TodoFilter)TodoConfigurable.this.myFilters.get(row);
            if (isSelected) {
                this.setForeground(UIUtil.getTableSelectionForeground());
            } else if (filter.isEmpty()) {
                this.setForeground(Color.RED);
            } else {
                this.setForeground(UIUtil.getTableForeground());
            }
            return this;
        }
    }
}

