/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.AbstractModuleNode;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class ProjectViewModuleNode
extends AbstractModuleNode {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.projectView.impl.nodes.ProjectViewModuleNode");

    public ProjectViewModuleNode(Project project, Module value, ViewSettings viewSettings) {
        super(project, value, viewSettings);
    }

    public ProjectViewModuleNode(Project project, Object value, ViewSettings viewSettings) {
        this(project, (Module)value, viewSettings);
    }

    @NotNull
    public Collection<AbstractTreeNode> getChildren() {
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)((Module)this.getValue()));
        ModuleFileIndex moduleFileIndex = rootManager.getFileIndex();
        VirtualFile[] contentRoots = rootManager.getContentRoots();
        ArrayList<AbstractTreeNode> children = new ArrayList<AbstractTreeNode>(contentRoots.length + 1);
        PsiManager psiManager = PsiManager.getInstance((Project)this.getProject());
        for (VirtualFile contentRoot : contentRoots) {
            LOG.assertTrue(contentRoot.isDirectory());
            if (!moduleFileIndex.isInContent(contentRoot)) continue;
            PsiDirectory psiDirectory = psiManager.findDirectory(contentRoot);
            LOG.assertTrue(psiDirectory != null);
            PsiDirectoryNode directoryNode = new PsiDirectoryNode(this.getProject(), psiDirectory, this.getSettings());
            children.add((AbstractTreeNode)directoryNode);
        }
        ArrayList<AbstractTreeNode> arrayList = children;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/projectView/impl/nodes/ProjectViewModuleNode.getChildren must not return null");
        }
        return arrayList;
    }

    public int getWeight() {
        return 10;
    }

    public int getTypeSortWeight(boolean sortByType) {
        return 2;
    }
}

