/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginTableModel;
import com.intellij.ui.TableUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.Table;
import java.awt.FontMetrics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class PluginTable
extends Table {
    public PluginTable(PluginTableModel model) {
        super((TableModel)model);
        this.initializeHeader(model);
        for (int i = 0; i < model.getColumnCount(); ++i) {
            TableColumn column = this.getColumnModel().getColumn(i);
            ColumnInfo columnInfo = model.getColumnInfos()[i];
            column.setCellEditor(columnInfo.getEditor(null));
            if (columnInfo.getColumnClass() != Boolean.class) continue;
            String name = columnInfo.getName();
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int width = fontMetrics.stringWidth(" " + name + " ") + 10;
            column.setWidth(width);
            column.setPreferredWidth(width);
            column.setMaxWidth(width);
            column.setMinWidth(width);
        }
        this.setSelectionMode(2);
        this.setShowGrid(false);
    }

    public void setColumnWidth(int columnIndex, int width) {
        TableColumn column = this.getColumnModel().getColumn(columnIndex);
        column.setMinWidth(width);
        column.setMaxWidth(width);
    }

    public void setValueAt(Object aValue, int row, int column) {
        super.setValueAt(aValue, row, column);
        this.repaint();
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        ColumnInfo columnInfo = ((PluginTableModel)this.getModel()).getColumnInfos()[column];
        return columnInfo.getRenderer((Object)((PluginTableModel)this.getModel()).getObjectAt(row));
    }

    private void initializeHeader(final PluginTableModel model) {
        final JTableHeader header = this.getTableHeader();
        header.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int column = PluginTable.this.getTableHeader().getColumnModel().getColumnIndexAtX(e.getX());
                if (model.sortableProvider.getSortColumn() == column) {
                    if (model.sortableProvider.getSortOrder() == 2) {
                        model.sortableProvider.setSortOrder(1);
                    } else {
                        model.sortableProvider.setSortOrder(2);
                    }
                } else {
                    model.sortableProvider.setSortOrder(1);
                    model.sortableProvider.setSortColumn(column);
                }
                IdeaPluginDescriptor[] selectedObjects = PluginTable.this.getSelectedObjects();
                model.sortByColumn(column);
                if (selectedObjects != null) {
                    PluginTable.this.select(selectedObjects);
                }
                header.repaint();
            }
        });
        header.setReorderingAllowed(false);
    }

    public Object[] getElements() {
        return ((PluginTableModel)this.getModel()).view.toArray();
    }

    public IdeaPluginDescriptor getObjectAt(int row) {
        return ((PluginTableModel)this.getModel()).getObjectAt(row);
    }

    public void select(IdeaPluginDescriptor ... descriptors) {
        PluginTableModel tableModel = (PluginTableModel)this.getModel();
        this.getSelectionModel().clearSelection();
        for (int i = 0; i < tableModel.getRowCount(); ++i) {
            IdeaPluginDescriptor descriptorAt = tableModel.getObjectAt(i);
            if (ArrayUtil.find((Object[])descriptors, (Object)descriptorAt) == -1) continue;
            this.getSelectionModel().addSelectionInterval(i, i);
        }
        TableUtil.scrollSelectionToVisible((JTable)((Object)this));
    }

    public IdeaPluginDescriptor getSelectedObject() {
        IdeaPluginDescriptor selected = null;
        if (this.getSelectedRowCount() > 0) {
            selected = this.getObjectAt(this.getSelectedRow());
        }
        return selected;
    }

    public IdeaPluginDescriptor[] getSelectedObjects() {
        IdeaPluginDescriptor[] selection = null;
        if (this.getSelectedRowCount() > 0) {
            int[] poses = this.getSelectedRows();
            selection = new IdeaPluginDescriptor[poses.length];
            for (int i = 0; i < poses.length; ++i) {
                selection[i] = this.getObjectAt(poses[i]);
            }
        }
        return selection;
    }
}

