/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerColumnInfo;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.PluginTableModel;
import com.intellij.ide.plugins.SortableProvider;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AvailablePluginsTableModel
extends PluginTableModel {
    private final Map<PluginId, String> myUpdateVersions = new HashMap<PluginId, String>();

    public AvailablePluginsTableModel(SortableProvider sortableProvider) {
        super(sortableProvider, new PluginManagerColumnInfo(0, sortableProvider), new PluginManagerColumnInfo(1, sortableProvider), new PluginManagerColumnInfo(2, sortableProvider){

            @Override
            protected int getHorizontalAlignment() {
                return 11;
            }
        }, new PluginManagerColumnInfo(3, sortableProvider));
        this.view = new ArrayList();
        this.sortByColumn(this.getNameColumn());
    }

    @Override
    public void addData(List<IdeaPluginDescriptor> list) {
        this.view.clear();
        for (IdeaPluginDescriptor descr : list) {
            AvailablePluginsTableModel.updateStatus(descr);
            this.view.add(descr);
            this.myUpdateVersions.put(descr.getPluginId(), descr.getVersion());
        }
        this.safeSort();
    }

    private static void updateStatus(IdeaPluginDescriptor descr) {
        if (descr instanceof PluginNode) {
            PluginNode node = (PluginNode)descr;
            IdeaPluginDescriptor existing = PluginManager.getPlugin((PluginId)descr.getPluginId());
            if (existing != null) {
                node.setStatus(1);
            }
        }
    }

    @Override
    public void modifyData(List<IdeaPluginDescriptor> list) {
        for (IdeaPluginDescriptor descr : list) {
            AvailablePluginsTableModel.updateStatus(descr);
            PluginId descrId = descr.getPluginId();
            if (this.myUpdateVersions.containsKey(descrId)) {
                String currVersion = this.myUpdateVersions.get(descrId);
                int state = StringUtil.compareVersionNumbers((String)descr.getVersion(), (String)currVersion);
                if (state <= 0) continue;
                for (int i = 0; i < this.view.size(); ++i) {
                    IdeaPluginDescriptor obsolete = (IdeaPluginDescriptor)this.view.get(i);
                    if (obsolete.getPluginId() != descrId) continue;
                    this.view.remove(obsolete);
                }
                this.view.add(descr);
                continue;
            }
            this.view.add(descr);
            this.myUpdateVersions.put(descr.getPluginId(), descr.getVersion());
        }
        this.safeSort();
    }

    @Override
    public void filter(ArrayList<IdeaPluginDescriptor> filtered) {
        this.view.clear();
        for (IdeaPluginDescriptor descriptor : filtered) {
            this.view.add(descriptor);
        }
        super.filter(filtered);
    }

    @Override
    public int getNameColumn() {
        return 0;
    }
}

