/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.CreateFileFromTemplateDialog;
import com.intellij.ide.actions.CreateTemplateInPackageAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.util.Icons;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class CreateClassAction
extends CreateTemplateInPackageAction<PsiClass> {
    public CreateClassAction() {
        super(IdeBundle.message((String)"action.create.new.class", (Object[])new Object[0]), IdeBundle.message((String)"action.create.new.class", (Object[])new Object[0]), Icons.CLASS_ICON, true);
    }

    @Override
    @NotNull
    protected CreateFileFromTemplateDialog.Builder buildDialog(Project project, PsiDirectory directory) {
        CreateFileFromTemplateDialog.Builder builder = CreateFileFromTemplateDialog.createDialog(project, IdeBundle.message((String)"action.create.new.class", (Object[])new Object[0]));
        builder.addKind("Class", Icons.CLASS_ICON, "Class");
        builder.addKind("Interface", Icons.INTERFACE_ICON, "Interface");
        if (LanguageLevelProjectExtension.getInstance((Project)project).getLanguageLevel().compareTo((Enum)LanguageLevel.JDK_1_5) >= 0) {
            builder.addKind("Enum", Icons.ENUM_ICON, "Enum");
            builder.addKind("Annotation", Icons.ANNOTATION_TYPE_ICON, "AnnotationType");
        }
        CreateFileFromTemplateDialog.Builder builder2 = builder;
        if (builder2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/actions/CreateClassAction.buildDialog must not return null");
        }
        return builder2;
    }

    @Override
    protected String getErrorTitle() {
        return IdeBundle.message((String)"title.cannot.create.class", (Object[])new Object[0]);
    }

    @Override
    protected String getActionName(PsiDirectory directory, String newName, String templateName) {
        return IdeBundle.message((String)"progress.creating.class", (Object[])new Object[]{JavaDirectoryService.getInstance().getPackage(directory).getQualifiedName(), newName});
    }

    @Override
    protected final PsiClass doCreate(PsiDirectory dir, String className, String templateName) throws IncorrectOperationException {
        return JavaDirectoryService.getInstance().createClass(dir, className, templateName);
    }

    @Override
    protected PsiElement getNavigationElement(@NotNull PsiClass createdElement) {
        if (createdElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/actions/CreateClassAction.getNavigationElement must not be null");
        }
        return createdElement.getLBrace();
    }

    @Override
    protected void doCheckCreate(PsiDirectory dir, String className, String templateName) throws IncorrectOperationException {
        JavaDirectoryService.getInstance().checkCreateClass(dir, className);
    }
}

