/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.find.findUsages.AbstractFindUsagesDialog;
import com.intellij.find.findUsages.CommonFindUsagesDialog;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.refactoring.util.TextOccurrencesUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Processor;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public abstract class FindUsagesHandler {
    public static final FindUsagesHandler NULL_HANDLER = new FindUsagesHandler(PsiUtilBase.NULL_PSI_ELEMENT){};
    private final PsiElement myPsiElement;

    protected FindUsagesHandler(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/find/findUsages/FindUsagesHandler.<init> must not be null");
        }
        this.myPsiElement = psiElement;
    }

    @NotNull
    public AbstractFindUsagesDialog getFindUsagesDialog(boolean isSingleFile, boolean toShowInNewTab, boolean mustOpenInNewTab) {
        CommonFindUsagesDialog commonFindUsagesDialog = new CommonFindUsagesDialog(this.myPsiElement, this.getProject(), this.getFindUsagesOptions(), toShowInNewTab, mustOpenInNewTab, isSingleFile, this);
        if (commonFindUsagesDialog == null) {
            throw new IllegalStateException("@NotNull method com/intellij/find/findUsages/FindUsagesHandler.getFindUsagesDialog must not return null");
        }
        return commonFindUsagesDialog;
    }

    public final PsiElement getPsiElement() {
        return this.myPsiElement;
    }

    @NotNull
    public final Project getProject() {
        Project project = this.myPsiElement.getProject();
        if (project == null) {
            throw new IllegalStateException("@NotNull method com/intellij/find/findUsages/FindUsagesHandler.getProject must not return null");
        }
        return project;
    }

    @NotNull
    public PsiElement[] getPrimaryElements() {
        PsiElement[] psiElementArray = new PsiElement[]{this.myPsiElement};
        if (psiElementArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/find/findUsages/FindUsagesHandler.getPrimaryElements must not return null");
        }
        return psiElementArray;
    }

    @NotNull
    public PsiElement[] getSecondaryElements() {
        if (PsiElement.EMPTY_ARRAY == null) {
            throw new IllegalStateException("@NotNull method com/intellij/find/findUsages/FindUsagesHandler.getSecondaryElements must not return null");
        }
        return PsiElement.EMPTY_ARRAY;
    }

    public static FindUsagesOptions createFindUsagesOptions(Project project) {
        FindUsagesOptions findUsagesOptions = new FindUsagesOptions(project, null);
        findUsagesOptions.isUsages = true;
        findUsagesOptions.isIncludeOverloadUsages = false;
        findUsagesOptions.isIncludeSubpackages = true;
        findUsagesOptions.isReadAccess = true;
        findUsagesOptions.isWriteAccess = true;
        findUsagesOptions.isCheckDeepInheritance = true;
        findUsagesOptions.isSearchForTextOccurences = true;
        return findUsagesOptions;
    }

    @NotNull
    public FindUsagesOptions getFindUsagesOptions() {
        FindUsagesOptions options = FindUsagesHandler.createFindUsagesOptions(this.getProject());
        options.isSearchForTextOccurences &= this.isSearchForTextOccurencesAvailable(this.getPsiElement(), false);
        FindUsagesOptions findUsagesOptions = options;
        if (findUsagesOptions == null) {
            throw new IllegalStateException("@NotNull method com/intellij/find/findUsages/FindUsagesHandler.getFindUsagesOptions must not return null");
        }
        return findUsagesOptions;
    }

    public void processElementUsages(@NotNull PsiElement element, final @NotNull Processor<UsageInfo> processor, @NotNull FindUsagesOptions options) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/find/findUsages/FindUsagesHandler.processElementUsages must not be null");
        }
        if (processor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/find/findUsages/FindUsagesHandler.processElementUsages must not be null");
        }
        if (options == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/find/findUsages/FindUsagesHandler.processElementUsages must not be null");
        }
        if (options.isUsages) {
            ReferencesSearch.search((PsiElement)element, (SearchScope)options.searchScope, (boolean)false).forEach((Processor)new ReadActionProcessor<PsiReference>(){

                public boolean processInReadAction(PsiReference ref) {
                    TextRange rangeInElement = ref.getRangeInElement();
                    return processor.process((Object)new UsageInfo(ref.getElement(), rangeInElement.getStartOffset(), rangeInElement.getEndOffset(), false));
                }
            });
        }
        if (options.isSearchForTextOccurences && options.searchScope instanceof GlobalSearchScope) {
            this.processUsagesInText(element, processor, (GlobalSearchScope)options.searchScope);
        }
    }

    public void processUsagesInText(final @NotNull PsiElement element, @NotNull Processor<UsageInfo> processor, @NotNull GlobalSearchScope searchScope) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/find/findUsages/FindUsagesHandler.processUsagesInText must not be null");
        }
        if (processor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/find/findUsages/FindUsagesHandler.processUsagesInText must not be null");
        }
        if (searchScope == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/find/findUsages/FindUsagesHandler.processUsagesInText must not be null");
        }
        String stringToSearch = this.getStringToSearch(element);
        if (stringToSearch == null) {
            return;
        }
        final TextRange elementTextRange = (TextRange)ApplicationManager.getApplication().runReadAction((Computable)new Computable<TextRange>(){

            public TextRange compute() {
                if (!element.isValid()) {
                    return null;
                }
                return element.getTextRange();
            }
        });
        TextOccurrencesUtil.UsageInfoFactory factory = new TextOccurrencesUtil.UsageInfoFactory(){

            @Override
            public UsageInfo createUsageInfo(@NotNull PsiElement usage, int startOffset, int endOffset) {
                if (usage == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/find/findUsages/FindUsagesHandler$4.createUsageInfo must not be null");
                }
                if (elementTextRange != null && usage.getContainingFile() == element.getContainingFile() && elementTextRange.contains(startOffset) && elementTextRange.contains(endOffset)) {
                    return null;
                }
                return new UsageInfo(usage, startOffset, endOffset, true);
            }
        };
        TextOccurrencesUtil.processTextOccurences(element, stringToSearch, searchScope, processor, factory);
    }

    protected String getStringToSearch(PsiElement element) {
        if (element instanceof PsiNamedElement) {
            return ((PsiNamedElement)element).getName();
        }
        return element.getText();
    }

    protected boolean isSearchForTextOccurencesAvailable(PsiElement psiElement, boolean isSingleFile) {
        return false;
    }

    public Collection<PsiReference> findReferencesToHighlight(PsiElement target, SearchScope searchScope) {
        return ReferencesSearch.search((PsiElement)target, (SearchScope)searchScope, (boolean)false).findAll();
    }
}

