/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.execution.configurations.RuntimeConfiguration;
import com.intellij.execution.testframework.TestFrameworkPropertyListener;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.util.StoringPropertyContainer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.config.BooleanProperty;
import com.intellij.util.config.Storage;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class TestConsoleProperties
extends StoringPropertyContainer
implements Disposable {
    public static final BooleanProperty SCROLL_TO_STACK_TRACE = new BooleanProperty("scrollToStackTrace", false);
    public static final BooleanProperty SELECT_FIRST_DEFECT = new BooleanProperty("selectFirtsDefect", false);
    public static final BooleanProperty TRACK_RUNNING_TEST = new BooleanProperty("trackRunningTest", true);
    public static final BooleanProperty HIDE_PASSED_TESTS = new BooleanProperty("hidePassedTests", true);
    public static final BooleanProperty SCROLL_TO_SOURCE = new BooleanProperty("scrollToSource", false);
    public static final BooleanProperty OPEN_FAILURE_LINE = new BooleanProperty("openFailureLine", false);
    public static final BooleanProperty TRACK_CODE_COVERAGE = new BooleanProperty("trackCodeCoverage", false);
    public static final BooleanProperty SHOW_STATISTICS = new BooleanProperty("showStatistics", false);
    private final Project myProject;
    private ConsoleView myConsole;
    protected final HashMap<AbstractProperty, ArrayList<TestFrameworkPropertyListener>> myListeners = new HashMap();

    public TestConsoleProperties(Storage storage, Project project) {
        super(storage);
        this.myProject = project;
    }

    public Project getProject() {
        return this.myProject;
    }

    public GlobalSearchScope getScope() {
        Module[] modules = this.getConfiguration().getModules();
        if (modules.length == 0) {
            return GlobalSearchScope.allScope((Project)this.myProject);
        }
        GlobalSearchScope scope = GlobalSearchScope.EMPTY_SCOPE;
        for (Module each : modules) {
            scope = scope.uniteWith(GlobalSearchScope.moduleRuntimeScope((Module)each, (boolean)true));
        }
        return scope;
    }

    public <T> void addListener(AbstractProperty<T> property, TestFrameworkPropertyListener<T> listener) {
        ArrayList<TestFrameworkPropertyListener<Object>> listeners = this.myListeners.get(property);
        if (listeners == null) {
            listeners = new ArrayList();
            this.myListeners.put(property, listeners);
        }
        listeners.add(listener);
    }

    public <T> void addListenerAndSendValue(AbstractProperty<T> property, TestFrameworkPropertyListener<T> listener) {
        this.addListener(property, listener);
        listener.onChanged(property.get((AbstractProperty.AbstractPropertyContainer)this));
    }

    public <T> void removeListener(AbstractProperty<T> property, TestFrameworkPropertyListener listener) {
        ArrayList<TestFrameworkPropertyListener> listeners = this.myListeners.get(property);
        if (listeners != null) {
            listeners.remove(listener);
        }
    }

    public abstract boolean isDebug();

    public abstract boolean isPaused();

    @Override
    protected <T> void onPropertyChanged(AbstractProperty<T> property, T value) {
        Object[] propertyListeners;
        ArrayList<TestFrameworkPropertyListener> listeners = this.myListeners.get(property);
        if (listeners == null) {
            return;
        }
        for (Object propertyListener : propertyListeners = listeners.toArray()) {
            TestFrameworkPropertyListener listener = (TestFrameworkPropertyListener)propertyListener;
            listener.onChanged(value);
        }
    }

    public void setConsole(ConsoleView console) {
        this.myConsole = console;
    }

    public void dispose() {
        this.myListeners.clear();
    }

    public abstract RuntimeConfiguration getConfiguration();

    protected ExecutionConsole getConsole() {
        return this.myConsole;
    }
}

