/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.execution.console.LanguageConsoleViewImpl;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.CommandLineArgumentsProvider;
import com.intellij.execution.process.ConsoleHistoryModel;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.ide.CommonActionsManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.PairProcessor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractConsoleRunnerWithHistory {
    protected final Project myProject;
    protected final String myConsoleTitle;
    protected OSProcessHandler myProcessHandler;
    protected final CommandLineArgumentsProvider myProvider;
    protected final String myWorkingDir;
    protected LanguageConsoleViewImpl myConsoleView;
    private final ConsoleHistoryModel myHistory;
    private AnAction myRunAction;

    public AbstractConsoleRunnerWithHistory(@NotNull Project project, @NotNull String consoleTitle, @NotNull CommandLineArgumentsProvider provider, @Nullable String workingDir) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/runners/AbstractConsoleRunnerWithHistory.<init> must not be null");
        }
        if (consoleTitle == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/execution/runners/AbstractConsoleRunnerWithHistory.<init> must not be null");
        }
        if (provider == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/execution/runners/AbstractConsoleRunnerWithHistory.<init> must not be null");
        }
        this.myHistory = new ConsoleHistoryModel();
        this.myProject = project;
        this.myConsoleTitle = consoleTitle;
        this.myProvider = provider;
        this.myWorkingDir = workingDir;
    }

    public void initAndRun() throws ExecutionException {
        Process process = this.createProcess();
        this.myConsoleView = this.createConsoleView();
        this.myProcessHandler = this.createProcessHandler(process);
        ProcessTerminatedListener.attach((ProcessHandler)this.myProcessHandler);
        this.myProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(ProcessEvent event) {
                AbstractConsoleRunnerWithHistory.this.myRunAction.getTemplatePresentation().setEnabled(false);
                AbstractConsoleRunnerWithHistory.this.myConsoleView.getConsole().setPrompt("");
                AbstractConsoleRunnerWithHistory.this.myConsoleView.getConsole().getConsoleEditor().setRendererMode(true);
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AbstractConsoleRunnerWithHistory.this.myConsoleView.getConsole().getConsoleEditor().getComponent().updateUI();
                    }
                });
            }
        });
        this.myConsoleView.attachToProcess((ProcessHandler)this.myProcessHandler);
        Executor defaultExecutor = ExecutorRegistry.getInstance().getExecutorById(DefaultRunExecutor.EXECUTOR_ID);
        DefaultActionGroup toolbarActions = new DefaultActionGroup();
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)toolbarActions, false);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)actionToolbar.getComponent(), "West");
        panel.add((Component)this.myConsoleView.getComponent(), "Center");
        RunContentDescriptor myDescriptor = new RunContentDescriptor((ExecutionConsole)this.myConsoleView, (ProcessHandler)this.myProcessHandler, (JComponent)panel, this.myConsoleTitle);
        AnAction[] actions = this.fillToolBarActions(toolbarActions, defaultExecutor, myDescriptor);
        this.registerActionShortcuts(actions, this.getLanguageConsole().getConsoleEditor().getComponent());
        this.registerActionShortcuts(actions, panel);
        panel.updateUI();
        ExecutionManager.getInstance((Project)this.myProject).getContentManager().showRunContent(defaultExecutor, myDescriptor);
        ToolWindow window = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(defaultExecutor.getId());
        window.activate(new Runnable(){

            @Override
            public void run() {
                IdeFocusManager.getInstance((Project)AbstractConsoleRunnerWithHistory.this.myProject).requestFocus((Component)AbstractConsoleRunnerWithHistory.this.getLanguageConsole().getCurrentEditor().getContentComponent(), true);
            }
        });
        this.myProcessHandler.startNotify();
    }

    protected abstract LanguageConsoleViewImpl createConsoleView();

    @Nullable
    protected abstract Process createProcess() throws ExecutionException;

    protected abstract OSProcessHandler createProcessHandler(Process var1);

    private void registerActionShortcuts(AnAction[] actions, JComponent component) {
        for (AnAction action : actions) {
            if (action.getShortcutSet() == null) continue;
            action.registerCustomShortcutSet(action.getShortcutSet(), component);
        }
    }

    protected AnAction[] fillToolBarActions(DefaultActionGroup toolbarActions, Executor defaultExecutor, RunContentDescriptor myDescriptor) {
        AnAction stopAction = this.createStopAction();
        toolbarActions.add(stopAction);
        AnAction closeAction = this.createCloseAction(defaultExecutor, myDescriptor);
        toolbarActions.add(closeAction);
        this.myRunAction = new DumbAwareAction(null, null, IconLoader.getIcon((String)"/actions/execute.png")){

            public void actionPerformed(AnActionEvent e) {
                AbstractConsoleRunnerWithHistory.this.runExecuteActionInner();
            }

            public void update(AnActionEvent e) {
                EditorEx editor = AbstractConsoleRunnerWithHistory.this.getLanguageConsole().getConsoleEditor();
                Lookup lookup = LookupManager.getActiveLookup(editor);
                e.getPresentation().setEnabled(!AbstractConsoleRunnerWithHistory.this.myProcessHandler.isProcessTerminated() && (lookup == null || !lookup.isCompletion()));
            }
        };
        EmptyAction.setupAction((AnAction)this.myRunAction, (String)"Console.Execute", null);
        toolbarActions.add(this.myRunAction);
        toolbarActions.add(CommonActionsManager.getInstance().createHelpAction("interactive_console"));
        PairProcessor<AnActionEvent, String> historyProcessor = new PairProcessor<AnActionEvent, String>(){

            public boolean process(AnActionEvent e, final String s) {
                new WriteCommandAction(AbstractConsoleRunnerWithHistory.this.myProject, new PsiFile[]{AbstractConsoleRunnerWithHistory.this.getLanguageConsole().getFile()}){

                    protected void run(Result result) throws Throwable {
                        AbstractConsoleRunnerWithHistory.this.getLanguageConsole().getEditorDocument().setText((CharSequence)(s == null ? "" : s));
                    }
                }.execute();
                return true;
            }
        };
        AnAction historyNextAction = ConsoleHistoryModel.createHistoryAction(this.myHistory, true, historyProcessor);
        AnAction historyPrevAction = ConsoleHistoryModel.createHistoryAction(this.myHistory, false, historyProcessor);
        historyNextAction.getTemplatePresentation().setVisible(false);
        historyPrevAction.getTemplatePresentation().setVisible(false);
        toolbarActions.add(historyNextAction);
        toolbarActions.add(historyPrevAction);
        return new AnAction[]{stopAction, closeAction, this.myRunAction, historyNextAction, historyPrevAction};
    }

    protected AnAction createCloseAction(Executor defaultExecutor, RunContentDescriptor myDescriptor) {
        return new CloseAction(defaultExecutor, myDescriptor, this.myProject);
    }

    protected AnAction createStopAction() {
        return ActionManager.getInstance().getAction("Stop");
    }

    public void sendInput(String input) {
        Charset charset = this.myProcessHandler.getCharset();
        OutputStream outputStream = this.myProcessHandler.getProcessInput();
        try {
            byte[] bytes = input.getBytes(charset.name());
            outputStream.write(bytes);
            outputStream.flush();
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public LanguageConsoleImpl getLanguageConsole() {
        return this.myConsoleView.getConsole();
    }

    protected void runExecuteActionInner() {
        Document document = this.getLanguageConsole().getCurrentEditor().getDocument();
        String documentText = document.getText();
        TextRange range = new TextRange(0, document.getTextLength());
        this.getLanguageConsole().getCurrentEditor().getSelectionModel().setSelection(range.getStartOffset(), range.getEndOffset());
        this.getLanguageConsole().addCurrentToHistory(range, false);
        this.getLanguageConsole().setInputText("");
        String line = documentText;
        if (!StringUtil.isEmptyOrSpaces((String)line)) {
            this.myHistory.addToHistory(line);
        }
        String text2send = line.length() == 0 ? "\n\n" : line + "\n";
        this.sendInput(text2send);
    }

    protected static String getProviderCommandLine(CommandLineArgumentsProvider provider) {
        StringBuilder builder = new StringBuilder();
        for (String s : provider.getArguments()) {
            if (builder.length() > 0) {
                builder.append(' ');
            }
            builder.append(s);
        }
        return builder.toString();
    }

    public Project getProject() {
        return this.myProject;
    }
}

