/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeExpression;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.FieldDescriptor;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.render.ClassRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.StringBuilderSpinAllocator;
import com.sun.jdi.Field;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.TypeComponent;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;

public class FieldDescriptorImpl
extends ValueDescriptorImpl
implements FieldDescriptor {
    public static final String OUTER_LOCAL_VAR_FIELD_PREFIX = "val$";
    private final Field myField;
    private final ObjectReference myObject;
    private Boolean myIsPrimitive;
    private final boolean myIsStatic;

    public FieldDescriptorImpl(Project project, ObjectReference objRef, @NotNull Field field) {
        if (field == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/debugger/ui/impl/watch/FieldDescriptorImpl.<init> must not be null");
        }
        super(project);
        this.myIsPrimitive = null;
        this.myObject = objRef;
        this.myField = field;
        this.myIsStatic = field.isStatic();
        this.setLvalue(!field.isFinal());
    }

    @Override
    public Field getField() {
        return this.myField;
    }

    @Override
    public ObjectReference getObject() {
        return this.myObject;
    }

    public SourcePosition getSourcePosition(Project project, DebuggerContextImpl context) {
        PsiField[] fields;
        if (context.getFrameProxy() == null) {
            return null;
        }
        ReferenceType type = this.myField.declaringType();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        String fieldName = this.myField.name();
        if (fieldName.startsWith(OUTER_LOCAL_VAR_FIELD_PREFIX)) {
            String varName = fieldName.substring(fieldName.lastIndexOf(36) + 1);
            PsiElement element = PositionUtil.getContextElement((StackFrameContext)context);
            if (element == null) {
                return null;
            }
            PsiClass aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class, (boolean)false);
            if (aClass == null) {
                return null;
            }
            aClass = (PsiClass)aClass.getNavigationElement();
            PsiVariable psiVariable = facade.getResolveHelper().resolveReferencedVariable(varName, (PsiElement)aClass);
            if (psiVariable == null) {
                return null;
            }
            return SourcePosition.createFromOffset((PsiFile)psiVariable.getContainingFile(), (int)psiVariable.getTextOffset());
        }
        PsiClass aClass = facade.findClass(type.name().replace('$', '.'), GlobalSearchScope.allScope((Project)this.myProject));
        if (aClass == null) {
            return null;
        }
        aClass = (PsiClass)aClass.getNavigationElement();
        for (PsiField field : fields = aClass.getFields()) {
            if (!fieldName.equals(field.getName())) continue;
            return SourcePosition.createFromOffset((PsiFile)field.getContainingFile(), (int)field.getTextOffset());
        }
        return null;
    }

    @Override
    public void setAncestor(NodeDescriptor oldDescriptor) {
        super.setAncestor(oldDescriptor);
        Boolean isPrimitive = ((FieldDescriptorImpl)oldDescriptor).myIsPrimitive;
        if (isPrimitive != null) {
            this.myIsPrimitive = isPrimitive;
        }
    }

    @Override
    public boolean isPrimitive() {
        if (this.myIsPrimitive == null) {
            Value value = this.getValue();
            this.myIsPrimitive = value != null ? Boolean.valueOf(super.isPrimitive()) : (DebuggerUtils.isPrimitiveType((String)this.myField.typeName()) ? Boolean.TRUE : Boolean.FALSE);
        }
        return this.myIsPrimitive;
    }

    @Override
    public Value calcValue(EvaluationContextImpl evaluationContext) throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        try {
            return this.myObject != null ? this.myObject.getValue(this.myField) : this.myField.declaringType().getValue(this.myField);
        }
        catch (ObjectCollectedException e) {
            throw EvaluateExceptionUtil.OBJECT_WAS_COLLECTED;
        }
    }

    public boolean isStatic() {
        return this.myIsStatic;
    }

    @Override
    public String getName() {
        String fieldName = this.myField.name();
        return this.isOuterLocalVariableValue() ? fieldName.substring(OUTER_LOCAL_VAR_FIELD_PREFIX.length()) : fieldName;
    }

    public boolean isOuterLocalVariableValue() {
        try {
            return DebuggerUtils.isSynthetic((TypeComponent)this.myField) && this.myField.name().startsWith(OUTER_LOCAL_VAR_FIELD_PREFIX);
        }
        catch (UnsupportedOperationException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String calcValueName() {
        ClassRenderer classRenderer = NodeRendererSettings.getInstance().getClassRenderer();
        StringBuilder buf = StringBuilderSpinAllocator.alloc();
        try {
            buf.append(this.getName());
            if (classRenderer.SHOW_DECLARED_TYPE) {
                buf.append(": ");
                buf.append(this.myField.typeName());
            }
            String string = buf.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)buf);
        }
    }

    @Override
    public PsiExpression getDescriptorEvaluation(DebuggerContext context) throws EvaluateException {
        String fieldName;
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)context.getProject()).getElementFactory();
        if (this.isStatic()) {
            String typeName = this.myField.declaringType().name().replace('$', '.');
            typeName = DebuggerTreeNodeExpression.normalize(typeName, PositionUtil.getContextElement((StackFrameContext)context), context.getProject());
            fieldName = typeName + "." + this.getName();
        } else {
            fieldName = this.isOuterLocalVariableValue() ? this.getName() : "this." + this.getName();
        }
        try {
            return elementFactory.createExpressionFromText(fieldName, null);
        }
        catch (IncorrectOperationException e) {
            throw new EvaluateException(DebuggerBundle.message((String)"error.invalid.field.name", (Object[])new Object[]{this.getName()}), (Throwable)e);
        }
    }
}

