/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.InstanceFilter;
import com.intellij.debugger.ui.InstanceFilterEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.classFilter.ClassFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class EditInstanceFiltersDialog
extends DialogWrapper {
    private InstanceFilterEditor myInstanceFilterEditor;
    private final Project myProject;

    public EditInstanceFiltersDialog(Project project) {
        super(project, true);
        this.myProject = project;
        this.setTitle(DebuggerBundle.message((String)"instance.filters.dialog.title", (Object[])new Object[0]));
        this.init();
    }

    protected JComponent createCenterPanel() {
        JPanel contentPanel = new JPanel(new BorderLayout());
        Box mainPanel = Box.createHorizontalBox();
        this.myInstanceFilterEditor = new InstanceFilterEditor(this.myProject);
        this.myInstanceFilterEditor.setPreferredSize(new Dimension(400, 200));
        this.myInstanceFilterEditor.setBorder(IdeBorderFactory.createTitledBorder((String)DebuggerBundle.message((String)"instance.filters.dialog.instance.filters.group", (Object[])new Object[0])));
        mainPanel.add((Component)((Object)this.myInstanceFilterEditor));
        contentPanel.add((Component)mainPanel, "Center");
        return contentPanel;
    }

    public void dispose() {
        this.myInstanceFilterEditor.stopEditing();
        super.dispose();
    }

    public void setFilters(InstanceFilter[] filters) {
        ClassFilter[] cFilters = InstanceFilter.createClassFilters(filters);
        this.myInstanceFilterEditor.setFilters(cFilters);
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.debugger.ui.breakpoints.EditInstanceFiltersDialog";
    }

    public InstanceFilter[] getFilters() {
        ClassFilter[] cFilters = this.myInstanceFilterEditor.getFilters();
        InstanceFilter[] ifilters = new InstanceFilter[cFilters.length];
        for (int i = 0; i < ifilters.length; ++i) {
            ifilters[i] = InstanceFilter.create(cFilters[i]);
        }
        return ifilters;
    }
}

